/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities;

import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.TrinketContainerStorage;
import xzeroair.trinkets.capabilities.TileEntityCap.ManaEssenceProperties;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.capabilities.statushandler.StatusHandler;
import xzeroair.trinkets.container.TrinketContainerHandler;

public class Capabilities {
    @CapabilityInject(value=EntityProperties.class)
    public static Capability<EntityProperties> ENTITY_RACE;
    @CapabilityInject(value=MagicStats.class)
    public static Capability<MagicStats> ENTITY_MAGIC;
    @CapabilityInject(value=StatusHandler.class)
    public static Capability<StatusHandler> STATUS_HANDLER;
    @CapabilityInject(value=TrinketProperties.class)
    public static Capability<TrinketProperties> ITEM_TRINKET;
    @CapabilityInject(value=VipStatus.class)
    public static Capability<VipStatus> VIP_STATUS;
    @CapabilityInject(value=ManaEssenceProperties.class)
    public static Capability<ManaEssenceProperties> TILE_ENTITY_MANA_ESSENCE;

    public static void init() {
        Capabilities.registerNewCap(ITrinketContainerHandler.class, TrinketContainerStorage.storage, new TrinketContainerFactory());
        Capabilities.registerNewCap(EntityProperties.class);
        Capabilities.registerNewCap(MagicStats.class);
        Capabilities.registerNewCap(StatusHandler.class);
        Capabilities.registerNewCap(VipStatus.class);
        Capabilities.registerNewCap(TrinketProperties.class);
        Capabilities.registerNewCap(ManaEssenceProperties.class);
    }

    public static ManaEssenceProperties getTileEntityManaProperties(TileEntity te) {
        return (ManaEssenceProperties)te.getCapability(TILE_ENTITY_MANA_ESSENCE, null);
    }

    public static StatusHandler getStatusHandler(Entity entity) {
        if (entity == null) {
            return null;
        }
        return (StatusHandler)entity.getCapability(STATUS_HANDLER, null);
    }

    public static EntityProperties getEntityRace(Entity entity) {
        if (entity == null) {
            return null;
        }
        return (EntityProperties)entity.getCapability(ENTITY_RACE, null);
    }

    public static TrinketProperties getTrinketProperties(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return null;
        }
        return (TrinketProperties)stack.getCapability(ITEM_TRINKET, null);
    }

    public static VipStatus getVipStatus(Entity entity) {
        if (entity == null) {
            return null;
        }
        return (VipStatus)entity.getCapability(VIP_STATUS, null);
    }

    public static MagicStats getMagicStats(Entity entity) {
        if (entity == null) {
            return null;
        }
        return (MagicStats)entity.getCapability(ENTITY_MAGIC, null);
    }

    private static <T> void registerNewCap(Class<T> type) {
        Capabilities.registerNewCap(type, new Capability.IStorage<T>(){

            public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        });
    }

    private static <T> void registerNewCap(Class<T> type, Capability.IStorage<T> storage) {
        Capabilities.registerNewCap(type, storage, () -> null);
    }

    private static <T> void registerNewCap(Class<T> type, Capability.IStorage<T> storage, Callable<? extends T> factory) {
        CapabilityManager.INSTANCE.register(type, storage, factory);
    }

    private static class TrinketContainerFactory
    implements Callable<ITrinketContainerHandler> {
        private TrinketContainerFactory() {
        }

        @Override
        public ITrinketContainerHandler call() throws Exception {
            return new TrinketContainerHandler();
        }
    }
}

