/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.Trinket;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.CapabilityBase;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.SyncItemDataPacket;
import xzeroair.trinkets.util.handlers.TickHandler;

public class TrinketProperties
extends CapabilityBase<TrinketProperties, ItemStack> {
    int target = -1;
    int slot = -1;
    int count = 0;
    int exp = 0;
    int mana = 0;
    boolean mainAbility = false;
    boolean altAbility = false;
    int playerStatus = -1;
    int handler = 0;
    Map<String, TickHandler> Counters = new HashMap<String, TickHandler>();

    public TrinketProperties(ItemStack stack) {
        super(stack);
    }

    @Override
    public NBTTagCompound getTag() {
        return super.getTag();
    }

    public void itemRightClicked() {
    }

    public void itemLeftClicked() {
    }

    public void itemUsed() {
    }

    @Override
    public void onUpdate() {
    }

    public void itemEquipped(EntityLivingBase e, int slot, int handler) {
        this.handler = handler;
        this.slot = slot;
        VipStatus status = Capabilities.getVipStatus((Entity)e);
        if (status != null) {
            this.playerStatus = status.getStatus();
        }
        this.saveNBT();
        try {
            World world = e.func_130014_f_();
            if (!world.field_72995_K && world instanceof WorldServer) {
                WorldServer w = (WorldServer)world;
                NetworkHandler.sendToClients(w, e.func_180425_c(), new SyncItemDataPacket(e, (ItemStack)this.object, ((ItemStack)this.object).func_77978_p(), slot, handler, true, true));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void itemUnequipped(EntityLivingBase e) {
        ItemStack stack = this.getStackFromSlot(e, this.slot, this.handler);
        if (!stack.func_190926_b() && stack.func_77969_a((ItemStack)this.object)) {
            return;
        }
        try {
            World world = e.func_130014_f_();
            if (!world.field_72995_K && world instanceof WorldServer) {
                WorldServer w = (WorldServer)world;
                NetworkHandler.sendToClients(w, e.func_180425_c(), new SyncItemDataPacket(e, (ItemStack)this.object, ((ItemStack)this.object).func_77978_p(), this.slot, this.handler, true, false));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.slot = -1;
        this.playerStatus = -1;
        this.handler = 0;
        this.saveNBT();
        this.clearCounters();
    }

    public void turnOff() {
        this.toggleMainAbility(false);
        this.toggleAltAbility(false);
        this.setTarget(-1);
    }

    public boolean isEquipped(EntityLivingBase e) {
        return ItemStack.func_179545_c((ItemStack)((ItemStack)this.object), (ItemStack)this.getStackFromSlot(e, this.slot, this.handler));
    }

    public ItemStack getStackFromSlot(EntityLivingBase e, int slot, int handler) {
        return TrinketHelper.getItemStackFromSlot(e, slot, handler);
    }

    private void saveNBT() {
        NBTTagCompound tag = this.getTagCompoundSafe((ItemStack)this.object);
        this.saveToNBT(tag);
    }

    public void sendInformationToPlayer(EntityLivingBase e, EntityLivingBase receiver) {
        if (!e.func_130014_f_().field_72995_K && receiver instanceof EntityPlayer) {
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            NetworkHandler.sendTo(new SyncItemDataPacket(e, (ItemStack)this.object, tag, this.slot, this.handler), (EntityPlayerMP)receiver);
        }
    }

    public void sendInformationToServer(EntityLivingBase e) {
        if (e.func_130014_f_().field_72995_K) {
            NetworkHandler.sendToServer(new SyncItemDataPacket(e, (ItemStack)this.object, ((ItemStack)this.object).func_77978_p(), this.slot, this.handler));
        }
    }

    public void sendInformationToTracking(EntityLivingBase e) {
        World world = e.func_130014_f_();
        if (!world.field_72995_K && world instanceof WorldServer) {
            WorldServer w = (WorldServer)world;
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            NetworkHandler.sendToClients(w, e.func_180425_c(), new SyncItemDataPacket(e, (ItemStack)this.object, tag, this.slot, this.handler));
        }
    }

    public boolean mainAbility() {
        return this.mainAbility;
    }

    public void toggleMainAbility(boolean bool) {
        this.mainAbility = bool;
    }

    public boolean altAbility() {
        return this.altAbility;
    }

    public void toggleAltAbility(boolean bool) {
        this.altAbility = bool;
    }

    public int Target() {
        return this.target;
    }

    public void setTarget(int integer) {
        if (this.target != integer) {
            this.target = integer;
            this.saveNBT();
        }
    }

    public int Count() {
        return this.count;
    }

    public void setCount(int integer) {
        if (this.count != integer) {
            this.count = integer;
            this.saveNBT();
        }
    }

    public int StoredExp() {
        return this.exp;
    }

    public void setStoredExp(int integer) {
        if (this.exp != integer) {
            this.exp = integer;
            this.saveNBT();
        }
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int integer) {
        if (this.slot != integer) {
            this.slot = integer;
            this.saveNBT();
        }
    }

    public int getHandler() {
        return this.handler;
    }

    public void setHandler(int integer) {
        if (this.handler != integer) {
            this.handler = integer;
            this.saveNBT();
        }
    }

    public int StoredMana() {
        return this.mana;
    }

    public void setStoredMana(int integer) {
        if (this.mana != integer) {
            this.mana = integer;
            this.saveNBT();
        }
    }

    public NBTTagCompound getTagCompoundSafe(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        compound.func_74768_a("target", this.target);
        compound.func_74768_a("slot", this.slot);
        compound.func_74768_a("handler", this.handler);
        compound.func_74768_a("hitcount", this.count);
        compound.func_74768_a("exp", this.exp);
        compound.func_74768_a("mana", this.mana);
        compound.func_74757_a("main.ability", this.mainAbility);
        compound.func_74757_a("alt.ability", this.altAbility);
        compound.func_74768_a("player.status", this.playerStatus);
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("target")) {
            this.target = compound.func_74762_e("target");
        }
        if (compound.func_74764_b("slot")) {
            this.slot = compound.func_74762_e("slot");
        }
        if (compound.func_74764_b("handler")) {
            this.handler = compound.func_74762_e("handler");
        }
        if (compound.func_74764_b("hitcount")) {
            this.count = compound.func_74762_e("hitcount");
        }
        if (compound.func_74764_b("exp")) {
            this.exp = compound.func_74762_e("exp");
        }
        if (compound.func_74764_b("mana")) {
            this.mana = compound.func_74762_e("mana");
        }
        if (compound.func_74764_b("main.ability")) {
            this.mainAbility = compound.func_74767_n("main.ability");
        }
        if (compound.func_74764_b("alt.ability")) {
            this.altAbility = compound.func_74767_n("alt.ability");
        }
        if (compound.func_74764_b("player.status")) {
            this.playerStatus = compound.func_74762_e("player.status");
        }
    }
}

