/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.magic;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import xzeroair.trinkets.attributes.MagicAttributes;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.CapabilityBase;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.mana.SyncManaCostToHudPacket;
import xzeroair.trinkets.network.mana.SyncManaStatsPacket;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.config.mana.EntityManaConfig;

public class MagicStats
extends CapabilityBase<MagicStats, EntityLivingBase> {
    private static final EntityManaConfig manaConfig = TrinketsConfig.SERVER.mana;
    private float mana = 100.0f;
    private float maxMana = 100.0f;
    private int bonusMana = 0;
    private int racialBonus = 100;
    private boolean sync = false;
    private int manaUpdateTickRate = 0;
    private int manaRegenTimeout = 0;

    public MagicStats(EntityLivingBase e) {
        super(e);
    }

    @Override
    public NBTTagCompound getTag() {
        return super.getTag();
    }

    @Override
    public void onUpdate() {
        boolean isCreative;
        boolean bl = isCreative = this.object instanceof EntityPlayer && (((EntityPlayer)this.object).func_184812_l_() || ((EntityPlayer)this.object).func_175149_v());
        if (!TrinketsConfig.SERVER.mana.mana_enabled || isCreative) {
            this.refillMana();
            return;
        }
        if (((EntityLivingBase)this.object).func_130014_f_().field_72995_K) {
            this.sync = false;
            return;
        }
        if (this.manaRegenTimeout > 0) {
            --this.manaRegenTimeout;
            return;
        }
        this.manaRegenTimeout = 0;
        if (this.getMana() > this.getMaxMana()) {
            this.setMana(this.getMaxMana());
        }
        if (this.getMana() < this.getMaxMana()) {
            ++this.manaUpdateTickRate;
            if (this.manaUpdateTickRate > MagicStats.manaConfig.mana_update_ticks) {
                IAttributeInstance attribute = ((EntityLivingBase)this.object).func_110140_aT().func_111151_a(MagicAttributes.regen);
                if (attribute != null) {
                    this.addMana((float)attribute.func_111126_e());
                } else {
                    this.addMana(1.0f);
                }
                this.manaUpdateTickRate = 0;
            }
        }
        if (this.sync) {
            this.sync = false;
            this.refillMana();
        }
    }

    public void refillMana() {
        if (this.getMana() != this.getMaxMana()) {
            this.setMana(this.getMaxMana());
        }
    }

    public float getMana() {
        return this.mana;
    }

    public void setMana(float mana) {
        this.mana = mana > this.getMaxMana() ? this.getMaxMana() : (mana < 0.0f ? 0.0f : mana);
        this.sendManaToPlayer((EntityLivingBase)this.object);
    }

    public void addMana(float mana) {
        this.setMana(this.mana + mana);
    }

    public boolean spendMana(float cost) {
        boolean isCreative = this.object instanceof EntityPlayer && (((EntityPlayer)this.object).func_184812_l_() || ((EntityPlayer)this.object).func_175149_v());
        boolean spend = true;
        if (isCreative || !TrinketsConfig.SERVER.mana.mana_enabled) {
            return true;
        }
        if (cost <= this.getMana()) {
            spend = true;
        } else {
            spend = false;
            if (this.object instanceof EntityPlayer && ((EntityLivingBase)this.object).field_70170_p.field_72995_K) {
                String Message = "No MP";
                ((EntityPlayer)this.object).func_146105_b((ITextComponent)new TextComponentString("No MP"), true);
            }
        }
        if (spend) {
            this.setMana(this.mana - cost);
            this.setManaRegenTimeout();
        }
        return spend;
    }

    public float getMaxMana() {
        float maxAffinityBonus = this.maxMana * ((float)this.getRacialAffinity() * 0.01f) - this.maxMana;
        float maxBonus = this.maxMana + 10.0f * (float)this.getBonusMana();
        float max = maxAffinityBonus + maxBonus;
        if (MagicStats.manaConfig.mana_cap) {
            if (MagicStats.manaConfig.cap_affinity) {
                return MathHelper.func_76131_a((float)max, (float)0.0f, (float)MagicStats.manaConfig.mana_max);
            }
            return MathHelper.func_76131_a((float)maxBonus, (float)0.0f, (float)MagicStats.manaConfig.mana_max) + maxAffinityBonus;
        }
        return max;
    }

    public int getBonusMana() {
        return this.bonusMana;
    }

    public boolean needMana() {
        return this.mana < this.getMaxMana();
    }

    public void setBonusMana(int bonus) {
        this.bonusMana = bonus < 0 ? 0 : bonus;
        this.sendManaToPlayer((EntityLivingBase)this.object);
    }

    public void setManaRegenTimeout() {
        this.setManaRegenTimeout(MagicStats.manaConfig.mana_regen_timeout);
    }

    public void setManaRegenTimeout(int timeout) {
        this.manaRegenTimeout = timeout;
    }

    public int getRacialAffinity() {
        EntityProperties race = Capabilities.getEntityRace((Entity)this.object);
        if (race != null) {
            this.racialBonus = race.getCurrentRace().getMagicAffinity();
        }
        return this.racialBonus;
    }

    public Map<String, ConfigHelper.ItemObjectHolder> getRecoveryItems() {
        return ConfigHelper.getMagicRecoveryItems();
    }

    public void sendManaToPlayer(EntityLivingBase e) {
        if (e instanceof EntityPlayerMP) {
            NetworkHandler.sendTo(new SyncManaStatsPacket((EntityLivingBase)this.object, this), (EntityPlayerMP)e);
        }
    }

    public void syncToManaCostToHud(float cost) {
        if (this.object instanceof EntityPlayer && !((EntityLivingBase)this.object).field_70170_p.field_72995_K) {
            NetworkHandler.sendTo(new SyncManaCostToHudPacket(cost), (EntityPlayerMP)this.object);
        }
    }

    @Override
    public void copyFrom(MagicStats stats, boolean wasDeath, boolean keepInv) {
        this.bonusMana = stats.bonusMana;
        this.mana = wasDeath ? (keepInv ? stats.mana : this.getMaxMana()) : stats.mana;
        this.sync = true;
    }

    @Override
    public void saveToNBT(NBTTagCompound tag) {
        tag.func_74776_a("mana", this.mana);
        tag.func_74768_a("bonus_mana", this.bonusMana);
    }

    @Override
    public void loadFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("mana")) {
            this.mana = tag.func_74760_g("mana");
        }
        if (tag.func_74764_b("bonus_mana")) {
            this.bonusMana = tag.func_74762_e("bonus_mana");
        }
    }
}

