/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.client.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;

public class CommandMana
extends CommandBase {
    private final List<String> tabCompletionsCommands = Arrays.asList("help", "setMP", "setMaxMP");
    private final String commandUsage = "/simpledifficulty help";
    private final String listOfCommands = "   help <command>\nsetMP <Amount>\nsetMaxMP <Amount>";
    private final String warn_notPlayerAdmin = "You do not have permission, or are not a player ingame!";
    private final String warn_invalidArgs = "Invalid Arguments";
    private final String warn_noItem = "Not holding an item!";
    private final String exportJsonReminder = "(Don't forget to exportJson !)";

    public List<String> func_71514_a() {
        return Arrays.asList("xat");
    }

    public String func_71517_b() {
        return "Trinkets and Baubles";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/simpledifficulty help";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandMana.func_175762_a((String[])args, this.tabCompletionsCommands);
        }
        if (args.length == 0) {
            return this.tabCompletionsCommands;
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.help(sender);
            return;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "help": {
                this.helpCommand(server, sender, args);
                break;
            }
            default: {
                this.help(sender);
            }
        }
    }

    private void helpCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 2) {
            this.message(sender, "   help <command>\nsetMP <Amount>\nsetMaxMP <Amount>");
            return;
        }
        switch (args[1].toLowerCase()) {
            case "help": {
                this.message(sender, "If you need more help, you can contact the mod author on CurseForge or GitHub");
                return;
            }
        }
        this.message(sender, "/xat help <command> \n(Replace <command> with a simpledifficulty command name)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMP(MinecraftServer server, ICommandSender sender, String[] args) {
        if (!this.isAdminPlayer(sender)) return;
        try {
            if (args.length < 2) {
                this.message(sender, "Invalid Arguments <modid>");
                return;
            }
            EntityPlayer player = (EntityPlayer)sender.func_174793_f();
            MagicStats capability = Capabilities.getMagicStats((Entity)player);
            capability.setMana(Float.parseFloat(args[1]));
            if (args.length < 3) return;
        }
        catch (NumberFormatException e) {
            this.message(sender, "Invalid Arguments <MP>");
            return;
        }
    }

    private int getMetadataFromStack(ItemStack stack) {
        return stack.func_77981_g() ? stack.func_77960_j() : -1;
    }

    private String getRegistryName(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString();
    }

    private boolean isAdminPlayer(ICommandSender sender) {
        return this.hasPermissionLevel(sender, 4) && sender.func_174793_f() instanceof EntityPlayer;
    }

    private void help(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
    }

    private void message(ICommandSender sender, String message) {
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    private boolean hasPermissionLevel(ICommandSender sender, int permLevel) {
        return sender.func_70003_b(permLevel, "Trinkets and Baubles");
    }

    private boolean hasNBTArgument(String[] input) {
        return this.hasArgument("--nbt", input);
    }

    private boolean hasClearArgument(String[] input) {
        return this.hasArgument("--clear", input);
    }

    private boolean hasArgument(String argument, String[] input) {
        if (input == null) {
            return false;
        }
        for (String s : input) {
            if (!s.equals(argument)) continue;
            return true;
        }
        return false;
    }
}

