/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.client.playerCamera;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Project;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;

@SideOnly(value=Side.CLIENT)
public class PlayerRaceCameraRendererOptifine
extends EntityRenderer {
    private final Minecraft mc;
    private final IResourceManager resourceManager;
    private float farPlaneDistance;
    private int rendererUpdateCount;
    private float fovModifierHand;
    private float fovModifierHandPrev;
    private float bossColorModifier;
    private float bossColorModifierPrev;
    private boolean cloudFog;
    private boolean renderHand = true;
    private boolean drawBlockOutline = true;
    private final DynamicTexture lightmapTexture;
    private final int[] lightmapColors;
    private boolean lightmapUpdateNeeded;
    private float torchFlickerX;
    private float torchFlickerDX;
    private int rainSoundCounter;
    private float fogColorRed;
    private float fogColorGreen;
    private float fogColorBlue;
    private float fogColor2;
    private float fogColor1;
    private int debugViewDirection;
    private boolean debugView;
    private double cameraZoom = 1.0;
    private double cameraYaw;
    private double cameraPitch;
    private int frameCount;
    float cameraDistance = 4.0f;

    public PlayerRaceCameraRendererOptifine(Minecraft mcIn, IResourceManager resourceManagerIn) {
        super(mcIn, resourceManagerIn);
        this.mc = mcIn;
        this.resourceManager = resourceManagerIn;
        this.lightmapTexture = new DynamicTexture(16, 16);
        this.lightmapColors = this.lightmapTexture.func_110565_c();
    }

    public void func_78464_a() {
        super.func_78464_a();
    }

    private void updateFovModifierHand() {
        float f = 1.0f;
        if (this.mc.func_175606_aa() instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)this.mc.func_175606_aa();
            f = abstractclientplayer.func_175156_o();
        }
        this.fovModifierHandPrev = this.fovModifierHand;
        this.fovModifierHand += (f - this.fovModifierHand) * 0.5f;
        if (this.fovModifierHand > 1.5f) {
            this.fovModifierHand = 1.5f;
        }
        if (this.fovModifierHand < 0.1f) {
            this.fovModifierHand = 0.1f;
        }
    }

    private float getFOVModifier(float partialTicks, boolean useFOVSetting) {
        IBlockState iblockstate;
        if (this.debugView) {
            return 90.0f;
        }
        Entity entity = this.mc.func_175606_aa();
        float f = 70.0f;
        if (useFOVSetting) {
            f = this.mc.field_71474_y.field_74334_X;
            f *= this.fovModifierHandPrev + (this.fovModifierHand - this.fovModifierHandPrev) * partialTicks;
        }
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_110143_aJ() <= 0.0f) {
            float f1 = (float)((EntityLivingBase)entity).field_70725_aQ + partialTicks;
            f /= (1.0f - 500.0f / (f1 + 500.0f)) * 2.0f + 1.0f;
        }
        if ((iblockstate = ActiveRenderInfo.func_186703_a((World)this.mc.field_71441_e, (Entity)entity, (float)partialTicks)).func_185904_a() == Material.field_151586_h) {
            f = f * 60.0f / 70.0f;
        }
        return ForgeHooksClient.getFOVModifier((EntityRenderer)this, (Entity)entity, (IBlockState)iblockstate, (double)partialTicks, (float)f);
    }

    private void hurtCameraEffect(float partialTicks) {
        if (this.mc.func_175606_aa() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.mc.func_175606_aa();
            float f = (float)entitylivingbase.field_70737_aN - partialTicks;
            if (entitylivingbase.func_110143_aJ() <= 0.0f) {
                float f1 = (float)entitylivingbase.field_70725_aQ + partialTicks;
                GlStateManager.func_179114_b((float)(40.0f - 8000.0f / (f1 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (f < 0.0f) {
                return;
            }
            f /= (float)entitylivingbase.field_70738_aO;
            f = MathHelper.func_76126_a((float)(f * f * f * f * (float)Math.PI));
            float f2 = entitylivingbase.field_70739_aP;
            GlStateManager.func_179114_b((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-f * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void applyBobbing(float partialTicks) {
        if (this.mc.func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this.mc.func_175606_aa();
            float f = entityplayer.field_70140_Q - entityplayer.field_70141_P;
            float f1 = -(entityplayer.field_70140_Q + f * partialTicks);
            float f2 = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * partialTicks;
            float f3 = entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * partialTicks;
            GlStateManager.func_179109_b((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.15f), (float)(-Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2) * 0.0f), (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)f3, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void orientCamera(float partialTicks) {
        Entity entity = this.mc.func_175606_aa();
        float f = entity.func_70047_e();
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + (double)f;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        double hitBlock = 0.0;
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70608_bn()) {
            f = (float)((double)f + 1.0);
            GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
            if (!this.mc.field_71474_y.field_74325_U) {
                BlockPos blockpos = new BlockPos(entity);
                IBlockState iblockstate = this.mc.field_71441_e.func_180495_p(blockpos);
                ForgeHooksClient.orientBedCamera((IBlockAccess)this.mc.field_71441_e, (BlockPos)blockpos, (IBlockState)iblockstate, (Entity)entity);
                GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks + 180.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)-1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.mc.field_71474_y.field_74320_O > 0) {
            EntityPlayerSP player = this.mc.field_71439_g;
            EntityProperties prop = Capabilities.getEntityRace((Entity)player);
            if (prop != null && (double)prop.getTargetSize() != 1.0) {
                float cameraScale = (float)(prop.getSize() * 100 / prop.getTargetSize()) * 0.01f;
                this.cameraDistance = 4.0f * ((float)prop.getTargetSize() * 0.01f) * cameraScale;
            }
            double d3 = this.cameraDistance + (this.cameraDistance - this.cameraDistance) * partialTicks;
            if (this.mc.field_71474_y.field_74325_U) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((float)(-d3)));
            } else {
                float f1 = entity.field_70177_z;
                float f2 = entity.field_70125_A;
                if (this.mc.field_71474_y.field_74320_O == 2) {
                    f2 += 180.0f;
                }
                float sq = (float)Math.PI / 180;
                double d4 = (double)(-MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
                double d5 = (double)(MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
                double d6 = (double)(-MathHelper.func_76126_a((float)(f2 * ((float)Math.PI / 180)))) * d3;
                for (int i = 0; i < 8; ++i) {
                    double d7;
                    RayTraceResult raytraceresult;
                    float f3 = (i & 1) * 2 - 1;
                    float f4 = (i >> 1 & 1) * 2 - 1;
                    float f5 = (i >> 2 & 1) * 2 - 1;
                    if ((raytraceresult = this.mc.field_71441_e.func_72933_a(new Vec3d(d0 + (double)(f3 *= 0.1f), d1 + (double)(f4 *= 0.1f), d2 + (double)(f5 *= 0.1f)), new Vec3d(d0 - d4 + (double)f3 + (double)f5, d1 - d6 + (double)f4, d2 - d5 + (double)f5))) == null) continue;
                    if (d6 < 0.0) {
                        hitBlock = MathHelper.func_151237_a((double)(-d6), (double)0.0, (double)0.111f);
                    }
                    if (!((d7 = raytraceresult.field_72307_f.func_72438_d(new Vec3d(d0, d1, d2))) < d3)) continue;
                    d3 = d7;
                }
                if (this.mc.field_71474_y.field_74320_O == 2) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GlStateManager.func_179114_b((float)(entity.field_70125_A - f2), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70177_z - f1), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((float)(-d3)));
                GlStateManager.func_179114_b((float)(f1 - entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(f2 - entity.field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.05f);
        }
        if (!this.mc.field_71474_y.field_74325_U) {
            float yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks + 180.0f;
            float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            float roll = 0.0f;
            if (entity instanceof EntityAnimal) {
                EntityAnimal entityanimal = (EntityAnimal)entity;
                yaw = entityanimal.field_70758_at + (entityanimal.field_70759_as - entityanimal.field_70758_at) * partialTicks + 180.0f;
            }
            IBlockState state = ActiveRenderInfo.func_186703_a((World)this.mc.field_71441_e, (Entity)entity, (float)partialTicks);
            EntityViewRenderEvent.CameraSetup event = new EntityViewRenderEvent.CameraSetup((EntityRenderer)this, entity, state, (double)partialTicks, yaw, pitch, 0.0f);
            MinecraftForge.EVENT_BUS.post((Event)event);
            GlStateManager.func_179114_b((float)event.getRoll(), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)event.getPitch(), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)event.getYaw(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179137_b((double)0.0, (double)(-((double)f - hitBlock)), (double)0.0);
        d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + (double)f;
        d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        this.cloudFog = this.mc.field_71438_f.func_72721_a(d0, d1, d2, partialTicks);
    }

    private void setupCameraTransform(float partialTicks, int pass) {
        float f1;
        this.farPlaneDistance = this.mc.field_71474_y.field_151451_c * 16;
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        float f = 0.07f;
        if (this.mc.field_71474_y.field_74337_g) {
            GlStateManager.func_179109_b((float)((float)(-(pass * 2 - 1)) * 0.07f), (float)0.0f, (float)0.0f);
        }
        if (this.cameraZoom != 1.0) {
            GlStateManager.func_179109_b((float)((float)this.cameraYaw), (float)((float)(-this.cameraPitch)), (float)0.0f);
            GlStateManager.func_179139_a((double)this.cameraZoom, (double)this.cameraZoom, (double)1.0);
        }
        Project.gluPerspective((float)this.getFOVModifier(partialTicks, true), (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(this.farPlaneDistance * MathHelper.field_180189_a));
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        if (this.mc.field_71474_y.field_74337_g) {
            GlStateManager.func_179109_b((float)((float)(pass * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        this.hurtCameraEffect(partialTicks);
        if (this.mc.field_71474_y.field_74336_f) {
            this.applyBobbing(partialTicks);
        }
        if ((f1 = this.mc.field_71439_g.field_71080_cy + (this.mc.field_71439_g.field_71086_bY - this.mc.field_71439_g.field_71080_cy) * partialTicks) > 0.0f) {
            int i = 20;
            if (this.mc.field_71439_g.func_70644_a(MobEffects.field_76431_k)) {
                i = 7;
            }
            float f2 = 5.0f / (f1 * f1 + 5.0f) - f1 * 0.04f;
            f2 *= f2;
            GlStateManager.func_179114_b((float)(((float)this.rendererUpdateCount + partialTicks) * (float)i), (float)0.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)(1.0f / f2), (float)1.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-((float)this.rendererUpdateCount + partialTicks) * (float)i), (float)0.0f, (float)1.0f, (float)1.0f);
        }
        this.orientCamera(partialTicks);
        if (this.debugView) {
            switch (this.debugViewDirection) {
                case 0: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 1: {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 2: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 3: {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 4: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }
    }

    private void renderHand(float partialTicks, int pass) {
        if (!this.debugView) {
            boolean flag;
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            float f = 0.07f;
            if (this.mc.field_71474_y.field_74337_g) {
                GlStateManager.func_179109_b((float)((float)(-(pass * 2 - 1)) * 0.07f), (float)0.0f, (float)0.0f);
            }
            Project.gluPerspective((float)this.getFOVModifier(partialTicks, false), (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            if (this.mc.field_71474_y.field_74337_g) {
                GlStateManager.func_179109_b((float)((float)(pass * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179094_E();
            this.hurtCameraEffect(partialTicks);
            if (this.mc.field_71474_y.field_74336_f) {
                this.applyBobbing(partialTicks);
            }
            boolean bl = flag = this.mc.func_175606_aa() instanceof EntityLivingBase && ((EntityLivingBase)this.mc.func_175606_aa()).func_70608_bn();
            if (!(ForgeHooksClient.renderFirstPersonHand((RenderGlobal)this.mc.field_71438_f, (float)partialTicks, (int)pass) || this.mc.field_71474_y.field_74320_O != 0 || flag || this.mc.field_71474_y.field_74319_N || this.mc.field_71442_b.func_78747_a())) {
                this.func_180436_i();
                this.field_78516_c.func_78440_a(partialTicks);
                this.func_175072_h();
            }
            GlStateManager.func_179121_F();
            if (this.mc.field_71474_y.field_74320_O == 0 && !flag) {
                this.field_78516_c.func_78447_b(partialTicks);
                this.hurtCameraEffect(partialTicks);
            }
            if (this.mc.field_71474_y.field_74336_f) {
                this.applyBobbing(partialTicks);
            }
        }
    }

    private void updateTorchFlicker() {
        this.torchFlickerDX = (float)((double)this.torchFlickerDX + (Math.random() - Math.random()) * Math.random() * Math.random());
        this.torchFlickerDX = (float)((double)this.torchFlickerDX * 0.9);
        this.torchFlickerX += this.torchFlickerDX - this.torchFlickerX;
        this.lightmapUpdateNeeded = true;
    }

    private void updateLightmap(float partialTicks) {
        if (this.lightmapUpdateNeeded) {
            this.mc.field_71424_I.func_76320_a("lightTex");
            WorldClient world = this.mc.field_71441_e;
            if (world != null) {
                float f = world.func_72971_b(1.0f);
                float f1 = f * 0.95f + 0.05f;
                for (int i = 0; i < 256; ++i) {
                    float f2 = world.field_73011_w.func_177497_p()[i / 16] * f1;
                    float f3 = world.field_73011_w.func_177497_p()[i % 16] * (this.torchFlickerX * 0.1f + 1.5f);
                    if (world.func_175658_ac() > 0) {
                        f2 = world.field_73011_w.func_177497_p()[i / 16];
                    }
                    float f4 = f2 * (f * 0.65f + 0.35f);
                    float f5 = f2 * (f * 0.65f + 0.35f);
                    float f6 = f3 * ((f3 * 0.6f + 0.4f) * 0.6f + 0.4f);
                    float f7 = f3 * (f3 * f3 * 0.6f + 0.4f);
                    float f8 = f4 + f3;
                    float f9 = f5 + f6;
                    float f10 = f2 + f7;
                    f8 = f8 * 0.96f + 0.03f;
                    f9 = f9 * 0.96f + 0.03f;
                    f10 = f10 * 0.96f + 0.03f;
                    if (this.bossColorModifier > 0.0f) {
                        float f11 = this.bossColorModifierPrev + (this.bossColorModifier - this.bossColorModifierPrev) * partialTicks;
                        f8 = f8 * (1.0f - f11) + f8 * 0.7f * f11;
                        f9 = f9 * (1.0f - f11) + f9 * 0.6f * f11;
                        f10 = f10 * (1.0f - f11) + f10 * 0.6f * f11;
                    }
                    if (world.field_73011_w.func_186058_p().func_186068_a() == 1) {
                        f8 = 0.22f + f3 * 0.75f;
                        f9 = 0.28f + f6 * 0.75f;
                        f10 = 0.25f + f7 * 0.75f;
                    }
                    float[] colors = new float[]{f8, f9, f10};
                    world.field_73011_w.getLightmapColors(partialTicks, f, f2, f3, colors);
                    f8 = colors[0];
                    f9 = colors[1];
                    f10 = colors[2];
                    f8 = MathHelper.func_76131_a((float)f8, (float)0.0f, (float)1.0f);
                    f9 = MathHelper.func_76131_a((float)f9, (float)0.0f, (float)1.0f);
                    f10 = MathHelper.func_76131_a((float)f10, (float)0.0f, (float)1.0f);
                    if (this.mc.field_71439_g.func_70644_a(MobEffects.field_76439_r)) {
                        float f15 = this.getNightVisionBrightness((EntityLivingBase)this.mc.field_71439_g, partialTicks);
                        float f12 = 1.0f / f8;
                        if (f12 > 1.0f / f9) {
                            f12 = 1.0f / f9;
                        }
                        if (f12 > 1.0f / f10) {
                            f12 = 1.0f / f10;
                        }
                        f8 = f8 * (1.0f - f15) + f8 * f12 * f15;
                        f9 = f9 * (1.0f - f15) + f9 * f12 * f15;
                        f10 = f10 * (1.0f - f15) + f10 * f12 * f15;
                    }
                    if (f8 > 1.0f) {
                        f8 = 1.0f;
                    }
                    if (f9 > 1.0f) {
                        f9 = 1.0f;
                    }
                    if (f10 > 1.0f) {
                        f10 = 1.0f;
                    }
                    float f16 = this.mc.field_71474_y.field_74333_Y;
                    float f17 = 1.0f - f8;
                    float f13 = 1.0f - f9;
                    float f14 = 1.0f - f10;
                    f17 = 1.0f - f17 * f17 * f17 * f17;
                    f13 = 1.0f - f13 * f13 * f13 * f13;
                    f14 = 1.0f - f14 * f14 * f14 * f14;
                    f8 = f8 * (1.0f - f16) + f17 * f16;
                    f9 = f9 * (1.0f - f16) + f13 * f16;
                    f10 = f10 * (1.0f - f16) + f14 * f16;
                    f8 = f8 * 0.96f + 0.03f;
                    f9 = f9 * 0.96f + 0.03f;
                    f10 = f10 * 0.96f + 0.03f;
                    if (f8 > 1.0f) {
                        f8 = 1.0f;
                    }
                    if (f9 > 1.0f) {
                        f9 = 1.0f;
                    }
                    if (f10 > 1.0f) {
                        f10 = 1.0f;
                    }
                    if (f8 < 0.0f) {
                        f8 = 0.0f;
                    }
                    if (f9 < 0.0f) {
                        f9 = 0.0f;
                    }
                    if (f10 < 0.0f) {
                        f10 = 0.0f;
                    }
                    int j = 255;
                    int k = (int)(f8 * 255.0f);
                    int l = (int)(f9 * 255.0f);
                    int i1 = (int)(f10 * 255.0f);
                    this.lightmapColors[i] = 0xFF000000 | k << 16 | l << 8 | i1;
                }
                this.lightmapTexture.func_110564_a();
                this.lightmapUpdateNeeded = false;
                this.mc.field_71424_I.func_76319_b();
            }
        }
    }

    private float getNightVisionBrightness(EntityLivingBase entitylivingbaseIn, float partialTicks) {
        int i = entitylivingbaseIn.func_70660_b(MobEffects.field_76439_r).func_76459_b();
        return i > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)i - partialTicks) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    private boolean isDrawBlockOutline() {
        boolean flag;
        if (!this.drawBlockOutline) {
            return false;
        }
        Entity entity = this.mc.func_175606_aa();
        boolean bl = flag = entity instanceof EntityPlayer && !this.mc.field_71474_y.field_74319_N;
        if (flag && !((EntityPlayer)entity).field_71075_bZ.field_75099_e) {
            ItemStack itemstack = ((EntityPlayer)entity).func_184614_ca();
            if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = this.mc.field_71476_x.func_178782_a();
                Block block = this.mc.field_71441_e.func_180495_p(blockpos).func_177230_c();
                flag = this.mc.field_71442_b.func_178889_l() == GameType.SPECTATOR ? block.hasTileEntity(this.mc.field_71441_e.func_180495_p(blockpos)) && this.mc.field_71441_e.func_175625_s(blockpos) instanceof IInventory : !itemstack.func_190926_b() && (itemstack.func_179544_c(block) || itemstack.func_179547_d(block));
            }
        }
        return flag;
    }

    public void func_78471_a(float partialTicks, long finishTimeNano) {
        this.updateLightmap(partialTicks);
        if (this.mc.func_175606_aa() == null) {
            this.mc.func_175607_a((Entity)this.mc.field_71439_g);
        }
        this.func_78473_a(partialTicks);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.5f);
        this.mc.field_71424_I.func_76320_a("center");
        if (this.mc.field_71474_y.field_74337_g) {
            field_78515_b = 0;
            GlStateManager.func_179135_a((boolean)false, (boolean)true, (boolean)true, (boolean)false);
            this.renderWorldPass(0, partialTicks, finishTimeNano);
            field_78515_b = 1;
            GlStateManager.func_179135_a((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            this.renderWorldPass(1, partialTicks, finishTimeNano);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        } else {
            this.renderWorldPass(2, partialTicks, finishTimeNano);
        }
        this.mc.field_71424_I.func_76319_b();
    }

    private void renderWorldPass(int pass, float partialTicks, long finishTimeNano) {
        RenderGlobal renderglobal = this.mc.field_71438_f;
        ParticleManager particlemanager = this.mc.field_71452_i;
        boolean flag = this.isDrawBlockOutline();
        GlStateManager.func_179089_o();
        this.mc.field_71424_I.func_76318_c("clear");
        GlStateManager.func_179083_b((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        this.updateFogColor(partialTicks);
        GlStateManager.func_179086_m((int)16640);
        this.mc.field_71424_I.func_76318_c("camera");
        this.setupCameraTransform(partialTicks, pass);
        ActiveRenderInfo.updateRenderInfo((Entity)this.mc.func_175606_aa(), (this.mc.field_71474_y.field_74320_O == 2 ? 1 : 0) != 0);
        this.mc.field_71424_I.func_76318_c("frustum");
        ClippingHelperImpl.func_78558_a();
        this.mc.field_71424_I.func_76318_c("culling");
        Frustum icamera = new Frustum();
        Entity entity = this.mc.func_175606_aa();
        double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        icamera.func_78547_a(d0, d1, d2);
        if (this.mc.field_71474_y.field_151451_c >= 4) {
            this.mc.field_71424_I.func_76318_c("sky");
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            Project.gluPerspective((float)this.getFOVModifier(partialTicks, true), (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
            GlStateManager.func_179128_n((int)5888);
            renderglobal.func_174976_a(partialTicks, pass);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            Project.gluPerspective((float)this.getFOVModifier(partialTicks, true), (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(this.farPlaneDistance * MathHelper.field_180189_a));
            GlStateManager.func_179128_n((int)5888);
        }
        this.mc.field_71424_I.func_76318_c("prepareterrain");
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        this.mc.field_71424_I.func_76318_c("terrain_setup");
        renderglobal.func_174970_a(entity, (double)partialTicks, (ICamera)icamera, this.frameCount++, this.mc.field_71439_g.func_175149_v());
        if (pass == 0 || pass == 2) {
            this.mc.field_71424_I.func_76318_c("updatechunks");
            this.mc.field_71438_f.func_174967_a(finishTimeNano);
        }
        this.mc.field_71424_I.func_76318_c("terrain");
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        renderglobal.func_174977_a(BlockRenderLayer.SOLID, (double)partialTicks, pass, entity);
        GlStateManager.func_179141_d();
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, this.mc.field_71474_y.field_151442_I > 0);
        renderglobal.func_174977_a(BlockRenderLayer.CUTOUT_MIPPED, (double)partialTicks, pass, entity);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        renderglobal.func_174977_a(BlockRenderLayer.CUTOUT, (double)partialTicks, pass, entity);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        if (!this.debugView) {
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            RenderHelper.func_74519_b();
            this.mc.field_71424_I.func_76318_c("entities");
            ForgeHooksClient.setRenderPass((int)0);
            renderglobal.func_180446_a(entity, (ICamera)icamera, partialTicks);
            ForgeHooksClient.setRenderPass((int)0);
            RenderHelper.func_74518_a();
            this.func_175072_h();
        }
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        if (flag && this.mc.field_71476_x != null && !entity.func_70055_a(Material.field_151586_h)) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            GlStateManager.func_179118_c();
            this.mc.field_71424_I.func_76318_c("outline");
            if (!ForgeHooksClient.onDrawBlockHighlight((RenderGlobal)renderglobal, (EntityPlayer)entityplayer, (RayTraceResult)this.mc.field_71476_x, (int)0, (float)partialTicks)) {
                renderglobal.func_72731_b(entityplayer, this.mc.field_71476_x, 0, partialTicks);
            }
            GlStateManager.func_179141_d();
        }
        if (this.mc.field_184132_p.func_190074_a()) {
            this.mc.field_184132_p.func_190073_a(partialTicks, finishTimeNano);
        }
        this.mc.field_71424_I.func_76318_c("destroyProgress");
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        renderglobal.func_174981_a(Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), entity, partialTicks);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179084_k();
        if (!this.debugView) {
            this.func_180436_i();
            this.mc.field_71424_I.func_76318_c("litParticles");
            particlemanager.func_78872_b(entity, partialTicks);
            RenderHelper.func_74518_a();
            this.mc.field_71424_I.func_76318_c("particles");
            particlemanager.func_78874_a(entity, partialTicks);
            this.func_175072_h();
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179089_o();
        this.mc.field_71424_I.func_76318_c("weather");
        this.func_78474_d(partialTicks);
        GlStateManager.func_179132_a((boolean)true);
        renderglobal.func_180449_a(entity, partialTicks);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179103_j((int)7425);
        this.mc.field_71424_I.func_76318_c("translucent");
        renderglobal.func_174977_a(BlockRenderLayer.TRANSLUCENT, (double)partialTicks, pass, entity);
        if (!this.debugView) {
            RenderHelper.func_74519_b();
            this.mc.field_71424_I.func_76318_c("entities");
            ForgeHooksClient.setRenderPass((int)1);
            renderglobal.func_180446_a(entity, (ICamera)icamera, partialTicks);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            ForgeHooksClient.setRenderPass((int)-1);
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179106_n();
        if (entity.field_70163_u + (double)entity.func_70047_e() >= 128.0) {
            this.mc.field_71424_I.func_76318_c("aboveClouds");
        }
        this.mc.field_71424_I.func_76318_c("forge_render_last");
        ForgeHooksClient.dispatchRenderLast((RenderGlobal)renderglobal, (float)partialTicks);
        this.mc.field_71424_I.func_76318_c("hand");
        if (this.renderHand) {
            GlStateManager.func_179086_m((int)256);
            this.renderHand(partialTicks, pass);
        }
    }

    private void updateFogColor(float partialTicks) {
        float f9;
        WorldClient world = this.mc.field_71441_e;
        Entity entity = this.mc.func_175606_aa();
        float f = 0.25f + 0.75f * (float)this.mc.field_71474_y.field_151451_c / 32.0f;
        f = 1.0f - (float)Math.pow(f, 0.25);
        Vec3d vec3d = world.func_72833_a(this.mc.func_175606_aa(), partialTicks);
        float f1 = (float)vec3d.field_72450_a;
        float f2 = (float)vec3d.field_72448_b;
        float f3 = (float)vec3d.field_72449_c;
        Vec3d vec3d1 = world.func_72948_g(partialTicks);
        this.fogColorRed = (float)vec3d1.field_72450_a;
        this.fogColorGreen = (float)vec3d1.field_72448_b;
        this.fogColorBlue = (float)vec3d1.field_72449_c;
        if (this.mc.field_71474_y.field_151451_c >= 4) {
            float[] afloat;
            double d0 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) > 0.0f ? -1.0 : 1.0;
            Vec3d vec3d2 = new Vec3d(d0, 0.0, 0.0);
            float f5 = (float)entity.func_70676_i(partialTicks).func_72430_b(vec3d2);
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            if (f5 > 0.0f && (afloat = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks)) != null) {
                this.fogColorRed = this.fogColorRed * (1.0f - (f5 *= afloat[3])) + afloat[0] * f5;
                this.fogColorGreen = this.fogColorGreen * (1.0f - f5) + afloat[1] * f5;
                this.fogColorBlue = this.fogColorBlue * (1.0f - f5) + afloat[2] * f5;
            }
        }
        this.fogColorRed += (f1 - this.fogColorRed) * f;
        this.fogColorGreen += (f2 - this.fogColorGreen) * f;
        this.fogColorBlue += (f3 - this.fogColorBlue) * f;
        float f8 = world.func_72867_j(partialTicks);
        if (f8 > 0.0f) {
            float f4 = 1.0f - f8 * 0.5f;
            float f10 = 1.0f - f8 * 0.4f;
            this.fogColorRed *= f4;
            this.fogColorGreen *= f4;
            this.fogColorBlue *= f10;
        }
        if ((f9 = world.func_72819_i(partialTicks)) > 0.0f) {
            float f11 = 1.0f - f9 * 0.5f;
            this.fogColorRed *= f11;
            this.fogColorGreen *= f11;
            this.fogColorBlue *= f11;
        }
        IBlockState iblockstate = ActiveRenderInfo.func_186703_a((World)this.mc.field_71441_e, (Entity)entity, (float)partialTicks);
        if (this.cloudFog) {
            Vec3d vec3d3 = world.func_72824_f(partialTicks);
            this.fogColorRed = (float)vec3d3.field_72450_a;
            this.fogColorGreen = (float)vec3d3.field_72448_b;
            this.fogColorBlue = (float)vec3d3.field_72449_c;
        } else {
            Vec3d viewport = ActiveRenderInfo.func_178806_a((Entity)entity, (double)partialTicks);
            BlockPos viewportPos = new BlockPos(viewport);
            IBlockState viewportState = this.mc.field_71441_e.func_180495_p(viewportPos);
            Vec3d inMaterialColor = viewportState.func_177230_c().getFogColor((World)this.mc.field_71441_e, viewportPos, viewportState, entity, new Vec3d((double)this.fogColorRed, (double)this.fogColorGreen, (double)this.fogColorBlue), partialTicks);
            this.fogColorRed = (float)inMaterialColor.field_72450_a;
            this.fogColorGreen = (float)inMaterialColor.field_72448_b;
            this.fogColorBlue = (float)inMaterialColor.field_72449_c;
        }
        float f13 = this.fogColor2 + (this.fogColor1 - this.fogColor2) * partialTicks;
        this.fogColorRed *= f13;
        this.fogColorGreen *= f13;
        this.fogColorBlue *= f13;
        double d1 = (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks) * world.field_73011_w.func_76565_k();
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q)) {
            int i = ((EntityLivingBase)entity).func_70660_b(MobEffects.field_76440_q).func_76459_b();
            d1 = i < 20 ? (d1 *= (double)(1.0f - (float)i / 20.0f)) : 0.0;
        }
        if (d1 < 1.0) {
            if (d1 < 0.0) {
                d1 = 0.0;
            }
            d1 *= d1;
            this.fogColorRed = (float)((double)this.fogColorRed * d1);
            this.fogColorGreen = (float)((double)this.fogColorGreen * d1);
            this.fogColorBlue = (float)((double)this.fogColorBlue * d1);
        }
        if (this.bossColorModifier > 0.0f) {
            float f14 = this.bossColorModifierPrev + (this.bossColorModifier - this.bossColorModifierPrev) * partialTicks;
            this.fogColorRed = this.fogColorRed * (1.0f - f14) + this.fogColorRed * 0.7f * f14;
            this.fogColorGreen = this.fogColorGreen * (1.0f - f14) + this.fogColorGreen * 0.6f * f14;
            this.fogColorBlue = this.fogColorBlue * (1.0f - f14) + this.fogColorBlue * 0.6f * f14;
        }
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76439_r)) {
            float f15 = this.getNightVisionBrightness((EntityLivingBase)entity, partialTicks);
            float f6 = 1.0f / this.fogColorRed;
            if (f6 > 1.0f / this.fogColorGreen) {
                f6 = 1.0f / this.fogColorGreen;
            }
            if (f6 > 1.0f / this.fogColorBlue) {
                f6 = 1.0f / this.fogColorBlue;
            }
            if (Float.isInfinite(f6)) {
                f6 = Math.nextAfter(f6, 0.0);
            }
            this.fogColorRed = this.fogColorRed * (1.0f - f15) + this.fogColorRed * f6 * f15;
            this.fogColorGreen = this.fogColorGreen * (1.0f - f15) + this.fogColorGreen * f6 * f15;
            this.fogColorBlue = this.fogColorBlue * (1.0f - f15) + this.fogColorBlue * f6 * f15;
        }
        if (this.mc.field_71474_y.field_74337_g) {
            float f16 = (this.fogColorRed * 30.0f + this.fogColorGreen * 59.0f + this.fogColorBlue * 11.0f) / 100.0f;
            float f17 = (this.fogColorRed * 30.0f + this.fogColorGreen * 70.0f) / 100.0f;
            float f7 = (this.fogColorRed * 30.0f + this.fogColorBlue * 70.0f) / 100.0f;
            this.fogColorRed = f16;
            this.fogColorGreen = f17;
            this.fogColorBlue = f7;
        }
        EntityViewRenderEvent.FogColors event = new EntityViewRenderEvent.FogColors((EntityRenderer)this, entity, iblockstate, (double)partialTicks, this.fogColorRed, this.fogColorGreen, this.fogColorBlue);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.fogColorRed = event.getRed();
        this.fogColorGreen = event.getGreen();
        this.fogColorBlue = event.getBlue();
        GlStateManager.func_179082_a((float)this.fogColorRed, (float)this.fogColorGreen, (float)this.fogColorBlue, (float)0.0f);
    }
}

