/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.container;

import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.ItemStackHandler;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class TrinketContainerHandler
extends ItemStackHandler
implements ITrinketContainerHandler {
    private static int rows = TrinketsConfig.SERVER.GUI.guiSlotsRows;
    private static int rowLength = TrinketsConfig.SERVER.GUI.guiSlotsRowLength;
    private static final int slots = MathHelper.func_76125_a((int)((rows - 1) * (rowLength + 1) + rowLength), (int)0, (int)((rows - 1) * (rowLength + 1) + rowLength));
    private boolean[] changed = new boolean[slots];
    private boolean blockEvents = false;
    private EntityLivingBase player;

    public TrinketContainerHandler() {
        super(slots);
    }

    public void setSize(int size) {
        if (size < slots || size > slots) {
            size = slots;
        }
        super.setSize(size);
        boolean[] old = this.changed;
        this.changed = new boolean[size];
        for (int i = 0; i < old.length && i < this.changed.length; ++i) {
            this.changed[i] = old[i];
        }
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (stack == null || stack.func_190926_b() || this.isItemValidForSlot(slot, stack, this.player)) {
            super.setStackInSlot(slot, stack);
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.isItemValidForSlot(slot, stack, this.player)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    public void setPlayer(EntityLivingBase player) {
        this.player = player;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack, EntityLivingBase player) {
        if (!(stack != null && !stack.func_190926_b() && (stack.func_77973_b() instanceof IAccessoryInterface || TrinketsConfig.compat.baubles && Loader.isModLoaded((String)"baubles") && stack.func_77973_b() instanceof IBauble))) {
            return false;
        }
        TrinketProperties iCap = Capabilities.getTrinketProperties(stack);
        if (stack.func_77973_b() instanceof IAccessoryInterface && iCap != null) {
            IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
            return trinket.playerCanEquip(stack, player);
        }
        if (TrinketsConfig.compat.baubles && Loader.isModLoaded((String)"baubles") && stack.func_77973_b() instanceof IBauble) {
            IBauble bauble = (IBauble)stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isEventBlocked() {
        return this.blockEvents;
    }

    @Override
    public void setEventBlock(boolean blockEvents) {
        this.blockEvents = blockEvents;
    }
}

