/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.events.EventBaseHandler;
import xzeroair.trinkets.traits.abilities.IAbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IMiningAbility;

public class BlockBreakEvents
extends EventBaseHandler {
    @SubscribeEvent
    public void BreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getEntityLiving());
        if (prop != null) {
            boolean cancel = false;
            float newSpeed = event.getNewSpeed();
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                ImmutablePair<Boolean, Float> result;
                if (cancel) break;
                IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                if (handler == null || !(handler instanceof IMiningAbility) || (result = ((IMiningAbility)handler).breakingBlock(event.getEntityLiving(), event.getState(), event.getPos(), event.getOriginalSpeed(), event.getNewSpeed())) == null) continue;
                if (((Boolean)result.getLeft()).booleanValue()) {
                    cancel = true;
                    continue;
                }
                if (event.getNewSpeed() == ((Float)result.getRight()).floatValue()) continue;
                newSpeed = ((Float)result.getRight()).floatValue();
            }
            if (cancel && !this.isEventCanceled((Event)event)) {
                this.cancelEvent((Event)event);
            } else if (event.getNewSpeed() < newSpeed) {
                event.setNewSpeed(newSpeed);
            }
        }
    }

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getPlayer());
        if (prop != null) {
            boolean cancel = false;
            int exp = event.getExpToDrop();
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                ImmutablePair<Boolean, Integer> result;
                if (cancel) break;
                IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                if (handler == null || !(handler instanceof IMiningAbility) || (result = ((IMiningAbility)handler).brokeBlock((EntityLivingBase)event.getPlayer(), event.getWorld(), event.getState(), event.getPos(), exp)) == null) continue;
                if (result.getLeft() != null && ((Boolean)result.getLeft()).booleanValue()) {
                    cancel = true;
                    continue;
                }
                if (result.getRight() == null || event.getExpToDrop() == ((Integer)result.getRight()).intValue()) continue;
                exp = (Integer)result.getRight();
            }
            if (cancel && !this.isEventCanceled((Event)event)) {
                this.cancelEvent((Event)event);
            } else if (event.getExpToDrop() != exp) {
                event.setExpToDrop(exp);
            }
        }
    }

    @SubscribeEvent
    public void blockDrops(BlockEvent.HarvestDropsEvent event) {
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getHarvester());
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                float result;
                IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                if (handler == null || !(handler instanceof IMiningAbility) || (result = ((IMiningAbility)handler).blockDrops((EntityLivingBase)event.getHarvester(), event.getWorld(), event.getState(), event.getPos(), event.getDrops(), event.getDropChance(), event.isSilkTouching(), event.getFortuneLevel())) == event.getDropChance()) continue;
                event.setDropChance(result);
            }
        }
    }
}

