/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.events.EventBaseHandler;
import xzeroair.trinkets.traits.abilities.IAbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IBowAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IHealAbility;

public class CombatHandler
extends EventBaseHandler {
    @SubscribeEvent
    public void arrowLooseEvent(ArrowLooseEvent event) {
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getEntityLiving());
        if (prop != null) {
            try {
                prop.getRaceProperties().bowUsed(event.getBow(), event.getCharge());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IBowAbility)) continue;
                    ((IBowAbility)handler).looseArrow(event.getEntityLiving(), event.getWorld(), event.getBow(), event.getCharge());
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void arrowNockEvent(ArrowNockEvent event) {
        ActionResult<ItemStack> eventAction;
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getEntityLiving());
        World world = event.getWorld();
        ItemStack stack = event.getBow();
        EnumHand hand = event.getHand();
        boolean hasAmmo = event.hasAmmo();
        ActionResult<ItemStack> action = eventAction = event.getAction();
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    ActionResult<ItemStack> abilityAction;
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IBowAbility) || (abilityAction = ((IBowAbility)handler).knockArrow(event.getEntityLiving(), world, stack, hand, action, hasAmmo)) == null) continue;
                    action = abilityAction;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            ActionResult<ItemStack> raceResult = prop.getRaceProperties().bowNocked(world, stack, hand, action, hasAmmo);
            if (raceResult != null) {
                action = raceResult;
            }
            if (eventAction != action && action != null) {
                event.setAction(action);
            }
        }
    }

    @SubscribeEvent
    public void ArrowImpactEvent(ProjectileImpactEvent.Arrow event) {
        EntityProperties prop;
        if (event.getArrow().field_70250_c instanceof EntityLivingBase && (prop = Capabilities.getEntityRace(event.getArrow().field_70250_c)) != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IBowAbility)) continue;
                    ((IBowAbility)handler).arrowImpact((EntityLivingBase)event.getArrow().field_70250_c, event.getArrow(), event.getRayTraceResult());
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void TargetEvent(LivingSetAttackTargetEvent event) {
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getTarget());
        if (prop != null) {
            prop.getRaceProperties().targetedByEnemy(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void attackEvent(LivingAttackEvent event) {
        IAbilityHandler handler;
        EntityProperties prop;
        DamageSource source = event.getSource();
        if (source.func_76357_e()) {
            return;
        }
        EntityLivingBase attacked = event.getEntityLiving();
        EntityLivingBase attacker = null;
        if (source.func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)source.func_76346_g();
        }
        float damage = event.getAmount();
        boolean cancel = false;
        if (attacker != null && (prop = Capabilities.getEntityRace((Entity)attacker)) != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                if (cancel) break;
                try {
                    handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IAttackAbility) || !((IAttackAbility)handler).attackEntity(attacked, source, damage, cancel)) continue;
                    cancel = true;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        if (!cancel && (prop = Capabilities.getEntityRace((Entity)attacked)) != null) {
            boolean raceCancel;
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                if (cancel) break;
                try {
                    handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IAttackAbility) || !((IAttackAbility)handler).attacked(attacked, source, damage, cancel)) continue;
                    cancel = true;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            if (!(raceCancel = prop.getRaceProperties().isAttacked(source, damage)) && event.isCancelable() && !event.isCanceled()) {
                event.setCanceled(true);
            }
        }
        if (cancel && !this.isEventCanceled((Event)event)) {
            this.cancelEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void HurtEvent(LivingHurtEvent event) {
        IAbilityHandler handler;
        EntityProperties prop;
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        if (source.func_76357_e() || damage == 0.0f) {
            return;
        }
        EntityLivingBase attacked = event.getEntityLiving();
        EntityLivingBase attacker = null;
        if (source.func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)source.func_76346_g();
        }
        if (attacker != null && (prop = Capabilities.getEntityRace((Entity)attacker)) != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IAttackAbility)) continue;
                    damage = ((IAttackAbility)handler).hurtEntity(attacked, source, damage);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            damage = prop.getRaceProperties().hurtEntity(attacked, source, damage);
        }
        if (damage > 0.0f && (prop = Capabilities.getEntityRace((Entity)attacked)) != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IAttackAbility)) continue;
                    damage = ((IAttackAbility)handler).hurt(attacked, source, damage);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            damage = prop.getRaceProperties().isHurt(source, damage);
        }
        if (event.getAmount() != damage) {
            if (damage > 0.0f) {
                event.setAmount(damage);
            } else if (!this.isEventCanceled((Event)event)) {
                this.cancelEvent((Event)event);
            }
        }
    }

    @SubscribeEvent
    public void applyDamageEvent(LivingDamageEvent event) {
        IAbilityHandler handler;
        EntityProperties prop;
        DamageSource source = event.getSource();
        if (source.func_76357_e()) {
            return;
        }
        EntityLivingBase attacked = event.getEntityLiving();
        EntityLivingBase attacker = null;
        if (source.func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)source.func_76346_g();
        }
        float damage = event.getAmount();
        if (attacker != null && (prop = Capabilities.getEntityRace((Entity)attacker)) != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IAttackAbility)) continue;
                    damage = ((IAttackAbility)handler).damageEntity(attacked, source, damage);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            damage = prop.getRaceProperties().damagedEntity(attacked, source, damage);
        }
        if (damage > 0.0f && (prop = Capabilities.getEntityRace((Entity)attacked)) != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IAttackAbility)) continue;
                    damage = ((IAttackAbility)handler).damaged(attacked, source, damage);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            damage = prop.getRaceProperties().isDamaged(source, damage);
        }
        if (event.getAmount() != damage) {
            if (damage > 0.0f) {
                event.setAmount(damage);
            } else if (!this.isEventCanceled((Event)event)) {
                this.cancelEvent((Event)event);
            }
        }
    }

    @SubscribeEvent
    public void onDeathEvent(LivingDeathEvent event) {
        IAbilityHandler handler;
        EntityProperties prop;
        DamageSource source = event.getSource();
        EntityLivingBase attacked = event.getEntityLiving();
        if (attacked instanceof EntityPlayer && attacked.field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase attacker = null;
        if (source.func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)source.func_76346_g();
        }
        boolean cancel = false;
        if (attacker != null && (prop = Capabilities.getEntityRace((Entity)attacker)) != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                if (cancel) break;
                try {
                    handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IAttackAbility) || !((IAttackAbility)handler).killedEntity(attacked, source, cancel)) continue;
                    cancel = true;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        if ((prop = Capabilities.getEntityRace((Entity)attacked)) != null && !cancel) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                if (cancel) break;
                try {
                    handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IAttackAbility) || !((IAttackAbility)handler).died(attacked, source, cancel)) continue;
                    cancel = true;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        if (cancel && !this.isEventCanceled((Event)event)) {
            this.cancelEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void experienceDropEvent(LivingExperienceDropEvent event) {
        EntityProperties prop;
        int originalDropped;
        EntityLivingBase attacked = event.getEntityLiving();
        EntityPlayer attacker = event.getAttackingPlayer();
        int originalExp = event.getOriginalExperience();
        int droppedExp = originalDropped = event.getDroppedExperience();
        if (attacker != null && (prop = Capabilities.getEntityRace((Entity)attacker)) != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IAttackAbility)) continue;
                    droppedExp = ((IAttackAbility)handler).killedEntityExpDrop(attacked, originalExp, droppedExp);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        if (originalDropped != droppedExp) {
            if (droppedExp > 0) {
                event.setDroppedExperience(droppedExp);
            } else if (!this.isEventCanceled((Event)event)) {
                this.cancelEvent((Event)event);
            }
        }
    }

    @SubscribeEvent
    public void ItemDropEvent(LivingDropsEvent event) {
        EntityProperties prop;
        EntityLivingBase attacked = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        int lootingLevel = event.getLootingLevel();
        List drops = event.getDrops();
        if (attacker instanceof EntityLivingBase && (prop = Capabilities.getEntityRace(attacker)) != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IAttackAbility)) continue;
                    ((IAttackAbility)handler).killedEntityItemDrops(attacked, source, lootingLevel, drops);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void healEvent(LivingHealEvent event) {
        float amount = event.getAmount();
        EntityLivingBase entity = event.getEntityLiving();
        EntityProperties prop = Capabilities.getEntityRace((Entity)entity);
        float finalAmount = amount;
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IHealAbility)) continue;
                    finalAmount = ((IHealAbility)handler).onHeal(entity, finalAmount);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        if (amount != finalAmount) {
            if (finalAmount > 0.0f) {
                event.setAmount(finalAmount);
            } else if (!this.isEventCanceled((Event)event)) {
                this.cancelEvent((Event)event);
            }
        }
    }
}

