/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.capabilities.statushandler.StatusHandler;
import xzeroair.trinkets.capabilities.statushandler.TrinketStatusEffect;
import xzeroair.trinkets.events.EventBaseHandler;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.items.effects.EffectsPolarizedStone;
import xzeroair.trinkets.items.trinkets.TrinketTeddyBear;
import xzeroair.trinkets.races.faelis.config.FaelisConfig;
import xzeroair.trinkets.traits.abilities.IAbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IInteractionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IItemUseAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.helpers.CallHelper;
import xzeroair.trinkets.util.helpers.PotionHelper;

public class EventHandler
extends EventBaseHandler {
    @SubscribeEvent
    public void playerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer entity = event.player;
        if (!entity.func_70089_S() || entity.func_130014_f_() == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            try {
                EntityProperties cap = Capabilities.getEntityRace((Entity)entity);
                if (cap != null) {
                    cap.onUpdatePre();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                VipStatus status = Capabilities.getVipStatus((Entity)entity);
                if (status != null) {
                    status.onUpdate();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.raceHandlerTick((EntityLivingBase)entity);
            this.effectHandlerTick((EntityLivingBase)entity);
            this.magicHandlerTick((EntityLivingBase)entity);
            try {
                EffectsPolarizedStone.processBauble(entity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void EntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof EntityPlayer)) {
            this.raceHandlerTick(entity);
            this.effectHandlerTick(entity);
        }
    }

    private void raceHandlerTick(EntityLivingBase entity) {
        try {
            EntityProperties cap = Capabilities.getEntityRace((Entity)entity);
            if (cap != null) {
                cap.onUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void magicHandlerTick(EntityLivingBase entity) {
        try {
            MagicStats cap = Capabilities.getMagicStats((Entity)entity);
            if (cap != null) {
                cap.onUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void effectHandlerTick(EntityLivingBase entity) {
        try {
            StatusHandler cap = Capabilities.getStatusHandler((Entity)entity);
            if (cap != null) {
                cap.onUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void makeNoise(PlaySoundAtEntityEvent event) {
        Entity entity = event.getEntity();
        if (event.getSound() != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean client = player.field_70170_p.field_72995_K;
            EntityProperties cap = Capabilities.getEntityRace((Entity)player);
            if (!(cap == null || cap.isNormalHeight() || event.getSound() != SoundEvents.field_187902_gb && event.getSound() != SoundEvents.field_187579_bV && event.getSound() != SoundEvents.field_187554_ai && event.getSound() != SoundEvents.field_187897_gY && event.getSound() != SoundEvents.field_187668_ca && event.getSound() != SoundEvents.field_187815_fJ && event.getSound() != SoundEvents.field_187569_bQ && event.getSound() != SoundEvents.field_187778_dq && event.getSound() != SoundEvents.field_187695_h && event.getSound() != SoundEvents.field_187653_cW && event.getSound() != SoundEvents.field_187888_ft || client)) {
                if (!event.getEntity().func_70051_ag()) {
                    event.setVolume(0.0f);
                } else {
                    event.setVolume(0.1f);
                }
            }
        }
    }

    @SubscribeEvent
    public void potionApply(PotionEvent.PotionApplicableEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        EntityProperties cap = Capabilities.getEntityRace((Entity)entity);
        if (cap != null) {
            if (!entity.func_70089_S() || entity.func_130014_f_() == null) {
                return;
            }
            boolean cancel = false;
            for (IAbilityInterface ability : cap.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = cap.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IPotionAbility)) continue;
                    cancel = ((IPotionAbility)handler).potionApplied(entity, event.getPotionEffect(), cancel);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Potion Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            if (cap.getRaceProperties().potionBeingApplied(event.getPotionEffect())) {
                cancel = true;
            }
            if (cancel) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        EntityProperties cap = Capabilities.getEntityRace((Entity)event.getEntityLiving());
        if (cap != null) {
            for (IAbilityInterface ability : cap.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = cap.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IInteractionAbility)) continue;
                    ((IInteractionAbility)handler).interact(event.getEntityLiving(), event.getWorld(), event.getItemStack(), event.getHand(), event.getFace(), event.getPos());
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Potion Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            try {
                cap.getRaceProperties().interact(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void playerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        if (this.isEventCanceled((Event)event)) {
            return;
        }
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getEntityLiving());
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IInteractionAbility)) continue;
                    ((IInteractionAbility)handler).interactEntity(event.getEntityLiving(), event.getWorld(), event.getItemStack(), event.getHand(), event.getFace(), event.getPos(), event.getTarget());
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Potion Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            prop.getRaceProperties().interactWithEntity(event);
        }
    }

    @SubscribeEvent
    public void playerInteractEntitySpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (this.isEventCanceled((Event)event)) {
            return;
        }
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getEntityLiving());
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IInteractionAbility)) continue;
                    ((IInteractionAbility)handler).interactEntitySpecific(event.getEntityLiving(), event.getWorld(), event.getItemStack(), event.getHand(), event.getFace(), event.getPos(), event.getTarget(), event.getLocalPos());
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Potion Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (this.isEventCanceled((Event)event)) {
            return;
        }
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getEntityLiving());
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    ImmutablePair<Event.Result, Event.Result> results;
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IInteractionAbility) || (results = ((IInteractionAbility)handler).rightClickBlock(event.getEntityLiving(), event.getWorld(), event.getItemStack(), event.getHand(), event.getFace(), event.getPos(), event.getHitVec(), event.getUseBlock(), event.getUseItem())) == null) continue;
                    if (results.getLeft() != null) {
                        event.setUseBlock((Event.Result)results.getLeft());
                    }
                    if (results.getRight() == null) continue;
                    event.setUseItem((Event.Result)results.getRight());
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Potion Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void playerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (this.isEventCanceled((Event)event)) {
            return;
        }
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getEntityLiving());
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    ImmutablePair<Event.Result, Event.Result> results;
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IInteractionAbility) || (results = ((IInteractionAbility)handler).leftClickBlock(event.getEntityLiving(), event.getWorld(), event.getItemStack(), event.getHand(), event.getFace(), event.getPos(), event.getHitVec(), event.getUseBlock(), event.getUseItem())) == null) continue;
                    if (results.getLeft() != null) {
                        event.setUseBlock((Event.Result)results.getLeft());
                    }
                    if (results.getRight() == null) continue;
                    event.setUseItem((Event.Result)results.getRight());
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Potion Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void playerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (this.isEventCanceled((Event)event)) {
            return;
        }
        EntityProperties prop = Capabilities.getEntityRace((Entity)event.getEntityLiving());
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IInteractionAbility)) continue;
                    ((IInteractionAbility)handler).rightClickWithItem(event.getEntityLiving(), event.getWorld(), event.getItemStack(), event.getHand(), event.getFace(), event.getPos());
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Potion Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void onMount(EntityMountEvent event) {
        EntityLivingBase entity;
        EntityProperties cap;
        if (event.getEntityMounting() instanceof EntityLivingBase && (cap = Capabilities.getEntityRace((Entity)(entity = (EntityLivingBase)event.getEntityMounting()))) != null) {
            try {
                if (event.isMounting()) {
                    boolean bool;
                    boolean bl = bool = !cap.getRaceProperties().mountEntity(event.getEntityBeingMounted());
                    if (event.isCancelable() && !event.isCanceled() && bool) {
                        event.setCanceled(bool);
                    }
                } else if (event.isDismounting()) {
                    boolean bool;
                    boolean bl = bool = !cap.getRaceProperties().dismountedEntity(event.getEntityBeingMounted());
                    if (event.isCancelable() && !event.isCanceled() && bool) {
                        event.setCanceled(bool);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onItemStartUsingEvent(LivingEntityUseItemEvent.Start event) {
        int duration;
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack stack = event.getItem();
        int dur = duration = event.getDuration();
        EntityProperties prop = Capabilities.getEntityRace((Entity)entity);
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IItemUseAbility)) continue;
                    if (dur < 0) break;
                    ((IItemUseAbility)handler).onItemStartUse(entity, stack, dur);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            if (duration != dur) {
                event.setDuration(dur);
            }
        }
    }

    @SubscribeEvent
    public void onItemUsingTickEvent(LivingEntityUseItemEvent.Tick event) {
        int duration;
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack stack = event.getItem();
        int dur = duration = event.getDuration();
        EntityProperties prop = Capabilities.getEntityRace((Entity)entity);
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IItemUseAbility)) continue;
                    if (dur < 0) break;
                    dur = ((IItemUseAbility)handler).onItemUseTick(entity, stack, dur);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            prop.getRaceProperties().bowDrawing(stack, dur);
            if (duration != dur) {
                event.setDuration(dur);
            }
        }
    }

    @SubscribeEvent
    public void onItemStopUseEvent(LivingEntityUseItemEvent.Stop event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack stack = event.getItem();
        int duration = event.getDuration();
        EntityProperties prop = Capabilities.getEntityRace((Entity)entity);
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IItemUseAbility)) continue;
                    ((IItemUseAbility)handler).onItemUseStop(entity, stack, duration);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            try {
                if (event.getItem().func_77973_b() instanceof ItemBow && event.getDuration() < 72000) {
                    int charge = 72000 - event.getDuration();
                    prop.getRaceProperties().bowUsed(event.getItem(), charge);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onItemFinishUseEvent(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase entity;
        block18: {
            entity = event.getEntityLiving();
            ItemStack stack = event.getItem();
            int duration = event.getDuration();
            EntityProperties prop = Capabilities.getEntityRace((Entity)entity);
            if (prop != null) {
                for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                    try {
                        IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                        if (handler == null || !(handler instanceof IItemUseAbility)) continue;
                        ((IItemUseAbility)handler).onItemUseFinish(entity, stack, duration);
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                        e.printStackTrace();
                    }
                }
                try {
                    String[] milkList;
                    StatusHandler status;
                    FaelisConfig faelisConfig = TrinketsConfig.SERVER.races.faelis;
                    if (!prop.getCurrentRace().equals(EntityRaces.faelis) || !faelisConfig.Invigorated || (status = Capabilities.getStatusHandler((Entity)entity)) == null) break block18;
                    for (String milk : milkList = faelisConfig.milk) {
                        int Iduration;
                        String[] itemConfig = milk.split(";");
                        String itemString = CallHelper.getStringFromArray(itemConfig, 0);
                        String metaString = CallHelper.getStringFromArray(itemConfig, 1);
                        String levelString = CallHelper.getStringFromArray(itemConfig, 2);
                        String durationString = CallHelper.getStringFromArray(itemConfig, 3);
                        if (!event.getItem().func_77973_b().getRegistryName().toString().equalsIgnoreCase(itemString)) continue;
                        int meta = metaString.isEmpty() ? Short.MAX_VALUE : Integer.parseInt(metaString);
                        int level = levelString.isEmpty() ? 0 : Integer.parseInt(levelString);
                        int n = Iduration = durationString.isEmpty() ? faelisConfig.Invigorated_Duration : Integer.parseInt(durationString);
                        if (meta == Short.MAX_VALUE || event.getItem().func_77960_j() == meta) {
                            status.apply(new TrinketStatusEffect("Invigorated", Iduration, level, null));
                            if (!entity.field_70170_p.field_72995_K) {
                                for (String potID : faelisConfig.buffs) {
                                    PotionHelper.PotionHolder potion = PotionHelper.getPotionHolder(potID);
                                    if (potion.getPotion() == null) continue;
                                    entity.func_70690_d(potion.getPotionEffect());
                                }
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (TrinketsConfig.SERVER.mana.mana_enabled) {
            try {
                Map<String, ConfigHelper.ItemObjectHolder> configObjects;
                MagicStats magic = Capabilities.getMagicStats((Entity)entity);
                if (magic != null && (configObjects = ConfigHelper.getMagicRecoveryItems()) != null && !configObjects.isEmpty()) {
                    boolean flag1 = configObjects.containsKey(event.getItem().func_77973_b().getRegistryName().toString() + ":" + event.getItem().func_77952_i());
                    boolean flag2 = configObjects.containsKey(event.getItem().func_77973_b().getRegistryName().toString() + ":" + Short.MAX_VALUE);
                    if (flag1 || flag2) {
                        String key = flag2 ? event.getItem().func_77973_b().getRegistryName().toString() + ":" + Short.MAX_VALUE : event.getItem().func_77973_b().getRegistryName().toString() + ":" + event.getItem().func_77952_i();
                        ConfigHelper.ItemObjectHolder item = configObjects.get(key);
                        if (event.getItem().func_77973_b().getRegistryName().toString().equalsIgnoreCase(item.getObject()) && (item.getMeta() == Short.MAX_VALUE || event.getItem().func_77952_i() == item.getMeta()) && item.getParams().length > 0) {
                            String recoveryAmount = item.getParams()[0];
                            if (recoveryAmount.endsWith("%")) {
                                float amount = MathHelper.func_76131_a((float)Float.parseFloat(recoveryAmount.replace("%", "")), (float)0.0f, (float)100.0f);
                                magic.addMana(magic.getMaxMana() * (amount * 0.01f));
                            } else {
                                float amount = Float.parseFloat(recoveryAmount);
                                magic.addMana(amount);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void craftedSomething(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = event.crafting;
        if (stack.func_77973_b() instanceof TrinketTeddyBear) {
            TrinketProperties prop = Capabilities.getTrinketProperties(stack);
            if (event.player != null) {
                if (event.player.func_110124_au() != null) {
                    prop.getTagCompoundSafe(stack).func_74778_a("crafter.id", event.player.func_110124_au().toString());
                } else {
                    prop.getTagCompoundSafe(stack).func_74778_a("crafter.name", event.player.getDisplayNameString());
                }
            }
        }
    }
}

