/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IJumpAbility;

public class MovementHandler {
    @SubscribeEvent
    public void onCollideWithBlock(PlayerSPPushOutOfBlocksEvent event) {
        EntityProperties cap;
        if (event.getEntityPlayer() != null && (cap = Capabilities.getEntityRace((Entity)event.getEntityPlayer())) != null && !cap.isNormalHeight() && event.isCancelable() && !event.isCanceled()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingJump(LivingEvent.LivingJumpEvent event) {
        EntityProperties prop;
        IAttributeInstance attribute;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K && (attribute = entity.func_110140_aT().func_111151_a(JumpAttribute.Jump)) != null && !attribute.func_111122_c().isEmpty()) {
            entity.field_70181_x += attribute.func_111126_e() - (double)0.42f;
            if (entity.func_70051_ag()) {
                entity.field_70159_w *= attribute.func_111126_e() / (double)0.42f;
                entity.field_70179_y *= attribute.func_111126_e() / (double)0.42f;
            }
        }
        if ((prop = Capabilities.getEntityRace((Entity)entity)) != null) {
            prop.getRaceProperties().jump();
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                if (!(ability instanceof IJumpAbility)) continue;
                IJumpAbility jump = (IJumpAbility)((Object)ability);
                try {
                    jump.jump(entity);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        float baseDistance = event.getDistance();
        float baseMultiplier = event.getDamageMultiplier();
        IAttributeInstance attribute = entity.func_110140_aT().func_111151_a(JumpAttribute.Jump);
        if (attribute != null && !attribute.func_111122_c().isEmpty()) {
            float distance = (float)(3.0 * (attribute.func_111126_e() / (double)0.42f));
            event.setDistance(baseDistance - distance);
        }
        float fallDistance = event.getDistance();
        float damageMultiplier = event.getDamageMultiplier();
        boolean cancel = false;
        EntityProperties prop = Capabilities.getEntityRace((Entity)entity);
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                if (!(ability instanceof IJumpAbility)) continue;
                IJumpAbility fall = (IJumpAbility)((Object)ability);
                try {
                    boolean abilityCancel;
                    float abilityModifier;
                    float abilityDistance = fall.fallDistance(entity, fallDistance);
                    if (fallDistance != abilityDistance) {
                        fallDistance = abilityDistance;
                    }
                    if (damageMultiplier != (abilityModifier = fall.fallDamageMultiplier(entity, damageMultiplier))) {
                        damageMultiplier = abilityModifier;
                    }
                    if (cancel == (abilityCancel = fall.fall(entity, fallDistance, damageMultiplier, cancel))) continue;
                    cancel = abilityCancel;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
            if (fallDistance != baseDistance) {
                event.setDistance(MathHelper.func_76131_a((float)fallDistance, (float)0.0f, (float)fallDistance));
            }
            if (damageMultiplier != baseMultiplier) {
                event.setDamageMultiplier(MathHelper.func_76131_a((float)damageMultiplier, (float)0.0f, (float)damageMultiplier));
            }
            if (cancel && event.isCancelable() && !event.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }
}

