/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.effects;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.trinkets.TrinketPolarized;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigPolarizedStone;
import xzeroair.trinkets.util.handlers.ItemEffectHandler;
import xzeroair.trinkets.util.handlers.TickHandler;

public class EffectsPolarizedStone {
    private static final ConfigPolarizedStone serverConfig = TrinketsConfig.SERVER.Items.POLARIZED_STONE;

    public static void collectDrops(ItemStack stack, EntityLivingBase entity) {
        TrinketProperties cap = Capabilities.getTrinketProperties(stack);
        if (cap != null && cap.mainAbility()) {
            AxisAlignedBB bBox = entity.func_174813_aQ();
            Predicate lootPredicate = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, ent -> ent instanceof EntityItem || ent instanceof EntityXPOrb && EffectsPolarizedStone.serverConfig.collectXP});
            Predicate otherPlayerPredicate = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, ent -> ent != null && ent.func_70067_L() && (ent.func_184614_ca().func_77973_b() instanceof TrinketPolarized || TrinketHelper.AccessoryCheck((EntityLivingBase)ent, ModItems.trinkets.TrinketPolarized))});
            List Loot = entity.field_70170_p.func_175647_a(Entity.class, bBox.func_72314_b((double)EffectsPolarizedStone.serverConfig.PR.HD, (double)EffectsPolarizedStone.serverConfig.PR.VD, (double)EffectsPolarizedStone.serverConfig.PR.HD), lootPredicate);
            List others = entity.field_70170_p.func_175647_a(EntityPlayer.class, bBox.func_72314_b((double)EffectsPolarizedStone.serverConfig.PR.HD, (double)EffectsPolarizedStone.serverConfig.PR.VD, (double)EffectsPolarizedStone.serverConfig.PR.HD), otherPlayerPredicate);
            for (Entity loot : Loot) {
                double distance = loot.func_70011_f(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                boolean someonesCloser = false;
                for (EntityPlayer otherP : others) {
                    float dist = loot.func_70032_d((Entity)otherP);
                    if (!((double)dist < distance)) continue;
                    someonesCloser = true;
                }
                if (someonesCloser) continue;
                EffectsPolarizedStone.handleLoot((Entity)entity, loot);
            }
        }
    }

    private static void handleLoot(Entity entity, Entity drop) {
        if (!EffectsPolarizedStone.serverConfig.instant_pickup) {
            if (drop instanceof EntityItem || EffectsPolarizedStone.serverConfig.collectXP && drop instanceof EntityXPOrb) {
                ItemEffectHandler.pull(drop, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
        } else if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_70170_p.field_72995_K) {
                if (drop instanceof EntityItem) {
                    EffectsPolarizedStone.pickupItem(player, drop);
                } else if (EffectsPolarizedStone.serverConfig.collectXP && drop instanceof EntityXPOrb) {
                    EffectsPolarizedStone.pickupXP(player, drop);
                }
            }
        } else {
            ItemEffectHandler.pull(drop, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
    }

    private static void pickupItem(EntityPlayer player, Entity itemEntity) {
        EntityItem item;
        if (itemEntity instanceof EntityItem && !((item = (EntityItem)itemEntity).func_92059_d().func_77973_b() instanceof TrinketPolarized)) {
            for (ItemStack slotStack : player.field_71071_by.field_70462_a) {
                if (slotStack.func_190926_b()) {
                    player.func_191521_c(item.func_92059_d());
                    continue;
                }
                if (!slotStack.func_77969_a(item.func_92059_d()) || !slotStack.func_77985_e() || !ItemStack.areItemStackShareTagsEqual((ItemStack)slotStack, (ItemStack)item.func_92059_d())) continue;
                if (slotStack.func_190916_E() + item.func_92059_d().func_190916_E() <= slotStack.func_77976_d()) {
                    player.func_191521_c(item.func_92059_d());
                    continue;
                }
                if (slotStack.func_77976_d() - slotStack.func_190916_E() <= 0) continue;
                player.func_191521_c(item.func_92059_d().func_77979_a(slotStack.func_77976_d() - slotStack.func_190916_E()));
            }
        }
    }

    private static void pickupXP(EntityPlayer player, Entity xpOrb) {
        if (xpOrb instanceof EntityXPOrb) {
            EntityXPOrb xp = (EntityXPOrb)xpOrb;
            ItemStack itemstack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)player);
            if (!itemstack.func_190926_b() && itemstack.func_77951_h()) {
                float ratio = itemstack.func_77973_b().getXpRepairRatio(itemstack);
                int iE = Math.min(EffectsPolarizedStone.roundAverage((float)xp.field_70530_e * ratio), itemstack.func_77952_i());
                xp.field_70530_e -= EffectsPolarizedStone.roundAverage((float)iE / ratio);
                itemstack.func_77964_b(itemstack.func_77952_i() - iE);
            }
            if (xp.field_70530_e > 0) {
                player.func_71023_q(xp.field_70530_e);
            }
            if (!xp.field_70128_L) {
                xp.func_70106_y();
            }
        }
    }

    private static int roundAverage(float value) {
        double floor = Math.floor(value);
        return (int)floor + (Math.random() < (double)value - floor ? 1 : 0);
    }

    public static void blockArrows(ItemStack stack, EntityLivingBase entity) {
        TrinketProperties cap = Capabilities.getTrinketProperties(stack);
        if (cap != null && cap.altAbility()) {
            MagicStats magic;
            Predicate filter;
            boolean flag;
            if (EffectsPolarizedStone.serverConfig.exhaustion && (flag = (filter = Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)EntitySelectors.field_94557_a)).apply((Object)entity)) && (magic = Capabilities.getMagicStats((Entity)entity)) != null) {
                float exhaustRate = EffectsPolarizedStone.serverConfig.exhaust_rate;
                TickHandler counter = cap.getCounter("repel.ticks", EffectsPolarizedStone.serverConfig.exhaust_ticks, false);
                if (exhaustRate <= magic.getMana()) {
                    if (counter.Tick()) {
                        magic.spendMana(exhaustRate);
                    }
                } else {
                    return;
                }
            }
            try {
                AxisAlignedBB bBox = entity.func_174813_aQ();
                List<String> cfg = Arrays.asList(EffectsPolarizedStone.serverConfig.repelledEntities);
                Predicate Targets = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, ent -> ent != null && !(ent instanceof EntityPlayer) && EntityRegistry.getEntry(ent.getClass()) != null && EntityRegistry.getEntry(ent.getClass()).getRegistryName() != null && cfg.contains(EntityRegistry.getEntry(ent.getClass()).getRegistryName().toString())});
                List entityList = entity.field_70170_p.func_175647_a(Entity.class, bBox.func_186662_g(EffectsPolarizedStone.serverConfig.repelRange), Targets);
                for (Entity repelledEntity : entityList) {
                    Vec3d playerVec3 = entity.func_70040_Z();
                    repelledEntity.field_70159_w = playerVec3.field_72450_a * 0.3;
                    repelledEntity.field_70181_x = playerVec3.field_72448_b * 0.3;
                    repelledEntity.field_70179_y = playerVec3.field_72449_c * 0.3;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean onHotbar(EntityPlayer player) {
        boolean onHotBar = false;
        for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
            if (!InventoryPlayer.func_184435_e((int)i) || !(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof TrinketPolarized)) continue;
            onHotBar = true;
            ItemStack Magnet = player.field_71071_by.func_70301_a(i);
            TrinketProperties ICap = Capabilities.getTrinketProperties(Magnet);
            if (Magnet == null || ICap == null) continue;
            if (ICap.mainAbility()) {
                EffectsPolarizedStone.collectDrops(Magnet, (EntityLivingBase)player);
            }
            if (!EffectsPolarizedStone.serverConfig.repell || !ICap.altAbility()) continue;
            EffectsPolarizedStone.blockArrows(Magnet, (EntityLivingBase)player);
        }
        return onHotBar;
    }

    public static boolean whileHeld(EntityPlayer player) {
        boolean held = false;
        if (player.func_184614_ca().func_77973_b() instanceof TrinketPolarized) {
            held = true;
            ItemStack Magnet = player.func_184614_ca();
            TrinketProperties ICap = Capabilities.getTrinketProperties(Magnet);
            if (Magnet != null && ICap != null) {
                if (ICap.mainAbility()) {
                    EffectsPolarizedStone.collectDrops(Magnet, (EntityLivingBase)player);
                }
                if (EffectsPolarizedStone.serverConfig.repell && ICap.altAbility()) {
                    EffectsPolarizedStone.blockArrows(Magnet, (EntityLivingBase)player);
                }
            }
        } else if (player.func_184592_cb().func_77973_b() instanceof TrinketPolarized) {
            held = true;
            ItemStack Magnet = player.func_184592_cb();
            TrinketProperties ICap = Capabilities.getTrinketProperties(Magnet);
            if (Magnet != null && ICap != null) {
                if (ICap.mainAbility()) {
                    EffectsPolarizedStone.collectDrops(Magnet, (EntityLivingBase)player);
                }
                if (EffectsPolarizedStone.serverConfig.repell && ICap.altAbility()) {
                    EffectsPolarizedStone.blockArrows(Magnet, (EntityLivingBase)player);
                }
            }
        }
        return held;
    }

    public static void processBauble(EntityPlayer player) {
        if (!TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketPolarized)) {
            if (!EffectsPolarizedStone.whileHeld(player)) {
                EffectsPolarizedStone.onHotbar(player);
            }
        } else {
            ItemStack magnet = TrinketHelper.getAccessory(player, ModItems.trinkets.TrinketPolarized);
            TrinketProperties iCap = Capabilities.getTrinketProperties(magnet);
            if (!(iCap == null || iCap.mainAbility() || iCap.altAbility() || EffectsPolarizedStone.whileHeld(player))) {
                EffectsPolarizedStone.onHotbar(player);
            }
        }
    }

    public static void handleStatus(ItemStack stack, TrinketProperties iCap) {
        if (iCap.mainAbility() && !iCap.altAbility()) {
            stack.func_77964_b(1);
        } else if (iCap.altAbility() && !iCap.mainAbility()) {
            stack.func_77964_b(2);
        } else if (iCap.altAbility() && iCap.mainAbility()) {
            stack.func_77964_b(3);
        } else {
            stack.func_77964_b(0);
        }
    }
}

