/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xzeroair.trinkets.network.ThreadSafePacket;

public class IncreasedReachPacket
extends ThreadSafePacket {
    private int targetEntityID;
    private int hand;
    private double x;
    private double y;
    private double z;

    public IncreasedReachPacket() {
    }

    public IncreasedReachPacket(EntityLivingBase entity, EnumHand hand, Entity targetEntity, Vec3d vec) {
        this(entity, hand, targetEntity, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public IncreasedReachPacket(EntityLivingBase entity, EnumHand hand, Entity targetEntity, double x, double y, double z) {
        this.entityID = entity.func_145782_y();
        this.targetEntityID = targetEntity.func_145782_y();
        this.hand = hand == EnumHand.MAIN_HAND ? 0 : 1;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.hand);
        buf.writeInt(this.targetEntityID);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.hand = buf.readInt();
        this.targetEntityID = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    @Override
    public void handleClientSafe(NetHandlerPlayClient client) {
    }

    @Override
    public void handleServerSafe(NetHandlerPlayServer server) {
        World world = server.field_147369_b.func_130014_f_();
        Entity entity = world.func_73045_a(this.entityID);
        Entity interacted = world.func_73045_a(this.targetEntityID);
        if (entity instanceof EntityPlayer && interacted != null) {
            EntityPlayer player = (EntityPlayer)entity;
            if (this.hand == 1) {
                if (!interacted.func_184230_a(player, EnumHand.OFF_HAND)) {
                    // empty if block
                }
            } else {
                player.func_71059_n(interacted);
            }
        }
    }
}

