/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.network.ThreadSafePacket;

public class PolarizedStoneSyncPacket
extends ThreadSafePacket {
    NBTTagCompound tag;
    int slot;
    int handler;
    int entityID;
    ItemStack item;
    int damage;

    public PolarizedStoneSyncPacket() {
    }

    public PolarizedStoneSyncPacket(EntityLivingBase player, ItemStack stack, TrinketProperties properties, int slot, int handler, int damage) {
        this.slot = slot;
        this.handler = handler;
        this.tag = new NBTTagCompound();
        properties.saveToNBT(this.tag);
        this.item = stack;
        this.entityID = player.func_145782_y();
        this.damage = damage;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeInt(this.handler);
        buf.writeInt(this.entityID);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.item);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        buf.writeInt(this.damage);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.handler = buf.readInt();
        this.entityID = buf.readInt();
        this.item = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.damage = buf.readInt();
    }

    @Override
    public void handleClientSafe(NetHandlerPlayClient client) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
        if (entity instanceof EntityPlayer) {
            IBaublesItemHandler baubles2;
            ItemStack stack;
            if (this.handler == 1) {
                ITrinketContainerHandler trinket = TrinketHelper.getTrinketHandler((EntityPlayer)entity);
                ItemStack stack2 = trinket.getStackInSlot(this.slot);
                if (!stack2.func_190926_b()) {
                    stack2.func_77964_b(this.damage);
                    TrinketProperties properties = Capabilities.getTrinketProperties(stack2);
                    if (properties != null) {
                        properties.loadFromNBT(this.tag);
                    }
                }
            } else if (this.handler == 2 && !(stack = (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity))).getStackInSlot(this.slot)).func_190926_b()) {
                stack.func_77964_b(this.damage);
                TrinketProperties properties = Capabilities.getTrinketProperties(stack);
                if (properties != null) {
                    properties.loadFromNBT(this.tag);
                }
            }
        }
    }

    @Override
    public void handleServerSafe(NetHandlerPlayServer server) {
        Entity entity = server.field_147369_b.func_130014_f_().func_73045_a(this.entityID);
        if (entity instanceof EntityPlayer) {
            IBaublesItemHandler baubles2;
            ItemStack stack;
            if (this.handler == 1) {
                ITrinketContainerHandler trinket = TrinketHelper.getTrinketHandler((EntityPlayer)entity);
                ItemStack stack2 = trinket.getStackInSlot(this.slot);
                if (!stack2.func_190926_b()) {
                    stack2.func_77964_b(this.damage);
                    TrinketProperties properties = Capabilities.getTrinketProperties(stack2);
                    if (properties != null) {
                        properties.loadFromNBT(this.tag);
                        properties.sendInformationToTracking((EntityLivingBase)entity);
                    }
                }
            } else if (this.handler == 2 && !(stack = (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity))).getStackInSlot(this.slot)).func_190926_b()) {
                stack.func_77964_b(this.damage);
                TrinketProperties properties = Capabilities.getTrinketProperties(stack);
                if (properties != null) {
                    properties.loadFromNBT(this.tag);
                    properties.sendInformationToTracking((EntityLivingBase)entity);
                }
            }
        }
    }
}

