/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.network.ThreadSafePacket;

public class SyncItemDataPacket
extends ThreadSafePacket {
    NBTTagCompound tag;
    int slot;
    int handler;
    int entityID;
    ItemStack item;
    boolean syncStacks;
    private boolean equipped;

    public SyncItemDataPacket() {
    }

    public SyncItemDataPacket(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, int slot, int handler, boolean syncSlot, boolean equipped) {
        this.slot = slot;
        this.handler = handler;
        this.tag = tag == null ? new NBTTagCompound() : tag;
        this.syncStacks = syncSlot;
        this.equipped = equipped;
        if (syncSlot) {
            this.item = stack;
        }
        this.entityID = player.func_145782_y();
    }

    public SyncItemDataPacket(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, int slot, int handler) {
        this(player, stack, tag, slot, handler, false, true);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeInt(this.handler);
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.syncStacks);
        buf.writeBoolean(this.equipped);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        if (this.syncStacks) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.item);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.handler = buf.readInt();
        this.entityID = buf.readInt();
        this.syncStacks = buf.readBoolean();
        this.equipped = buf.readBoolean();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (this.syncStacks) {
            this.item = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    @Override
    public void handleClientSafe(NetHandlerPlayClient client) {
        EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        World world = clientPlayer.func_130014_f_();
        try {
            Entity entity = clientPlayer.func_130014_f_().func_73045_a(this.entityID);
            if (entity != null) {
                world = entity.func_130014_f_();
            }
            if (entity instanceof EntityPlayer) {
                if (this.handler == 1) {
                    ITrinketContainerHandler trinket = TrinketHelper.getTrinketHandler((EntityPlayer)entity);
                    if (this.equipped) {
                        TrinketProperties properties;
                        ItemStack stack;
                        if (this.syncStacks && this.item != null && !this.item.func_190926_b()) {
                            trinket.setStackInSlot(this.slot, this.item);
                        }
                        if (!(stack = trinket.getStackInSlot(this.slot)).func_190926_b() && (properties = Capabilities.getTrinketProperties(stack)) != null) {
                            properties.loadFromNBT(this.tag);
                        }
                    } else if (this.syncStacks) {
                        trinket.setStackInSlot(this.slot, ItemStack.field_190927_a);
                    }
                } else if (this.handler == 2) {
                    IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity));
                    if (this.equipped) {
                        TrinketProperties properties;
                        ItemStack stack;
                        if (this.syncStacks && this.item != null && !this.item.func_190926_b()) {
                            baubles2.setStackInSlot(this.slot, this.item);
                        }
                        if (!(stack = baubles2.getStackInSlot(this.slot)).func_190926_b() && (properties = Capabilities.getTrinketProperties(stack)) != null) {
                            properties.loadFromNBT(this.tag);
                        }
                    } else if (this.syncStacks) {
                        baubles2.setStackInSlot(this.slot, ItemStack.field_190927_a);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleServerSafe(NetHandlerPlayServer server) {
        EntityPlayerMP serverPlayer = server.field_147369_b;
        WorldServer world = serverPlayer.func_71121_q();
        try {
            Entity entity = world.func_73045_a(this.entityID);
            if (entity instanceof EntityPlayer) {
                if (this.handler == 1) {
                    ITrinketContainerHandler trinket = TrinketHelper.getTrinketHandler((EntityPlayer)entity);
                    if (this.equipped) {
                        TrinketProperties properties;
                        ItemStack stack;
                        if (this.syncStacks && this.item != null && !this.item.func_190926_b()) {
                            trinket.setStackInSlot(this.slot, this.item);
                        }
                        if (!(stack = trinket.getStackInSlot(this.slot)).func_190926_b() && (properties = Capabilities.getTrinketProperties(stack)) != null) {
                            properties.loadFromNBT(this.tag);
                            properties.sendInformationToTracking((EntityLivingBase)entity);
                        }
                    } else if (this.syncStacks) {
                        trinket.setStackInSlot(this.slot, ItemStack.field_190927_a);
                    }
                } else if (this.handler == 2) {
                    IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity));
                    if (this.equipped) {
                        TrinketProperties properties;
                        ItemStack stack;
                        if (this.syncStacks && this.item != null && !this.item.func_190926_b()) {
                            baubles2.setStackInSlot(this.slot, this.item);
                        }
                        if (!(stack = baubles2.getStackInSlot(this.slot)).func_190926_b() && (properties = Capabilities.getTrinketProperties(stack)) != null) {
                            properties.loadFromNBT(this.tag);
                            properties.sendInformationToTracking((EntityLivingBase)entity);
                        }
                    } else if (this.syncStacks) {
                        baubles2.setStackInSlot(this.slot, ItemStack.field_190927_a);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

