/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network.status;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.capabilities.statushandler.StatusHandler;
import xzeroair.trinkets.capabilities.statushandler.TrinketStatusEffect;

public class CombineStatusEffectPacket
implements IMessage {
    private int attackerEntityID = 0;
    private int targetEntityID = 0;
    private int effectID = 0;
    private int duration = 0;
    private int level = 0;

    public CombineStatusEffectPacket() {
    }

    public CombineStatusEffectPacket(EntityLivingBase entity, EntityLivingBase targetEntity, int ID, int dur, int level) {
        this.attackerEntityID = entity.func_145782_y();
        this.targetEntityID = targetEntity.func_145782_y();
        this.effectID = ID;
        this.duration = dur;
        this.level = level;
    }

    public CombineStatusEffectPacket(EntityLivingBase entity, EntityLivingBase targetEntity, TrinketStatusEffect effect) {
        this.attackerEntityID = entity.func_145782_y();
        this.targetEntityID = targetEntity.func_145782_y();
        this.effectID = effect.getEffectID();
        this.duration = effect.getDuration();
        this.level = effect.getLevel();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.attackerEntityID);
        buf.writeInt(this.targetEntityID);
        buf.writeInt(this.effectID);
        buf.writeInt(this.duration);
        buf.writeInt(this.level);
    }

    public void fromBytes(ByteBuf buf) {
        this.attackerEntityID = buf.readInt();
        this.targetEntityID = buf.readInt();
        this.effectID = buf.readInt();
        this.duration = buf.readInt();
        this.level = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<CombineStatusEffectPacket, IMessage> {
        public IMessage onMessage(CombineStatusEffectPacket message, MessageContext ctx) {
            Trinkets.proxy.getThreadListener(ctx).func_152344_a(() -> {
                StatusHandler status;
                Entity targetEntity;
                EntityProperties cap;
                Entity player;
                if (Trinkets.proxy.getPlayer(ctx) != null && Trinkets.proxy.getPlayer(ctx).func_130014_f_() != null && (player = Trinkets.proxy.getPlayer(ctx).func_130014_f_().func_73045_a(message.attackerEntityID)) instanceof EntityPlayer && player.hasCapability(Capabilities.ENTITY_RACE, null) && (cap = Capabilities.getEntityRace((Entity)((EntityLivingBase)player))) != null && (targetEntity = Trinkets.proxy.getPlayer(ctx).func_130014_f_().func_73045_a(message.targetEntityID)) instanceof EntityLivingBase && (status = Capabilities.getStatusHandler((Entity)((EntityLivingBase)targetEntity))) != null) {
                    status.combine(message.effectID, message.duration, message.level);
                }
            });
            return null;
        }
    }
}

