/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network.status;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.WorldServer;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.statushandler.StatusHandler;
import xzeroair.trinkets.capabilities.statushandler.TrinketStatusEffect;
import xzeroair.trinkets.network.ThreadSafePacket;

public class StatusEffectPacket
extends ThreadSafePacket {
    boolean sourceNull = false;
    private int attackerEntityID = 0;
    private int targetEntityID = 0;
    private int effectID = 0;
    private int duration = 0;
    private int level = 0;
    private boolean combine;

    public StatusEffectPacket() {
    }

    public StatusEffectPacket(Entity source, EntityLivingBase targetEntity, int ID, int dur, int level, boolean combine) {
        if (source != null) {
            this.sourceNull = false;
            this.attackerEntityID = source.func_145782_y();
        } else {
            this.sourceNull = true;
        }
        this.targetEntityID = targetEntity.func_145782_y();
        this.effectID = ID;
        this.duration = dur;
        this.level = level;
        this.combine = combine;
    }

    public StatusEffectPacket(Entity source, EntityLivingBase targetEntity, TrinketStatusEffect effect) {
        this(source, targetEntity, effect.getEffectID(), effect.getDuration(), effect.getLevel(), false);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.sourceNull);
        if (this.sourceNull) {
            buf.writeInt(this.attackerEntityID);
        }
        buf.writeInt(this.targetEntityID);
        buf.writeInt(this.effectID);
        buf.writeInt(this.duration);
        buf.writeInt(this.level);
        buf.writeBoolean(this.combine);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.sourceNull = buf.readBoolean();
        if (this.sourceNull) {
            this.attackerEntityID = buf.readInt();
        }
        this.targetEntityID = buf.readInt();
        this.effectID = buf.readInt();
        this.duration = buf.readInt();
        this.level = buf.readInt();
        this.combine = buf.readBoolean();
    }

    @Override
    public void handleClientSafe(NetHandlerPlayClient client) {
        EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        try {
            Entity entity = clientPlayer.func_130014_f_().func_73045_a(this.targetEntityID);
            Entity source = this.sourceNull ? null : clientPlayer.func_130014_f_().func_73045_a(this.attackerEntityID);
            StatusHandler status = Capabilities.getStatusHandler(entity);
            if (status != null) {
                if (this.combine) {
                    status.combine(this.effectID, this.duration, this.level);
                } else {
                    status.apply(this.effectID, this.duration, this.level, source);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleServerSafe(NetHandlerPlayServer server) {
        EntityPlayerMP serverPlayer = server.field_147369_b;
        WorldServer world = serverPlayer.func_71121_q();
        try {
            Entity entity = serverPlayer.func_130014_f_().func_73045_a(this.attackerEntityID);
            if (entity != null && entity instanceof EntityPlayerMP) {
                world = ((EntityPlayerMP)entity).func_71121_q();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

