/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.RaceAttributesWrapper;
import xzeroair.trinkets.races.dragon.RaceDragon;
import xzeroair.trinkets.races.dragon.RaceDragonAttributes;
import xzeroair.trinkets.races.dwarf.RaceDwarf;
import xzeroair.trinkets.races.dwarf.RaceDwarfAttributes;
import xzeroair.trinkets.races.elf.RaceElf;
import xzeroair.trinkets.races.elf.RaceElfAttributes;
import xzeroair.trinkets.races.faelis.RaceFaelis;
import xzeroair.trinkets.races.faelis.RaceFaelisAttributes;
import xzeroair.trinkets.races.fairy.RaceFairy;
import xzeroair.trinkets.races.fairy.RaceFairyAttributes;
import xzeroair.trinkets.races.goblin.RaceGoblin;
import xzeroair.trinkets.races.goblin.RaceGoblinAttributes;
import xzeroair.trinkets.races.human.RaceHuman;
import xzeroair.trinkets.races.titan.RaceTitan;
import xzeroair.trinkets.races.titan.RaceTitanAttributes;
import xzeroair.trinkets.util.registry.TrinketRegistry;

public class EntityRace {
    public static final TrinketRegistry<ResourceLocation, EntityRace> Registry = Trinkets.RaceRegistry;
    private static int IndexID = 0;
    private final UUID uuid;
    private final String name;
    private int primaryColor = 0;
    private int secondaryColor = 0xFFFFFF;
    protected int magicAffinityValue = 100;
    protected int raceSize = 100;

    public EntityRace(String name, String uuid, int color1, int color2) {
        this.name = name;
        this.uuid = UUID.fromString(uuid);
        this.primaryColor = color1;
        this.secondaryColor = color2;
    }

    private static int nextID() {
        return IndexID++;
    }

    public static int getIdFromRace(EntityRace race) {
        return race == null ? 0 : Registry.getIDForObject(race);
    }

    public static ResourceLocation getRegistryNameFromRace(EntityRace race) {
        return race == null ? new ResourceLocation("xat", "human") : Registry.getNameForObject(race);
    }

    public static EntityRace getRaceById(int id) {
        return Registry.getObjectById(id);
    }

    public static EntityRace getByUUID(UUID uuid) {
        return Registry.getObjectByUUID(uuid);
    }

    @Nullable
    public static EntityRace getByNameOrId(String id) {
        EntityRace race = Registry.getObject(new ResourceLocation(id.toLowerCase()));
        if (race == null) {
            try {
                return EntityRace.getRaceById(Integer.parseInt(id));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return race;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getRaceSize() {
        return this.raceSize;
    }

    public EntityRace setRaceSize(int sizeV) {
        this.raceSize = sizeV;
        return this;
    }

    public int getMagicAffinity() {
        return this.magicAffinityValue;
    }

    public EntityRace setMagicAffinity(int magicAffinity) {
        this.magicAffinityValue = magicAffinity;
        return this;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    public EntityRacePropertiesHandler getRaceHandler(EntityLivingBase e) {
        switch (this.name) {
            case "Fairy": {
                return new RaceFairy(e, Capabilities.getEntityRace((Entity)e));
            }
            case "Dwarf": {
                return new RaceDwarf(e, Capabilities.getEntityRace((Entity)e));
            }
            case "Titan": {
                return new RaceTitan(e, Capabilities.getEntityRace((Entity)e));
            }
            case "Goblin": {
                return new RaceGoblin(e, Capabilities.getEntityRace((Entity)e));
            }
            case "Elf": {
                return new RaceElf(e, Capabilities.getEntityRace((Entity)e));
            }
            case "Faelis": {
                return new RaceFaelis(e, Capabilities.getEntityRace((Entity)e));
            }
            case "Dragon": {
                return new RaceDragon(e, Capabilities.getEntityRace((Entity)e));
            }
            case "Human": {
                return new RaceHuman(e, Capabilities.getEntityRace((Entity)e));
            }
        }
        return new RaceHuman(e, Capabilities.getEntityRace((Entity)e));
    }

    public RaceAttributesWrapper getRaceAttributes() {
        switch (this.name) {
            case "Fairy": {
                return new RaceFairyAttributes();
            }
            case "Dwarf": {
                return new RaceDwarfAttributes();
            }
            case "Titan": {
                return new RaceTitanAttributes();
            }
            case "Goblin": {
                return new RaceGoblinAttributes();
            }
            case "Elf": {
                return new RaceElfAttributes();
            }
            case "Faelis": {
                return new RaceFaelisAttributes();
            }
            case "Dragon": {
                return new RaceDragonAttributes();
            }
            case "Human": {
                return new RaceAttributesWrapper();
            }
        }
        return new RaceAttributesWrapper();
    }

    public static void registerRaces() {
        EntityRace.registerRace(EntityRace.nextID(), new EntityRace("None", "00000000-0000-0000-0000-000000000000", 11107684, 16374701).setRaceSize(100).setMagicAffinity(100));
        EntityRace.registerRace(EntityRace.nextID(), new EntityRace("Human", "c82ec7c3-2a9d-4a08-b0dd-7ce086c6771b", 11107684, 16374701).setRaceSize(100).setMagicAffinity(100));
        EntityRace.registerRace(EntityRace.nextID(), new EntityRace("Fairy", "e5869fac-0949-41f2-889b-4e6b8ca6d2e7", 12514535, 962222).setRaceSize(25).setMagicAffinity(500));
        EntityRace.registerRace(EntityRace.nextID(), new EntityRace("Dwarf", "917b555b-944a-4e44-afb6-ca638c6d91e5", 10832170, 0x6B6B6B).setRaceSize(75).setMagicAffinity(100));
        EntityRace.registerRace(EntityRace.nextID(), new EntityRace("Titan", "a3bc433b-7bb7-4bd9-a88c-5fd120d04d59", 0x999999, 3223595).setRaceSize(300).setMagicAffinity(50));
        EntityRace.registerRace(EntityRace.nextID(), new EntityRace("Elf", "25f92404-35f3-453b-ad48-9b788b2e12fc", 40960, 962222).setRaceSize(100).setMagicAffinity(200));
        EntityRace.registerRace(EntityRace.nextID(), new EntityRace("Goblin", "d917999a-0399-4c39-bfc5-79784dfff6ed", 0x648664, 0x2F3F2F).setRaceSize(50).setMagicAffinity(75));
        EntityRace.registerRace(EntityRace.nextID(), new EntityRace("Faelis", "cdccefa8-6a67-4394-b70d-c737953887a2", 16571252, 4465933).setRaceSize(85).setMagicAffinity(125));
        EntityRace.registerRace(EntityRace.nextID(), new EntityRace("Dragon", "3b75821e-6ec6-4dfe-9612-b7a988a7b30b", 0, 0).setRaceSize(120).setMagicAffinity(400));
    }

    private static void registerRace(int id, EntityRace race) {
        EntityRace.registerRace(id, new ResourceLocation("xat", race.getName().toLowerCase()), race);
    }

    private static void registerRace(int id, ResourceLocation textualID, EntityRace race) {
        Registry.register(id, textualID, race.getUUID(), race);
    }
}

