/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import xzeroair.trinkets.capabilities.race.ElementalAttributes;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.races.IRaceHandler;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.IAbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.util.compat.artemislib.SizeAttribute;
import xzeroair.trinkets.util.handlers.RaceAttributeHandler;
import xzeroair.trinkets.util.handlers.SizeHandler;

public abstract class EntityRacePropertiesHandler
implements IRaceHandler {
    protected boolean firstUpdate;
    protected EntityLivingBase entity;
    protected EntityProperties properties;
    protected ElementalAttributes element;
    protected EntityRace race;
    protected RaceAttributeHandler attributes;
    protected SizeAttribute artemisSupport;
    protected boolean MainAbility = false;
    protected boolean SecondaryAbility = false;

    public EntityRacePropertiesHandler(@Nonnull EntityLivingBase e, EntityProperties properties, @Nonnull EntityRace race) {
        this.entity = e;
        this.race = race;
        this.properties = properties;
        this.attributes = new RaceAttributeHandler(race);
        this.artemisSupport = this.getArtemisAttributeSize();
        this.firstUpdate = true;
    }

    public RaceAttributeHandler getAttributes() {
        return this.attributes;
    }

    protected void addAbility(IAbilityInterface ability, IAbilityHandler handler) {
        this.properties.getAbilityHandler().addAbility(ability, AbilityHandler.AbilitySource.RACE.getName() + ";" + this.race.getName(), handler);
    }

    public void onTransform() {
        this.startTransformation();
    }

    public void onTransformEnd() {
        this.endTransformation();
        this.attributes.removeAttibutes(this.entity);
        this.artemisSupport.removeModifiers();
        this.properties.getAbilityHandler().clearAbilities(AbilityHandler.AbilitySource.RACE.getName() + ";" + this.race.getName());
    }

    public void onTick() {
        SizeHandler.setSize(this.entity, this.properties);
        if (this.properties.isTransformed()) {
            this.attributes.addAttributes(this.entity);
            this.artemisSupport.addModifiers();
            this.whileTransformed();
        }
    }

    private SizeAttribute getArtemisAttributeSize() {
        double size = (double)(this.race.getRaceSize() - 100) * 0.01;
        return new SizeAttribute(this.entity, size, size, 0);
    }

    public void copyFrom(EntityRacePropertiesHandler properties, boolean wasDeath, boolean keepInv) {
    }

    public boolean isCreativePlayer() {
        boolean flag = this.entity instanceof EntityPlayer && (((EntityPlayer)this.entity).func_184812_l_() || ((EntityPlayer)this.entity).func_175149_v());
        return flag;
    }
}

