/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races.faelis;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.attributes.UpdatingAttribute;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.capabilities.statushandler.StatusHandler;
import xzeroair.trinkets.client.model.FaelisEars;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.faelis.config.FaelisConfig;
import xzeroair.trinkets.traits.statuseffects.StatusEffectsEnum;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.helpers.AttributeHelper;

public class RaceFaelis
extends EntityRacePropertiesHandler {
    public static FaelisConfig serverConfig = TrinketsConfig.SERVER.races.faelis;
    protected UpdatingAttribute movement;
    protected UpdatingAttribute jump;
    private FaelisEars ears = new FaelisEars();

    public RaceFaelis(@Nonnull EntityLivingBase e, EntityProperties properties) {
        super(e, properties, EntityRaces.faelis);
        this.movement = new UpdatingAttribute(UUID.fromString("1c9ba72a-a558-4ccc-a997-777bf3a9859a"), SharedMonsterAttributes.field_111263_d);
        this.jump = new UpdatingAttribute(UUID.fromString("1c9ba72a-a558-4ccc-a997-777bf3a9859a"), JumpAttribute.Jump);
    }

    @Override
    public void startTransformation() {
    }

    @Override
    public void whileTransformed() {
        if (this.entity.field_70170_p.field_72995_K) {
            return;
        }
        boolean hasMilkBuff = false;
        if (TrinketsConfig.SERVER.races.faelis.penalties) {
            double amount = 0.0;
            double weight = RaceFaelis.serverConfig.penalty_amount;
            StatusHandler status = Capabilities.getStatusHandler((Entity)this.entity);
            if (status != null) {
                hasMilkBuff = status.getActiveEffects().containsKey(StatusEffectsEnum.Invigorated.getName());
            }
            try {
                for (ItemStack stack : this.entity.func_184193_aE()) {
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArmor)) continue;
                    double w = ConfigHelper.parseItemArmor(stack, RaceFaelis.serverConfig.heavyArmor);
                    amount -= w == 0.0 ? weight : w;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (amount != 0.0 && !hasMilkBuff) {
                this.movement.addModifier(this.entity, amount, 2);
                this.jump.addModifier(this.entity, amount, 2);
            } else {
                this.movement.removeModifier(this.entity);
                this.jump.removeModifier(this.entity);
            }
        } else {
            this.movement.removeModifier(this.entity);
            this.jump.removeModifier(this.entity);
        }
    }

    @Override
    public void endTransformation() {
        AttributeHelper.removeAttributes(this.entity, UUID.fromString("1c9ba72a-a558-4ccc-a997-777bf3a9859a"));
    }

    @Override
    public float hurtEntity(EntityLivingBase target, DamageSource source, float dmg) {
        if (!(source instanceof EntityDamageSourceIndirect || source.func_94541_c() || source.func_82725_o() || source.func_76352_a() || !(dmg > 0.0f))) {
            ItemStack stack1 = this.entity.func_184614_ca();
            ItemStack stack2 = this.entity.func_184592_cb();
            if (stack1.func_190926_b() && stack2.func_190926_b()) {
                dmg = (float)((double)dmg + RaceFaelis.serverConfig.bonus);
            }
        }
        return dmg;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderLayer(RenderLivingBase renderer, boolean isFake, boolean isSlim, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!TrinketsConfig.CLIENT.rendering || !this.properties.showTraits()) {
            return;
        }
        GlStateManager.func_179094_E();
        if (this.entity.func_70093_af()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.2, (double)0.0);
        }
        if (renderer instanceof RenderPlayer) {
            RenderPlayer rend = (RenderPlayer)renderer;
            rend.func_177087_b().field_78116_c.func_78794_c(scale);
        }
        if (this.entity.func_190630_a(EntityEquipmentSlot.HEAD)) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.02f, (float)-0.045f);
            GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
        }
        GlStateManager.func_179124_c((float)this.properties.getTraitColorHandler().getRed(), (float)this.properties.getTraitColorHandler().getGreen(), (float)this.properties.getTraitColorHandler().getBlue());
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        this.ears.func_78088_a((Entity)this.entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

