/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races.goblin;

import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.client.model.GoblinEars;
import xzeroair.trinkets.entity.AlphaWolf;
import xzeroair.trinkets.init.Abilities;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.goblin.config.GoblinConfig;
import xzeroair.trinkets.traits.abilities.AbilityClimbing;
import xzeroair.trinkets.util.TrinketsConfig;

public class RaceGoblin
extends EntityRacePropertiesHandler {
    public static final GoblinConfig serverConfig = TrinketsConfig.SERVER.races.goblin;
    private int cooldown = 0;
    private final ModelBase ears = new GoblinEars();

    public RaceGoblin(@Nonnull EntityLivingBase e, EntityProperties properties) {
        super(e, properties, EntityRaces.goblin);
    }

    @Override
    public void startTransformation() {
        this.addAbility(Abilities.blockClimbing, new AbilityClimbing());
        try {
            Entity mount = this.entity.func_184187_bx();
            if (mount instanceof AlphaWolf) {
                mount.func_184210_p();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endTransformation() {
        try {
            Entity mount = this.entity.func_184187_bx();
            if (mount instanceof AlphaWolf) {
                mount.func_184210_p();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void whileTransformed() {
        if (this.entity.func_184187_bx() instanceof AlphaWolf) {
            if (!this.entity.func_70644_a(MobEffects.field_76420_g)) {
                this.entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 100, 0, false, false));
            }
            if (!this.entity.func_70644_a(MobEffects.field_76428_l)) {
                this.entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 0, false, false));
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    @Override
    public void targetedByEnemy(EntityLivingBase enemy) {
        if (enemy instanceof EntityCreeper) {
            ((EntityCreeper)enemy).func_70624_b(null);
            ((EntityCreeper)enemy).func_70829_a(-1);
        }
    }

    @Override
    public float isHurt(DamageSource source, float dmg) {
        if (source.func_94541_c() && !TrinketHelper.AccessoryCheck(this.entity, ModItems.trinkets.TrinketDamageShield)) {
            float maxHP = this.entity.func_110143_aJ();
            float modifier = maxHP * 100.0f / 20.0f * 0.01f;
            float clampModifier = MathHelper.func_76131_a((float)modifier, (float)0.01f, (float)1.0f);
            return dmg * clampModifier;
        }
        if (source.func_76347_k()) {
            float modifier = 0.8f;
            if (source.func_76355_l().equalsIgnoreCase("Lava")) {
                modifier = 0.5f;
            }
            return dmg * modifier;
        }
        return dmg;
    }

    public void MountWolf(EntityWolf wolf) {
        if (wolf.func_70909_n() && wolf.func_152114_e(this.entity)) {
            World world = this.entity.func_130014_f_();
            if (!world.field_72995_K) {
                AlphaWolf newWolf = new AlphaWolf(world);
                NBTTagCompound tag = new NBTTagCompound();
                wolf.func_189511_e(tag);
                tag.func_74778_a("id", EntityList.func_191306_a(wolf.getClass()).toString());
                newWolf.storeOldWolf(tag);
                newWolf.func_96094_a(wolf.func_95999_t());
                newWolf.func_70012_b(wolf.field_70165_t, wolf.field_70163_u, wolf.field_70161_v, wolf.field_70177_z, 0.0f);
                newWolf.setTamedBy(this.entity);
                newWolf.func_70606_j(wolf.func_110143_aJ());
                world.func_72838_d((Entity)newWolf);
                this.entity.func_184220_m((Entity)newWolf);
                wolf.func_70106_y();
            }
        }
    }

    @Override
    public void interact(PlayerInteractEvent event) {
        boolean canRide = RaceGoblin.serverConfig.rider;
        if (!canRide) {
            return;
        }
        if (this.entity.func_184187_bx() instanceof AlphaWolf && event.getHand() == EnumHand.OFF_HAND) {
            double reachDistance = 5.0;
            IAttributeInstance reachAttribe = this.entity.func_110148_a(EntityPlayer.REACH_DISTANCE);
            if (reachAttribe != null) {
                reachDistance = reachAttribe.func_111126_e();
            }
            AlphaWolf wolf = (AlphaWolf)this.entity.func_184187_bx();
            wolf.MountedAttack(event.getEntityPlayer(), reachDistance);
        }
    }

    @Override
    public void interactWithEntity(PlayerInteractEvent.EntityInteract event) {
        boolean canRide = RaceGoblin.serverConfig.rider;
        if (!canRide) {
            return;
        }
        Entity target = event.getTarget();
        if (event.getHand() == EnumHand.OFF_HAND && target instanceof EntityWolf) {
            boolean hasBone;
            EntityWolf wolf = (EntityWolf)target;
            if (wolf.func_70631_g_()) {
                return;
            }
            ItemStack mainStack = this.entity.func_184614_ca();
            ItemStack offStack = this.entity.func_184592_cb();
            boolean flag = !mainStack.func_190926_b() && !(mainStack.func_77973_b() instanceof ItemFood);
            boolean flag1 = !offStack.func_190926_b();
            boolean bl = hasBone = flag || flag1;
            if (mainStack.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("carryon") || offStack.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("carryon")) {
                return;
            }
            if (wolf.func_70909_n() && wolf.func_152114_e(this.entity) && hasBone) {
                this.MountWolf(wolf);
            }
        }
    }

    @Override
    public boolean mountEntity(Entity mount) {
        return super.mountEntity(mount);
    }

    @Override
    public boolean dismountedEntity(Entity mount) {
        return super.dismountedEntity(mount);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderLayer(RenderLivingBase renderer, boolean isFake, boolean isSlim, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!TrinketsConfig.CLIENT.rendering || !this.properties.showTraits()) {
            return;
        }
        GlStateManager.func_179094_E();
        if (this.entity.func_70093_af()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.2, (double)0.0);
        }
        if (renderer instanceof RenderPlayer) {
            RenderPlayer rend = (RenderPlayer)renderer;
            rend.func_177087_b().field_78116_c.func_78794_c(scale);
        }
        if (this.entity.func_190630_a(EntityEquipmentSlot.HEAD)) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.02f, (float)-0.045f);
            GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
        }
        GlStateManager.func_179124_c((float)this.properties.getTraitColorHandler().getRed(), (float)this.properties.getTraitColorHandler().getGreen(), (float)this.properties.getTraitColorHandler().getBlue());
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        this.ears.func_78088_a((Entity)this.entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderPlayerPre(EntityPlayer entity, double x, double y, double z, RenderPlayer renderer, float partialTick) {
        if (entity.func_184218_aH() && !(entity.func_184187_bx() instanceof AlphaWolf)) {
            double t = 0.0;
            t = (double)(100 - this.properties.getSize()) * 0.01;
            double t1 = (double)(entity.field_70131_O * 100.0f) / 180.0;
            double t2 = 180.0 / (double)(entity.field_70131_O * 100.0f);
            GlStateManager.func_179137_b((double)0.0, (double)(t *= t2 * 0.5), (double)0.0);
        }
    }
}

