/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.traits.abilities.IAbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IItemHeldAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.helpers.CallHelper;

public class AbilityHandler {
    protected EntityLivingBase entity;
    protected Map<IAbilityInterface, Storage> abilities = new HashMap<IAbilityInterface, Storage>();

    public AbilityHandler(EntityLivingBase entity) {
        this.entity = entity;
    }

    public void tickAbilities(EntityLivingBase entity) {
        for (IAbilityInterface ability : this.getAbilitiesList()) {
            IAbilityHandler handler;
            try {
                handler = this.getAbilityInstance(ability);
                if (handler != null && handler instanceof IItemHeldAbility) {
                    IItemHeldAbility a = (IItemHeldAbility)handler;
                    a.head(entity.func_184582_a(EntityEquipmentSlot.HEAD));
                    a.chest(entity.func_184582_a(EntityEquipmentSlot.CHEST));
                    a.legs(entity.func_184582_a(EntityEquipmentSlot.LEGS));
                    a.feet(entity.func_184582_a(EntityEquipmentSlot.FEET));
                    a.heldMainHand(entity.func_184614_ca());
                    a.heldOffhand(entity.func_184592_cb());
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)entity;
                        a.playerInventory(player.field_71071_by);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                handler = this.getAbilityInstance(ability);
                if (handler == null || !(handler instanceof ITickableAbility)) continue;
                ((ITickableAbility)handler).tickAbility(entity);
            }
            catch (Exception e) {
                Trinkets.log.error("Error with ability:" + ability.getName());
                e.printStackTrace();
            }
        }
    }

    public Map<IAbilityInterface, Storage> getAbilities() {
        return this.abilities;
    }

    public Set<IAbilityInterface> getAbilitiesList() {
        return this.abilities.keySet();
    }

    public void cleanUp() {
        ArrayList<IAbilityInterface> removal = new ArrayList<IAbilityInterface>();
        for (Map.Entry<IAbilityInterface, Storage> entry : this.abilities.entrySet()) {
            if (entry.getValue().handler() == null || !entry.getValue().handler().shouldRemove()) continue;
            removal.add(entry.getKey());
        }
        removal.forEach(ability -> this.removeAbility((IAbilityInterface)ability, ""));
    }

    public void accessoriesCheck(Map<String, ItemStack> equipped) {
        if (equipped != null && !equipped.isEmpty() && !this.abilities.isEmpty()) {
            for (IAbilityInterface ability : this.getAbilitiesList()) {
                String srcObj;
                String source;
                Storage storage = this.getAbilityStorage(ability);
                if (storage == null || !(source = storage.getSource()).startsWith(AbilitySource.EQUIPPED.getName()) || (srcObj = CallHelper.getStringFromArray(source.split(";"), 1)).isEmpty()) continue;
                boolean keep = false;
                for (Map.Entry<String, ItemStack> stack : equipped.entrySet()) {
                    if (!stack.getValue().func_77973_b().getRegistryName().toString().contentEquals(srcObj)) continue;
                    keep = true;
                    break;
                }
                if (keep || storage.handler() == null) continue;
                storage.handler().scheduleRemoval();
            }
        }
    }

    public boolean hasAbility(IAbilityInterface ability) {
        return ability != null && !this.abilities.isEmpty() && this.abilities.containsKey(ability);
    }

    public boolean isSource(IAbilityInterface ability, String source) {
        return this.hasAbility(ability) && this.abilities.get(ability) != null && this.abilities.get(ability).getSource().contentEquals(source);
    }

    public boolean isSource(IAbilityInterface ability, AbilitySource type, String source) {
        return this.isSource(ability, type.getName() + ";" + source);
    }

    public IAbilityHandler getAbilityInstance(IAbilityInterface ability) {
        if (this.hasAbility(ability) && this.abilities.get(ability) != null && this.abilities.get(ability).handler() != null) {
            IAbilityHandler handler = this.abilities.get(ability).handler();
            return handler;
        }
        return null;
    }

    public String getAbilitySource(IAbilityInterface ability) {
        if (this.hasAbility(ability) && this.abilities.get(ability) != null) {
            return this.abilities.get(ability).getSource();
        }
        return null;
    }

    public Storage getAbilityStorage(IAbilityInterface ability) {
        if (this.hasAbility(ability)) {
            return this.abilities.get(ability);
        }
        return null;
    }

    public IAbilityInterface getAbilityByName(String name) {
        for (IAbilityInterface ability : this.getAbilitiesList()) {
            if (!ability.getName().contentEquals(name)) continue;
            return ability;
        }
        return null;
    }

    public void addAbility(IAbilityInterface ability, String source, IAbilityHandler handler) {
        if (ability == null) {
            Trinkets.log.error("Trinkets had an Error adding an Ability from:" + source);
            return;
        }
        if (!this.hasAbility(ability)) {
            this.abilities.put(ability, new Storage(source, handler));
        } else if (source.startsWith(AbilitySource.RACE.getName())) {
            this.replaceAbility(ability, source, handler);
        }
    }

    public void replaceAbility(IAbilityInterface ability, String source, IAbilityHandler handler) {
        if (ability == null) {
            Trinkets.log.error("Trinkets had an Error adding an Ability from:" + source);
            return;
        }
        if (this.hasAbility(ability)) {
            if (!this.isSource(ability, source)) {
                this.abilities.replace(ability, new Storage(source, handler));
            }
        } else {
            this.addAbility(ability, source, handler);
        }
    }

    public void removeAbility(IAbilityInterface ability, String source) {
        if (ability == null) {
            Trinkets.log.error("Trinkets had an Error adding an Ability from:" + source + " Ability can not be null");
            return;
        }
        if (this.entity == null) {
            return;
        }
        if (this.hasAbility(ability) && (this.isSource(ability, source) || source.isEmpty())) {
            IAbilityHandler handler;
            Storage storage = this.abilities.get(ability);
            if (storage != null && (handler = storage.handler()) != null) {
                handler.removeAbility(this.entity);
            }
            this.abilities.remove(ability);
        }
    }

    public void clearAbilities(String source) {
        if (this.entity == null) {
            return;
        }
        if (!this.abilities.isEmpty()) {
            ArrayList<IAbilityInterface> removal = new ArrayList<IAbilityInterface>();
            for (Map.Entry<IAbilityInterface, Storage> entry : this.abilities.entrySet()) {
                if (entry.getValue() == null) continue;
                String src = entry.getValue().getSource();
                if (!source.isEmpty() && !source.contentEquals(src)) continue;
                IAbilityHandler handler = entry.getValue().handler();
                if (handler != null) {
                    handler.removeAbility(this.entity);
                }
                removal.add(entry.getKey());
            }
            for (IAbilityInterface ability : removal) {
                this.removeAbility(ability, "");
            }
        }
    }

    public static enum AbilitySource {
        OTHER(0, "Other"),
        RACE(1, "Race"),
        EQUIPPED(2, "Equipped");

        private static final AbilitySource[] ID;
        private int id;
        private String name;

        private AbilitySource(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getType() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static AbilitySource Type(int value) {
            if (value < 0 || value >= ID.length) {
                value = 0;
            }
            return ID[value];
        }

        public static int ID(String name) {
            for (AbilitySource ore : AbilitySource.values()) {
                if (!ore.getName().contentEquals(name)) continue;
                return ore.getType();
            }
            return OTHER.getType();
        }

        static {
            ID = new AbilitySource[AbilitySource.values().length];
        }
    }

    public static class Storage {
        String source;
        IAbilityHandler abilityHandler;

        public Storage(String source, IAbilityHandler handler) {
            this.source = source;
            this.abilityHandler = handler;
        }

        public Storage(AbilitySource Type2, String source, IAbilityHandler handler) {
            this(Type2.getName() + ";" + source, handler);
        }

        public IAbilityHandler handler() {
            return this.abilityHandler;
        }

        public String getSource() {
            return this.source;
        }
    }
}

