/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.client.keybinds.IKeyBindInterface;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.client.particles.ParticleGreed;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.traits.abilities.base.AbilityBase;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IToggleAbility;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigDragonsEye;
import xzeroair.trinkets.util.handlers.TickHandler;
import xzeroair.trinkets.util.helpers.CallHelper;
import xzeroair.trinkets.util.helpers.OreTrackingHelper;
import xzeroair.trinkets.util.helpers.RayTraceHelper;
import xzeroair.trinkets.util.helpers.TranslationHelper;

public class AbilityBlockFinder
extends AbilityBase
implements ITickableAbility,
IToggleAbility,
IKeyBindInterface {
    private final ConfigDragonsEye serverConfig;
    private final TrinketsConfig.xClient.TrinketItems.Dragon clientConfig;
    private boolean firstTick;
    private final List<Vec3d> list;
    int targetValue;

    public AbilityBlockFinder() {
        this.serverConfig = TrinketsConfig.SERVER.Items.DRAGON_EYE;
        this.clientConfig = TrinketsConfig.CLIENT.items.DRAGON_EYE;
        this.firstTick = false;
        this.list = new ArrayList<Vec3d>();
        this.targetValue = -1;
        this.firstTick = true;
    }

    private List<Vec3d> getTargetsList() {
        return this.list;
    }

    @Override
    public boolean abilityEnabled() {
        return this.targetValue > 0;
    }

    @Override
    public IToggleAbility toggleAbility(boolean enabled) {
        return this;
    }

    @Override
    public IToggleAbility toggleAbility(int value) {
        this.targetValue = value;
        return this;
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        block18: {
            if (!this.serverConfig.oreFinder) break block18;
            if (!entity.func_130014_f_().field_72995_K) {
                return;
            }
            int length = this.serverConfig.BLOCKS.Blocks.length;
            if (this.targetValue < 0 || this.targetValue > length) {
                return;
            }
            String target = CallHelper.getStringFromArray(this.serverConfig.BLOCKS.Blocks, this.targetValue);
            if (target.isEmpty()) {
                return;
            }
            int vd = this.serverConfig.BLOCKS.DR.C00_VD;
            int hd = this.serverConfig.BLOCKS.DR.C001_HD;
            int rf = this.clientConfig.C00_RR;
            if (!this.getTargetsList().isEmpty()) {
                this.getTargetsList().clear();
            }
            List<Vec3d> TrackingList = this.getTargetsList();
            String[] itemConfig = target.replace("[", ";").replace("]", "").split(";");
            String itemString = CallHelper.getStringFromArray(itemConfig, 0);
            String metaString = itemString.contains(":") ? CallHelper.getStringFromArray(itemConfig, 1) : "";
            String colorString = itemString.contains(":") ? CallHelper.getStringFromArray(itemConfig, 2) : CallHelper.getStringFromArray(itemConfig, 1);
            String getName = OreTrackingHelper.translateOreName(itemString, metaString);
            if (getName.endsWith(" Chest")) {
                getName = "Chest";
            }
            int color = OreTrackingHelper.getColor(getName);
            if (!colorString.isEmpty()) {
                try {
                    color = Integer.parseInt(colorString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Vec3d targetBlock = this.getClosestBlock(entity, entity.func_174813_aQ().func_72314_b((double)hd, (double)vd, (double)hd), itemString, metaString, TrackingList);
            TickHandler counter = this.getCounter("refresh_rate", rf, true);
            if (this.firstTick || counter.Tick()) {
                this.firstTick = false;
                if (entity.func_130014_f_().field_72995_K) {
                    if (this.serverConfig.BLOCKS.closest) {
                        double d = entity.func_70011_f(targetBlock.field_72450_a, targetBlock.field_72448_b, targetBlock.field_72449_c);
                        if (d < 1.8) {
                            return;
                        }
                        this.playSound(entity, new BlockPos(targetBlock), d);
                        for (int i = 0; i < 3; ++i) {
                            this.SpawnParticle(entity.func_130014_f_(), targetBlock, color);
                        }
                    } else if (!TrackingList.isEmpty()) {
                        double d = entity.func_70011_f(targetBlock.field_72450_a, targetBlock.field_72448_b, targetBlock.field_72449_c);
                        if (!(d < 1.8)) {
                            this.playSound(entity, new BlockPos(targetBlock), 1.0);
                        }
                        for (Vec3d pos : TrackingList) {
                            d = entity.func_70011_f(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                            if (d < 1.8) continue;
                            for (int i = 0; i < 3; ++i) {
                                this.SpawnParticle(entity.func_130014_f_(), pos, color);
                            }
                        }
                    }
                }
            }
        }
    }

    private Vec3d chestCartDetect(EntityLivingBase player, Vec3d pos, AxisAlignedBB aabb, List<Vec3d> trackingList) {
        List cartList = player.func_130014_f_().func_72872_a(EntityMinecartChest.class, aabb);
        Vec3d target = pos;
        double d = 100.0;
        if (!cartList.isEmpty()) {
            for (EntityMinecartChest chestCart : cartList) {
                double distance = player.func_70032_d((Entity)chestCart);
                if (!(distance < d)) continue;
                d = distance;
                target = chestCart.func_174791_d();
                if (this.serverConfig.BLOCKS.closest || trackingList.contains(target)) continue;
                trackingList.add(target);
            }
        }
        return target;
    }

    private Vec3d getClosestBlock(EntityLivingBase player, AxisAlignedBB aabb, String target, String meta, List<Vec3d> trackingList) {
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
        Vec3d closest = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        double d = 100.0;
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos pos = new BlockPos(k1, l1, i2);
                    IBlockState state = player.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    double distance = player.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    if (!(distance < d) || block.getRegistryName().toString().contentEquals("minecraft:air")) continue;
                    if (target.contains(":")) {
                        if (meta.isEmpty()) {
                            if (!block.getRegistryName().toString().contentEquals(target)) continue;
                            if (this.serverConfig.BLOCKS.closest) {
                                d = distance;
                            }
                            closest = new Vec3d((double)k1, (double)l1, (double)i2);
                            if (this.serverConfig.BLOCKS.closest || trackingList.contains(closest)) continue;
                            trackingList.add(closest);
                            continue;
                        }
                        if (!block.getRegistryName().toString().contentEquals(target) || meta.isEmpty() || !meta.contentEquals("*") && !meta.contentEquals("32767") && block.func_176201_c(state) != Integer.parseInt(meta)) continue;
                        if (this.serverConfig.BLOCKS.closest) {
                            d = distance;
                        }
                        closest = new Vec3d((double)k1, (double)l1, (double)i2);
                        if (this.serverConfig.BLOCKS.closest || trackingList.contains(closest)) continue;
                        trackingList.add(closest);
                        continue;
                    }
                    ItemStack blockStack = new ItemStack(block, 1, block.func_176201_c(state));
                    if (blockStack.func_190926_b()) continue;
                    for (String oreDictionary : OreTrackingHelper.getOreNames(blockStack)) {
                        if (!oreDictionary.contentEquals(target)) continue;
                        if (this.serverConfig.BLOCKS.closest) {
                            d = distance;
                        }
                        closest = new Vec3d((double)k1, (double)l1, (double)i2);
                        if (this.serverConfig.BLOCKS.closest || trackingList.contains(closest)) continue;
                        trackingList.add(closest);
                    }
                }
            }
        }
        if (target.equalsIgnoreCase("minecraft:chest")) {
            Vec3d closestCart = this.chestCartDetect(player, closest, aabb, trackingList);
            double distance = player.func_70011_f(closestCart.field_72450_a, closestCart.field_72448_b, closestCart.field_72449_c);
            if (distance < d) {
                if (this.serverConfig.BLOCKS.closest) {
                    d = distance;
                }
                closest = closestCart;
                if (!this.serverConfig.BLOCKS.closest && !trackingList.contains(closest)) {
                    trackingList.add(closest);
                }
            }
        }
        return closest;
    }

    protected boolean isBlockInList(IBlockState state, World world, BlockPos pos) {
        if (state == null || world == null || pos == null) {
            return false;
        }
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawPath(EntityLivingBase player, Vec3d target, int color) {
        double d = player.func_70011_f(target.field_72450_a, target.field_72448_b, target.field_72449_c);
        if (d > 2.0) {
            RayTraceHelper.Beam beam = new RayTraceHelper.Beam(player.field_70170_p, player, d, 1.0, false);
            GlStateManager.func_179094_E();
            RayTraceHelper.drawPath(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e() * 0.8, 0.0), target, player.field_70170_p, beam, color, 2.0);
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void SpawnParticle(World world, Vec3d pos, int color) {
        double X = Reference.random.nextDouble() + pos.field_72450_a;
        double Y = Reference.random.nextDouble() + pos.field_72448_b;
        double Z = Reference.random.nextDouble() + pos.field_72449_c;
        GlStateManager.func_179094_E();
        ParticleGreed effect = new ParticleGreed(world, new Vec3d(X, Y, Z), color, 1.0f, false);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)effect);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    protected void playSound(EntityLivingBase entity, BlockPos pos, double distance) {
        if (this.clientConfig.Dragon_Growl && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean sneaking = this.clientConfig.Dragon_Growl_Sneak.contentEquals("SNEAK") && player.func_70093_af();
            boolean standing = this.clientConfig.Dragon_Growl_Sneak.contentEquals("STAND") && !player.func_70093_af();
            boolean both = this.clientConfig.Dragon_Growl_Sneak.contentEquals("BOTH");
            float configVolume = this.clientConfig.Dragon_Growl_Volume;
            float volume = configVolume / 100.0f;
            int drH = this.serverConfig.BLOCKS.DR.C001_HD;
            int drV = this.serverConfig.BLOCKS.DR.C00_VD;
            double test = MathHelper.func_76129_c((float)(drH * drH + drV * drV));
            if (test <= 0.0) {
                test = 1.0;
            }
            if (sneaking && !standing || standing && !sneaking || both) {
                float v = 1.0f;
                try {
                    v = (float)(1.0 - distance / test);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pos != null) {
                    player.field_70170_p.func_184133_a(player, pos, SoundEvents.field_187525_aO, SoundCategory.PLAYERS, v * volume, 1.0f);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getKey() {
        String kb = ModKeyBindings.DRAGONS_EYE_TARGET.getDisplayName();
        return kb;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getAuxKey() {
        return ModKeyBindings.AUX_KEY.getDisplayName();
    }

    @Override
    public boolean onKeyPress(Entity entity, boolean Aux) {
        if (TrinketsConfig.SERVER.Items.DRAGON_EYE.oreFinder) {
            int size = TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.Blocks.length;
            int off = size - size - 1;
            int max = size - 1;
            if (!Aux) {
                if (this.targetValue < size) {
                    ++this.targetValue;
                }
                if (this.targetValue == size) {
                    this.targetValue = off;
                }
            } else {
                if (this.targetValue > off - 1) {
                    --this.targetValue;
                }
                if (this.targetValue == off - 1) {
                    this.targetValue = max;
                }
            }
            if (this.targetValue > size) {
                this.targetValue = off;
            }
            if (entity instanceof EntityPlayer && entity.field_70170_p.field_72995_K) {
                ItemStack stack = new ItemStack(ModItems.trinkets.TrinketDragonsEye);
                EntityPlayer player = (EntityPlayer)entity;
                TextComponentTranslation UnkownTarget = new TextComponentTranslation(stack.func_77977_a() + ".treasurefinder.notfound", new Object[0]);
                TextComponentTranslation FinderOn = new TextComponentTranslation(stack.func_77977_a() + ".treasurefinder.on", new Object[0]);
                TextComponentTranslation FinderOff = new TextComponentTranslation(stack.func_77977_a() + ".treasurefinder.off", new Object[0]);
                if (this.targetValue != off) {
                    String NotFound = TranslationHelper.formatLangKeys(stack, UnkownTarget);
                    String FoundTarget = TranslationHelper.translateDragonEyeTarget(FinderOn.func_150254_d(), this.targetValue);
                    String Message = FoundTarget.isEmpty() ? NotFound : FoundTarget;
                    player.func_146105_b((ITextComponent)new TextComponentString(Message), true);
                } else {
                    String offMode = TranslationHelper.formatLangKeys(stack, FinderOff);
                    player.func_146105_b((ITextComponent)new TextComponentString(offMode), true);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void loadStorage(NBTTagCompound nbt) {
    }

    @Override
    public void saveStorage(NBTTagCompound nbt) {
    }
}

