/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xzeroair.trinkets.traits.abilities.base.AbilityBase;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.BlockHelper;

public class AbilityClimbing
extends AbilityBase
implements ITickableAbility {
    private float entityHeight;
    private BlockPos entityPos;
    private BlockPos bodyPos;
    private BlockPos headPos;
    private BlockPos headSpacePos;
    private BlockPos frontBodyPos;
    private BlockPos frontHeadPos;
    private IBlockState body;
    private IBlockState head;
    private IBlockState headSpace;
    private IBlockState frontBody;
    private IBlockState frontHead;
    private final String[] climbList;

    public AbilityClimbing() {
        this.climbList = TrinketsConfig.SERVER.races.fairy.allowedBlocks;
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        boolean flag;
        boolean bl = entity instanceof EntityPlayer ? !((EntityPlayer)entity).field_71075_bZ.field_75100_b : (flag = true);
        if (flag && !entity.field_70122_E && entity.field_70123_F && this.canClimb(entity)) {
            if (!entity.func_70093_af()) {
                entity.field_70181_x = 0.1f;
            }
            if (entity.func_70093_af()) {
                entity.field_70181_x = 0.0;
            }
            entity.field_70143_R = 0.0f;
        }
    }

    protected boolean movingForward(EntityLivingBase entity, EnumFacing facing) {
        return (double)facing.func_176730_m().func_177958_n() * entity.field_70159_w > 0.0 || (double)facing.func_176730_m().func_177952_p() * entity.field_70179_y > 0.0;
    }

    protected boolean canClimb(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        this.bodyPos = this.entityPos = new BlockPos(entity.func_174791_d());
        this.frontBodyPos = this.entityPos.func_177982_a(0, 0, 0).func_177972_a(entity.func_184172_bi());
        this.body = world.func_180495_p(this.bodyPos);
        this.frontBody = world.func_180495_p(this.frontBodyPos);
        boolean flag1 = BlockHelper.isBlockInList(world, this.body, this.bodyPos, this.climbList);
        boolean flag2 = BlockHelper.isBlockInList(world, this.frontBody, this.frontBodyPos, this.climbList);
        boolean whitelist = TrinketsConfig.SERVER.races.fairy.whitelistClimbables;
        if (flag1 || flag2) {
            return whitelist;
        }
        return !whitelist;
    }
}

