/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.ImmutablePair;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.traits.abilities.base.AbilityBase;
import xzeroair.trinkets.traits.abilities.interfaces.IMiningAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.handlers.TickHandler;

public class AbilityFlying
extends AbilityBase
implements ITickableAbility,
IPotionAbility,
IMiningAbility {
    protected boolean flightEnabled = false;
    protected boolean speedModified = false;
    protected float speed = 0.0f;
    protected float cost = 0.0f;

    public AbilityFlying setFlightEnabled(boolean enabled) {
        this.flightEnabled = enabled;
        return this;
    }

    public AbilityFlying setSpeedEnabled(boolean enabled) {
        this.speedModified = enabled;
        return this;
    }

    public AbilityFlying setFlightSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public AbilityFlying setFlightCost(float cost) {
        this.cost = cost;
        return this;
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        boolean flag;
        EntityProperties prop = Capabilities.getEntityRace((Entity)entity);
        boolean bl = flag = prop != null && prop.showTraits();
        if (this.flightEnabled && flag) {
            this.addFlyingAbility(entity);
            if (this.speedModified && this.speed != 0.0f && this.speed != Float.NaN) {
                this.setFlyingSpeed(entity, this.speed);
            }
        } else {
            this.removeFlyingAbility(entity);
        }
    }

    @Override
    public boolean potionApplied(EntityLivingBase entity, PotionEffect effect, boolean cancel) {
        if (effect.func_188419_a().getRegistryName().toString().contentEquals("minecraft:levitation")) {
            return true;
        }
        return cancel;
    }

    @Override
    public ImmutablePair<Boolean, Float> breakingBlock(EntityLivingBase entity, IBlockState state, BlockPos pos, float originalSpeed, float newSpeed) {
        if (!entity.func_70055_a(Material.field_151586_h)) {
            float speed = originalSpeed;
            if (!entity.field_70122_E) {
                speed *= 5.0f;
            }
            if (newSpeed < speed) {
                return new ImmutablePair((Object)false, (Object)Float.valueOf(speed));
            }
        }
        return null;
    }

    protected void setFlyingSpeed(EntityLivingBase entity, float flightSpeed) {
        if (entity != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!this.isCreativePlayer((Entity)player)) {
                if (player.field_70170_p.field_72995_K && flightSpeed > 0.0f) {
                    player.field_71075_bZ.func_75092_a(flightSpeed);
                }
            } else if (player.field_71075_bZ.func_75093_a() == flightSpeed) {
                player.field_71075_bZ.func_75092_a(0.05f);
            }
        }
    }

    protected void addFlyingAbility(EntityLivingBase entity) {
        EntityPlayer player;
        if (entity != null && entity instanceof EntityPlayer && !this.isCreativePlayer((Entity)(player = (EntityPlayer)entity))) {
            MagicStats magic = Capabilities.getMagicStats((Entity)entity);
            if (this.cost > 0.0f && magic != null) {
                TickHandler counter;
                boolean flying = player.field_71075_bZ.field_75100_b;
                float mp = magic.getMana();
                if (mp >= this.cost) {
                    if (!player.field_71075_bZ.field_75101_c) {
                        player.field_71075_bZ.field_75101_c = true;
                    }
                } else if (flying) {
                    this.removeFlyingAbility((EntityLivingBase)player);
                }
                if (player.field_71075_bZ.field_75100_b && (counter = this.getCounter("fly_timer", true)) != null && counter.Tick() && !magic.spendMana(this.cost)) {
                    this.removeFlyingAbility((EntityLivingBase)player);
                }
            } else if (!player.field_71075_bZ.field_75101_c) {
                player.field_71075_bZ.field_75101_c = true;
            }
        }
    }

    protected void removeFlyingAbility(EntityLivingBase entity) {
        EntityPlayer player;
        if (entity != null && entity instanceof EntityPlayer && !this.isCreativePlayer((Entity)(player = (EntityPlayer)entity)) && player.field_71075_bZ.field_75101_c) {
            player.field_71075_bZ.field_75100_b = false;
            player.field_71075_bZ.field_75101_c = false;
            if (player.field_70170_p.field_72995_K && player.field_71075_bZ.func_75093_a() != 0.05f) {
                player.field_71075_bZ.func_75092_a(0.05f);
            }
        }
    }

    @Override
    public void addAbility(EntityLivingBase entity) {
        this.addFlyingAbility(entity);
    }

    @Override
    public void removeAbility(EntityLivingBase entity) {
        this.removeFlyingAbility(entity);
        this.removeCounter("fly_timer");
    }
}

