/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.client.events.ScreenOverlayEvents;
import xzeroair.trinkets.client.keybinds.IKeyBindInterface;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.particles.EffectsRenderPacket;
import xzeroair.trinkets.traits.abilities.base.AbilityBase;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.lycanitesmobs.LycanitesCompat;
import xzeroair.trinkets.util.helpers.RayTraceHelper;

public class AbilityLightningBolt
extends AbilityBase
implements ITickableAbility,
IKeyBindInterface {
    boolean cast;
    boolean check = false;
    private int heldDuration;
    private int charge = 0;

    @Override
    public void tickAbility(EntityLivingBase entity) {
        LycanitesCompat.removeParalysis(entity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getKey() {
        return ModKeyBindings.ARCING_ORB_ABILITY.getDisplayName();
    }

    @Override
    public boolean onKeyPress(Entity entity, boolean Aux) {
        float iCost = TrinketsConfig.SERVER.Items.ARCING_ORB.attackCost;
        MagicStats magic = Capabilities.getMagicStats(entity);
        this.reset(entity);
        this.cast = true;
        if (magic != null) {
            float maxMP = magic.getMaxMana();
            float MP = magic.getMana();
            float limit = iCost * 0.1f;
            if (iCost >= limit && MP < limit) {
                this.reset(entity);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onKeyDown(Entity entity, boolean Aux) {
        float iCost = TrinketsConfig.SERVER.Items.ARCING_ORB.attackCost;
        MagicStats magic = Capabilities.getMagicStats(entity);
        int bonusTime = 50;
        int maxHoldTime = (int)iCost + 50;
        if (this.heldDuration <= maxHoldTime) {
            this.cast = true;
            ++this.heldDuration;
        } else {
            return false;
        }
        if (magic != null) {
            float limit;
            float maxMP = magic.getMaxMana();
            float MP = magic.getMana();
            if (MP < (limit = iCost * 0.1f)) {
                this.reset(entity);
                return false;
            }
            if (this.heldDuration <= 300) {
                ++this.charge;
            }
            float dur = (float)this.charge * 1.0f / ((float)(maxHoldTime - 50) * 1.0f);
            float percentage = MathHelper.func_76131_a((float)dur, (float)0.0f, (float)(MP / iCost));
            float realCost = iCost * percentage;
            if (this.heldDuration <= maxHoldTime - 50) {
                if (entity instanceof EntityPlayer && entity.field_70170_p.field_72995_K) {
                    entity.field_70170_p.func_184133_a((EntityPlayer)entity, entity.func_180425_c(), SoundEvents.field_193807_ew, SoundCategory.PLAYERS, 0.1f, 1.0f - dur);
                    ScreenOverlayEvents.instance.SyncCost(realCost);
                }
            } else if (entity instanceof EntityPlayer && entity.field_70170_p.field_72995_K) {
                ScreenOverlayEvents.instance.SyncCost(iCost);
                entity.field_70170_p.func_184133_a((EntityPlayer)entity, entity.func_180425_c(), SoundEvents.field_193785_eE, SoundCategory.PLAYERS, 0.1f, 1.0f - dur);
            }
        }
        return true;
    }

    @Override
    public boolean onKeyRelease(Entity entity, boolean Aux) {
        if (this.cast) {
            MagicStats magic = Capabilities.getMagicStats(entity);
            if (magic != null) {
                float iCost = TrinketsConfig.SERVER.Items.ARCING_ORB.attackCost;
                float dmg = TrinketsConfig.SERVER.Items.ARCING_ORB.attackDmg;
                float MP = magic.getMana();
                int bonusTime = 50;
                int maxHoldTime = (int)iCost + 50;
                float dur = (float)this.charge * 1.0f / ((float)(maxHoldTime - 50) * 1.0f);
                float percentage = MathHelper.func_76131_a((float)dur, (float)0.0f, (float)(MP / iCost));
                float realCost = iCost * percentage;
                float finalDamage = dmg * MathHelper.func_76131_a((float)percentage, (float)0.0f, (float)1.0f);
                if (magic.spendMana(realCost)) {
                    double maxDist = 15.0;
                    Vec3d start = entity.func_174824_e(1.0f);
                    Vec3d lookVec = entity.func_70040_Z();
                    Vec3d end = start.func_72441_c(lookVec.field_72450_a * 15.0, lookVec.field_72448_b * 15.0, lookVec.field_72449_c * 15.0);
                    RayTraceResult result = RayTraceHelper.rayTrace((EntityLivingBase)entity, 15.0);
                    Vec3d hitLoc = end;
                    if (result != null) {
                        if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                            Entity hit = result.field_72308_g;
                            hitLoc = result.field_72307_f.func_72441_c(0.0, (double)(hit.field_70131_O * 0.5f), 0.0);
                        } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                            hitLoc = result.field_72307_f;
                        }
                    }
                    if (Trinkets.proxy.getSide() == Side.CLIENT) {
                        NetworkHandler.sendToServer(new EffectsRenderPacket(entity, start.field_72450_a, start.field_72448_b, start.field_72449_c, hitLoc.field_72450_a, hitLoc.field_72448_b, hitLoc.field_72449_c, 2515356, 1, 0.9f, 3.0f));
                        NetworkHandler.sendToServer(new EffectsRenderPacket(entity, hitLoc.field_72450_a, hitLoc.field_72448_b, hitLoc.field_72449_c, hitLoc.field_72450_a, hitLoc.field_72448_b, hitLoc.field_72449_c, 2515356, 2, 0.9f, 3.0f));
                    }
                    if (!entity.func_130014_f_().field_72995_K) {
                        boolean pvpEnabled = false;
                        try {
                            if (entity instanceof EntityPlayerMP) {
                                pvpEnabled = ((EntityPlayerMP)entity).func_184102_h().func_71219_W();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        AxisAlignedBB bb1 = new AxisAlignedBB(new BlockPos(hitLoc)).func_186662_g(1.0);
                        Predicate Targets = Predicates.and((Predicate)EntitySelectors.field_180132_d, ent -> ent != null && ent.func_70067_L());
                        List splash = entity.field_70170_p.func_175674_a(entity, bb1, Targets);
                        for (Entity e : splash) {
                            if (e instanceof EntityPlayer && !pvpEnabled) continue;
                            if (dur > 0.33f && e instanceof EntityCreeper) {
                                EntityCreeper creep = (EntityCreeper)e;
                                EntityLightningBolt bolt = new EntityLightningBolt(entity.func_130014_f_(), creep.field_70165_t, creep.field_70163_u, creep.field_70161_v, true);
                                creep.func_70077_a(bolt);
                                creep.func_70066_B();
                            }
                            e.func_70097_a((DamageSource)new EntityDamageSource("lightningBolt", entity), finalDamage);
                        }
                    }
                    this.reset(entity);
                    return true;
                }
                this.reset(entity);
                return false;
            }
            this.reset(entity);
            return true;
        }
        this.reset(entity);
        return false;
    }

    private void reset(Entity entity) {
        this.heldDuration = 0;
        this.charge = 0;
        this.cast = false;
        if (entity.field_70170_p.field_72995_K) {
            ScreenOverlayEvents.instance.SyncCost(0.0f);
        }
    }
}

