/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.traits.abilities.base.AbilityBase;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigDamageShield;
import xzeroair.trinkets.util.handlers.TickHandler;

public class AbilityResistance
extends AbilityBase
implements ITickableAbility,
IAttackAbility,
IPotionAbility {
    protected static final TrinketsConfig.xClient.TrinketItems.Shield clientConfig = TrinketsConfig.CLIENT.items.DAMAGE_SHIELD;
    protected static final ConfigDamageShield serverConfig = TrinketsConfig.SERVER.Items.DAMAGE_SHIELD;
    int hitCount = 0;

    public int getHitCount() {
        return this.hitCount;
    }

    public AbilityResistance setHitCount(int hitCount) {
        this.hitCount = hitCount;
        return this;
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        int duration = 30;
        Potion resistance = Potion.func_180142_b((String)AbilityResistance.serverConfig.potionEffect);
        if (resistance == null) {
            resistance = MobEffects.field_76429_m;
        }
        if (!entity.func_70644_a(resistance)) {
            entity.func_70690_d(new PotionEffect(resistance, 30, AbilityResistance.serverConfig.resistance_level, false, false));
            this.removeCounter("CheckResist");
        } else {
            int dur = entity.func_70660_b(resistance).func_76459_b();
            int amp = entity.func_70660_b(resistance).func_76458_c();
            TickHandler counter = this.getCounter("CheckResist", true);
            boolean trigger = counter.Tick();
            if (trigger) {
                this.removeCounter("CheckResist");
            }
            if (dur > 30 && AbilityResistance.serverConfig.resistance_stacks) {
                if (amp <= AbilityResistance.serverConfig.resistance_level) {
                    entity.func_70690_d(new PotionEffect(resistance, 30, amp + 1, false, false));
                } else if (trigger && amp + 1 < 3) {
                    entity.func_70690_d(new PotionEffect(resistance, dur, amp + 1, false, false));
                }
            } else if (amp <= AbilityResistance.serverConfig.resistance_level) {
                entity.func_70690_d(new PotionEffect(resistance, 30, AbilityResistance.serverConfig.resistance_level, false, false));
            }
        }
    }

    @Override
    public boolean attacked(EntityLivingBase attacked, DamageSource source, float dmg, boolean cancel) {
        boolean indirect;
        if (AbilityResistance.serverConfig.damage_ignore && !attacked.field_70170_p.field_72995_K && dmg > 1.0f && (indirect = this.isIndirectDamage(source))) {
            this.countHit(attacked, indirect);
            if (this.trigger(attacked, indirect)) {
                return true;
            }
        }
        return cancel;
    }

    @Override
    public float hurt(EntityLivingBase attacked, DamageSource source, float dmg) {
        boolean indirect;
        if (AbilityResistance.serverConfig.damage_ignore && dmg > 1.0f && !(indirect = this.isIndirectDamage(source))) {
            this.countHit(attacked, indirect);
            if (this.trigger(attacked, indirect)) {
                dmg = 0.0f;
            }
        }
        if (AbilityResistance.serverConfig.explosion_resist && source.func_94541_c() && dmg > 1.0f) {
            return dmg * AbilityResistance.serverConfig.explosion_amount;
        }
        return dmg;
    }

    private void countHit(EntityLivingBase attacked, boolean indirect) {
        EntityPlayer player;
        ItemStack shield;
        TrinketProperties cap;
        ++this.hitCount;
        if (attacked instanceof EntityPlayer && (cap = Capabilities.getTrinketProperties(shield = TrinketHelper.getAccessory(player = (EntityPlayer)attacked, ModItems.trinkets.TrinketDamageShield))) != null) {
            cap.setCount(this.hitCount);
            cap.sendInformationToPlayer((EntityLivingBase)player, (EntityLivingBase)player);
        }
        EntityProperties prop = Capabilities.getEntityRace((Entity)attacked);
        NBTTagCompound tag = new NBTTagCompound();
        this.saveStorage(tag);
        prop.sendInformationToPlayer(attacked, tag);
    }

    private boolean trigger(EntityLivingBase attacked, boolean indirect) {
        if (this.hitCount > AbilityResistance.serverConfig.hits) {
            this.hitCount = 0;
            if (attacked instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)attacked;
                ItemStack shield = TrinketHelper.getAccessory(player, ModItems.trinkets.TrinketDamageShield);
                TrinketProperties cap = Capabilities.getTrinketProperties(shield);
                if (cap != null) {
                    cap.setCount(this.hitCount);
                    cap.sendInformationToPlayer((EntityLivingBase)player, (EntityLivingBase)player);
                }
                if (AbilityResistance.serverConfig.special) {
                    String quote;
                    String string = "Ow!";
                    VipStatus vip = Capabilities.getVipStatus((Entity)attacked);
                    if (vip != null && !(quote = vip.getRandomQuote()).isEmpty()) {
                        string = quote;
                    }
                    TextComponentString message = new TextComponentString(TextFormatting.BOLD + "" + TextFormatting.GOLD + string);
                    player.func_146105_b((ITextComponent)message, true);
                    if (AbilityResistance.clientConfig.effectVolume > 0.0) {
                        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187692_g, SoundCategory.PLAYERS, (float)AbilityResistance.clientConfig.effectVolume, 1.0f);
                    }
                }
            }
            EntityProperties prop = Capabilities.getEntityRace((Entity)attacked);
            NBTTagCompound tag = new NBTTagCompound();
            this.saveStorage(tag);
            prop.sendInformationToPlayer(attacked, tag);
            return true;
        }
        return false;
    }

    @Override
    public boolean potionApplied(EntityLivingBase entity, PotionEffect effect, boolean cancel) {
        Potion resistance = Potion.func_180142_b((String)AbilityResistance.serverConfig.potionEffect);
        if (resistance == null) {
            resistance = MobEffects.field_76429_m;
        }
        if (effect.func_188419_a().equals(resistance)) {
            TickHandler counter = this.getCounter("CheckResist", true);
            counter.setLength(effect.func_76459_b() - 1).setCountdown(true);
        }
        return cancel;
    }

    @Override
    public void removeAbility(EntityLivingBase entity) {
        Potion resistance = Potion.func_180142_b((String)AbilityResistance.serverConfig.potionEffect);
        if (resistance == null) {
            resistance = MobEffects.field_76429_m;
        }
        if (entity.func_70644_a(resistance)) {
            entity.func_184596_c(resistance);
            entity.func_70690_d(new PotionEffect(resistance, 10, AbilityResistance.serverConfig.resistance_level, false, false));
        }
    }

    @Override
    public void loadStorage(NBTTagCompound nbt) {
        if (nbt.func_74764_b("xat.hitCount")) {
            this.hitCount = nbt.func_74762_e("xat.hitCount");
        }
    }

    @Override
    public void saveStorage(NBTTagCompound nbt) {
        nbt.func_74768_a("xat.hitCount", this.hitCount);
    }
}

