/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.races.dragon.config.DragonConfig;
import xzeroair.trinkets.races.dwarf.config.DwarfConfig;
import xzeroair.trinkets.races.elf.config.ElfConfig;
import xzeroair.trinkets.races.faelis.config.FaelisConfig;
import xzeroair.trinkets.races.fairy.config.FairyConfig;
import xzeroair.trinkets.races.goblin.config.GoblinConfig;
import xzeroair.trinkets.races.titan.config.TitanConfig;
import xzeroair.trinkets.util.config.compat.CompatabilityConfigs;
import xzeroair.trinkets.util.config.gui.TrinketsContainerConfig;
import xzeroair.trinkets.util.config.gui.TrinketsPropertiesConfig;
import xzeroair.trinkets.util.config.mana.EntityManaConfig;
import xzeroair.trinkets.util.config.potions.PotionConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigArcingOrb;
import xzeroair.trinkets.util.config.trinkets.ConfigDamageShield;
import xzeroair.trinkets.util.config.trinkets.ConfigDragonsEye;
import xzeroair.trinkets.util.config.trinkets.ConfigEnderCrown;
import xzeroair.trinkets.util.config.trinkets.ConfigFaelisClaw;
import xzeroair.trinkets.util.config.trinkets.ConfigGlowRing;
import xzeroair.trinkets.util.config.trinkets.ConfigGreaterInertia;
import xzeroair.trinkets.util.config.trinkets.ConfigInertiaNull;
import xzeroair.trinkets.util.config.trinkets.ConfigPoisonStone;
import xzeroair.trinkets.util.config.trinkets.ConfigPolarizedStone;
import xzeroair.trinkets.util.config.trinkets.ConfigSeaStone;
import xzeroair.trinkets.util.config.trinkets.ConfigTeddyBear;
import xzeroair.trinkets.util.config.trinkets.ConfigWeightlessStone;
import xzeroair.trinkets.util.config.trinkets.ConfigWitherRing;
import xzeroair.trinkets.util.config.trinkets.shared.TransformationRingConfig;
import xzeroair.trinkets.util.helpers.CallHelper;

@Config(name="/trinkets/Trinkets_And_Baubles", modid="xat")
@Config.LangKey(value="xat.config.title")
public class TrinketsConfig {
    private static final String cfgPrefix = "xat.config";
    @Config.Name(value="Client Settings")
    @Config.LangKey(value="xat.config.client.settings")
    public static xClient CLIENT = new xClient();
    @Config.Name(value="Server Settings")
    @Config.LangKey(value="xat.config.server.settings")
    public static xServer SERVER = new xServer();
    @Config.Name(value="Compatability Settings")
    @Config.LangKey(value="xat.config.compatability")
    public static CompatabilityConfigs compat = new CompatabilityConfigs();

    public static Map<String, String> writeConfigMap() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("oreEnabled", "" + TrinketsConfig.SERVER.Items.DRAGON_EYE.oreFinder);
        configMap.put("oreEnabled.closest", "" + TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.closest);
        configMap.put("oreEnabled.blocks", CallHelper.combineStringArray(TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.Blocks));
        configMap.put("oreEnabled.hd", "" + TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.DR.C001_HD);
        configMap.put("oreEnabled.vd", "" + TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.DR.C00_VD);
        configMap.put("dragonFlight", "" + TrinketsConfig.SERVER.races.dragon.creative_flight);
        configMap.put("dragonFlightCost", "" + TrinketsConfig.SERVER.races.dragon.flight_cost);
        configMap.put("dragonFlightSpeed", "" + TrinketsConfig.SERVER.races.dragon.flight_speed);
        configMap.put("dragonBreathCost", "" + TrinketsConfig.SERVER.races.dragon.breath_cost);
        configMap.put("dragonBreathDamage", "" + TrinketsConfig.SERVER.races.dragon.breath_damage);
        configMap.put("fairyFlight", "" + TrinketsConfig.SERVER.races.fairy.creative_flight);
        configMap.put("fairyFlightSpeed", "" + TrinketsConfig.SERVER.races.fairy.flight_speed);
        configMap.put("fairyFlightCost", "" + TrinketsConfig.SERVER.races.fairy.flight_cost);
        configMap.put("TrinketContainer", "" + TrinketsConfig.SERVER.GUI.guiEnabled);
        configMap.put("compatTAN", "" + TrinketsConfig.compat.toughasnails);
        configMap.put("compatSD", "" + TrinketsConfig.compat.simpledifficulty);
        configMap.put("compatArtemisLib", "" + TrinketsConfig.compat.artemislib);
        configMap.put("compatElenaiDodge1", "" + TrinketsConfig.compat.elenaiDodge);
        configMap.put("compatElenaiDodge2", "" + TrinketsConfig.compat.elenaiDodge);
        configMap.put("compatEnhancedVisuals", "" + TrinketsConfig.compat.enhancedvisuals);
        configMap.put("compatLycanites", "" + TrinketsConfig.compat.lycanites);
        configMap.put("compatDefiledLands", "" + TrinketsConfig.compat.defiledlands);
        configMap.put("miscDepthStacking", "" + TrinketsConfig.SERVER.misc.depthStacks);
        configMap.put("miscBlockMovement", "" + TrinketsConfig.SERVER.misc.movement);
        configMap.put("raceBlacklist", CallHelper.combineStringArray(TrinketsConfig.SERVER.races.selectionBlacklist));
        return configMap;
    }

    public static void readConfigMap(Map<String, String> configMap) {
        if (configMap != null && !configMap.isEmpty()) {
            Trinkets.log.info("Found Server Config");
            for (Map.Entry<String, String> config : configMap.entrySet()) {
                try {
                    if (config.getKey().contentEquals("oreEnabled")) {
                        TrinketsConfig.SERVER.Items.DRAGON_EYE.oreFinder = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("oreEnabled.closest")) {
                        TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.closest = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("oreEnabled.blocks")) {
                        TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.Blocks = CallHelper.deconstructStringArray(config.getValue());
                    }
                    if (config.getKey().contentEquals("oreEnabled.hd")) {
                        TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.DR.C001_HD = Integer.parseInt(config.getValue());
                    }
                    if (config.getKey().contentEquals("oreEnabled.vd")) {
                        TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.DR.C00_VD = Integer.parseInt(config.getValue());
                    }
                    if (config.getKey().contentEquals("dragonFlight")) {
                        TrinketsConfig.SERVER.races.dragon.creative_flight = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("dragonFlightCost")) {
                        TrinketsConfig.SERVER.races.dragon.flight_cost = Float.parseFloat(config.getValue());
                    }
                    if (config.getKey().contentEquals("dragonFlightSpeed")) {
                        TrinketsConfig.SERVER.races.dragon.flight_speed = Double.parseDouble(config.getValue());
                    }
                    if (config.getKey().contentEquals("dragonBreathCost")) {
                        TrinketsConfig.SERVER.races.dragon.breath_cost = Float.parseFloat(config.getValue());
                    }
                    if (config.getKey().contentEquals("dragonBreathDamage")) {
                        TrinketsConfig.SERVER.races.dragon.breath_damage = Float.parseFloat(config.getValue());
                    }
                    if (config.getKey().contentEquals("fairyFlight")) {
                        TrinketsConfig.SERVER.races.fairy.creative_flight = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("fairyFlightSpeed")) {
                        TrinketsConfig.SERVER.races.fairy.flight_speed = Double.parseDouble(config.getValue());
                    }
                    if (config.getKey().contentEquals("fairyFlightCost")) {
                        TrinketsConfig.SERVER.races.fairy.flight_cost = Float.parseFloat(config.getValue());
                    }
                    if (config.getKey().contentEquals("TrinketContainer")) {
                        TrinketsConfig.SERVER.GUI.guiEnabled = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("compatTAN")) {
                        TrinketsConfig.compat.toughasnails = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("compatSD")) {
                        TrinketsConfig.compat.simpledifficulty = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("compatArtemisLib")) {
                        TrinketsConfig.compat.artemislib = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("compatElenaiDodge1")) {
                        TrinketsConfig.compat.elenaiDodge = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("compatElenaiDodge2")) {
                        TrinketsConfig.compat.elenaiDodge = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("compatEnhancedVisuals")) {
                        TrinketsConfig.compat.enhancedvisuals = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("compatLycanites")) {
                        TrinketsConfig.compat.lycanites = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("compatDefiledLands")) {
                        TrinketsConfig.compat.defiledlands = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("miscDepthStacking")) {
                        TrinketsConfig.SERVER.misc.depthStacks = Boolean.parseBoolean(config.getValue());
                    }
                    if (config.getKey().contentEquals("miscBlockMovement")) {
                        TrinketsConfig.SERVER.misc.movement = Boolean.parseBoolean(config.getValue());
                    }
                    if (!config.getKey().contentEquals("raceBlacklist")) continue;
                    TrinketsConfig.SERVER.races.selectionBlacklist = CallHelper.deconstructStringArray(config.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void Save() {
        ConfigManager.sync((String)"xat", (Config.Type)Config.Type.INSTANCE);
    }

    public static void readConfig() {
        Configuration cfg = Trinkets.config;
        try {
            cfg.load();
        }
        catch (Exception e1) {
            Trinkets.log.error("Xat had a problem loading it's configuration");
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    public static class xServer {
        @Config.Comment(value={"Should Trinkets and Baubles use it's own Built-in Container"})
        @Config.Name(value="Gui Settings")
        @Config.LangKey(value="xat.config.server.gui.settings")
        public GuiSettings GUI = new GuiSettings();
        @Config.Name(value="Magical Foods Settings")
        @Config.LangKey(value="xat.config.server.food.settings")
        public Foods Food = new Foods();
        @Config.Name(value="Potion Settings")
        @Config.LangKey(value="xat.config.server.potion.settings")
        public Potions Potion = new Potions();
        @Config.Name(value="Item Settings")
        @Config.LangKey(value="xat.config.items")
        public TrinketItems Items = new TrinketItems();
        @Config.Name(value="Magic Settings")
        @Config.LangKey(value="xat.config.magic")
        public EntityManaConfig mana = new EntityManaConfig();
        @Config.Name(value="Race Settings")
        @Config.LangKey(value="xat.config.races")
        public RaceConfigs races = new RaceConfigs();
        @Config.Name(value="Misc Settings")
        @Config.LangKey(value="xat.config.misc")
        public MiscConfigs misc = new MiscConfigs();

        public class MiscConfigs {
            @Config.RequiresWorldRestart
            @Config.Comment(value={"Does Depth Strider Stack with Swim Speed Attributes?"})
            @Config.Name(value="Depth Strider Stacks")
            @Config.LangKey(value="xat.config.misc.depth")
            public boolean depthStacks = false;
            @Config.RequiresWorldRestart
            @Config.Comment(value={"If enabled, the player will be unable to move when transforming from one race to another"})
            @Config.Name(value="Prevent Movement while transforming")
            @Config.LangKey(value="xat.config.misc.movement")
            public boolean movement = false;
        }

        public class RaceConfigs {
            public boolean selectionMenu = false;
            @Config.RequiresWorldRestart
            public String[] selectionBlacklist = new String[]{"Dragon"};
            @Config.Name(value="Fairy Settings")
            @Config.LangKey(value="xat.config.races.fairy")
            public FairyConfig fairy = new FairyConfig();
            @Config.Name(value="Dwarf Settings")
            @Config.LangKey(value="xat.config.races.dwarf")
            public DwarfConfig dwarf = new DwarfConfig();
            @Config.Name(value="Titan Settings")
            @Config.LangKey(value="xat.config.races.titan")
            public TitanConfig titan = new TitanConfig();
            @Config.Name(value="Goblin Settings")
            @Config.LangKey(value="xat.config.races.goblin")
            public GoblinConfig goblin = new GoblinConfig();
            @Config.Name(value="Elf Settings")
            @Config.LangKey(value="xat.config.races.elf")
            public ElfConfig elf = new ElfConfig();
            @Config.Name(value="Faelis Config")
            @Config.LangKey(value="xat.config.races.faelis")
            public FaelisConfig faelis = new FaelisConfig();
            @Config.Name(value="Dragon Config")
            @Config.LangKey(value="xat.config.races.dragon")
            public DragonConfig dragon = new DragonConfig();
        }

        public class TrinketItems {
            @Config.Name(value="Transformation Items")
            @Config.LangKey(value="xat.config.items.transformation")
            public RaceRings raceRings = new RaceRings();
            @Config.Name(value="Dragon's Eye Settings")
            @Config.LangKey(value="xat.config.dragons_eye")
            public ConfigDragonsEye DRAGON_EYE = new ConfigDragonsEye();
            @Config.Name(value="Ender Queen's Crown Settings")
            @Config.LangKey(value="xat.config.ender_tiara")
            public ConfigEnderCrown ENDER_CROWN = new ConfigEnderCrown();
            @Config.Name(value="Damage Shield Settings")
            @Config.LangKey(value="xat.config.damage_shield")
            public ConfigDamageShield DAMAGE_SHIELD = new ConfigDamageShield();
            @Config.Name(value="Ring of Enchanted Eyes Settings")
            @Config.LangKey(value="xat.config.glow_ring")
            public ConfigGlowRing GLOW_RING = new ConfigGlowRing();
            @Config.Name(value="Poison Stone Settings")
            @Config.LangKey(value="xat.config.poison_stone")
            public ConfigPoisonStone POISON_STONE = new ConfigPoisonStone();
            @Config.Name(value="Wither Ring Settings")
            @Config.LangKey(value="xat.config.wither_ring")
            public ConfigWitherRing WITHER_RING = new ConfigWitherRing();
            @Config.Name(value="Polarized Stone Settings")
            @Config.LangKey(value="xat.config.polarized_stone")
            public ConfigPolarizedStone POLARIZED_STONE = new ConfigPolarizedStone();
            @Config.Name(value="Stone of the Sea Settings")
            @Config.LangKey(value="xat.config.sea_stone")
            public ConfigSeaStone SEA_STONE = new ConfigSeaStone();
            @Config.Name(value="Stone of Inertia Null Settings")
            @Config.LangKey(value="xat.config.inertia_null_stone")
            public ConfigInertiaNull INERTIA_NULL = new ConfigInertiaNull();
            @Config.Name(value="Stone of Greater Inertia Settings")
            @Config.LangKey(value="xat.config.greater_inertia_stone")
            public ConfigGreaterInertia GREATER_INERTIA = new ConfigGreaterInertia();
            @Config.Name(value="Weightless Stone Settings")
            @Config.LangKey(value="xat.config.weightless_stone")
            public ConfigWeightlessStone WEIGHTLESS_STONE = new ConfigWeightlessStone();
            @Config.Name(value="Arcing Orb Settings")
            @Config.LangKey(value="xat.config.arcing_orb")
            public ConfigArcingOrb ARCING_ORB = new ConfigArcingOrb();
            @Config.Name(value="Teddy Bear Settings")
            @Config.LangKey(value="xat.config.teddy_bear")
            public ConfigTeddyBear TEDDY_BEAR = new ConfigTeddyBear();
            @Config.Name(value="Faelis Claw Settings")
            @Config.LangKey(value="xat.config.faelis_claw")
            public ConfigFaelisClaw FAELIS_CLAW = new ConfigFaelisClaw();

            public class RaceRings {
                @Config.Name(value="Dwarf Ring Settings")
                @Config.LangKey(value="xat.config.dwarf_ring")
                public TransformationRingConfig DWARF_RING = new TransformationRingConfig();
                @Config.Name(value="Elf Ring Settings")
                @Config.LangKey(value="xat.config.elf_ring")
                public TransformationRingConfig ELF_RING = new TransformationRingConfig();
                @Config.Name(value="Fairy Ring Settings")
                @Config.LangKey(value="xat.config.fairy_ring")
                public TransformationRingConfig FAIRY_RING = new TransformationRingConfig();
                @Config.Name(value="Goblin Ring Settings")
                @Config.LangKey(value="xat.config.goblin_ring")
                public TransformationRingConfig GOBLIN_RING = new TransformationRingConfig();
                @Config.Name(value="Titan Ring Settings")
                @Config.LangKey(value="xat.config.titan_ring")
                public TransformationRingConfig TITAN_RING = new TransformationRingConfig();
                @Config.Name(value="Faelis Ring Settings")
                @Config.LangKey(value="xat.config.faelis_ring")
                public TransformationRingConfig FAELIS_RING = new TransformationRingConfig();
                @Config.Name(value="Dragon Ring Settings")
                @Config.LangKey(value="xat.config.dragon_ring")
                public TransformationRingConfig DRAGON_RING = new TransformationRingConfig();
            }
        }

        public class Potions {
            private final String potion = "xat.config.potion";
            @Config.RequiresMcRestart
            @Config.Name(value="00. Potions Enabled")
            @Config.LangKey(value="xat.config.potion.registry.enabled")
            public boolean potions_enabled = true;
            @Config.Comment(value={"If Tough as Nails is Installed, Should the Potions Give water?"})
            @Config.Name(value="01. Potion Give Water")
            @Config.LangKey(value="xat.config.potion.toughasnails.water")
            public boolean potion_thirst = true;
            @Config.RequiresMcRestart
            @Config.Name(value="02. Restorative Potion Catalyst Item")
            @Config.LangKey(value="xat.config.potion.restore.catalyst")
            public String restoreCatalyst = "minecraft:nether_star";
            @Config.Name(value="Normie Potion")
            @Config.LangKey(value="xat.config.potion.human")
            public PotionConfig human = new PotionConfig("minecraft:apple", 3600);
            @Config.Name(value="Dwarf Potion")
            @Config.LangKey(value="xat.config.potion.dwarf")
            public PotionConfig dwarf = new PotionConfig("minecraft:iron_block", 1200);
            @Config.Name(value="Elf Potion")
            @Config.LangKey(value="xat.config.potion.elf")
            public PotionConfig elf = new PotionConfig("minecraft:leaves", 1200);
            @Config.Name(value="Fairy Potion")
            @Config.LangKey(value="xat.config.potion.fairy")
            public PotionConfig fairy = new PotionConfig("minecraft:ghast_tear", 1200);
            @Config.Name(value="Goblin Potion")
            @Config.LangKey(value="xat.config.potion.goblin")
            public PotionConfig goblin = new PotionConfig("minecraft:leather", 1200);
            @Config.Name(value="Titan Potion")
            @Config.LangKey(value="xat.config.potion.titan")
            public PotionConfig titan = new PotionConfig("minecraft:golden_apple", 1200);
            @Config.Name(value="Faelis Potion")
            @Config.LangKey(value="xat.config.potion.faelis")
            public PotionConfig faelis = new PotionConfig("xat:faelis_claw", 1200);
            @Config.Name(value="Dragon Potion")
            @Config.LangKey(value="xat.config.potion.dragon")
            public PotionConfig dragon = new PotionConfig("minecraft:dragon_breath", 1200);
            @Config.RequiresMcRestart
            @Config.Name(value="09. Work on players only")
            @Config.LangKey(value="xat.config.potion.playersonly")
            public boolean players_only = true;
        }

        public class Foods {
            @Config.RequiresMcRestart
            @Config.Comment(value={"Should this mod add Magical Foods?. Set to False to Disable. Default True"})
            @Config.Name(value="01. Foods Enabled")
            @Config.LangKey(value="xat.config.food.registry.enabled")
            public boolean foods_enabled = true;
            @Config.Comment(value={"Set to False to Disable. Default True"})
            @Config.Name(value="02. Foods Effects")
            @Config.LangKey(value="xat.config.food.transformation.effect")
            public boolean food_effects = true;
            @Config.Comment(value={"Should the player keep the Food Effects on Death. Set to False to Disable. Default True"})
            @Config.Name(value="03. Keep Effects")
            @Config.LangKey(value="xat.config.food.transformation.effect.keep")
            public boolean keep_effects = true;
        }

        public class GuiSettings {
            @Config.RequiresMcRestart
            @Config.Name(value="01. Trinkets Gui Enabled")
            @Config.LangKey(value="xat.config.server.gui.settings.enabled")
            public boolean guiEnabled = true;
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1, max=4)
            @Config.Name(value="02. Gui Slots Rows")
            public int guiSlotsRows = 1;
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0, max=8)
            @Config.Name(value="03. Gui Slots Row Length")
            public int guiSlotsRowLength = 8;
        }
    }

    public static class xClient {
        public DebugConfig debug = new DebugConfig();
        @Config.Name(value="Gui Settings")
        @Config.LangKey(value="xat.config.client.gui.settings")
        public TrinketsContainerConfig GUI = new TrinketsContainerConfig();
        @Config.Name(value="Mana Bar Settings")
        @Config.LangKey(value="xat.config.magic.mana.hud.settings")
        public ManaBar MPBar = new ManaBar();
        @Config.Name(value="Race Properties Gui")
        @Config.LangKey(value="xat.config.race.properties.gui.settings")
        public TrinketsPropertiesConfig raceProperties = new TrinketsPropertiesConfig();
        @Config.Comment(value={"POV Height adjustments when wearing Race Rings. Set to False to Disable. Default True"})
        @Config.Name(value="POV Height Adjustments")
        public boolean cameraHeight = true;
        @Config.Comment(value={"Rendering of Trinkets. Set to False to Disable. Default True"})
        @Config.Name(value="Render Trinkets")
        @Config.LangKey(value="xat.config.client.render.trinkets.all")
        public boolean rendering = true;
        @Config.Comment(value={"When using the Enchanted Race rings, should Trinkets and Baubles Replace the EntityRenderer to solve some of the camera clipping issues?"})
        @Config.Name(value="Replace EntityRenderer")
        @Config.LangKey(value="xat.config.client.entity.renderer.replace")
        public boolean entityRenderer = false;
        @Config.Comment(value={"When Trinket and Baubles Replaces the EntityRenderer is breaks some settings with Optifine, Specifically Fog, use this to turn Fog on or off"})
        @Config.Name(value="EntityRenderer Fog")
        @Config.LangKey(value="xat.config.client.entity.renderer.replace.fog")
        public boolean RendererFog = false;
        @Config.Name(value="Items")
        public TrinketItems items = new TrinketItems();

        public class TrinketItems {
            @Config.Name(value="Dragon's Eye Settings")
            @Config.LangKey(value="xat.config.dragons_eye")
            public Dragon DRAGON_EYE = new Dragon();
            @Config.Name(value="Fairy Ring Settings")
            @Config.LangKey(value="xat.config.fairy_ring")
            public Fairy FAIRY_RING = new Fairy();
            @Config.Name(value="Shield of Honor Settings")
            @Config.LangKey(value="xat.config.damage_shield")
            public Shield DAMAGE_SHIELD = new Shield();
            @Config.Name(value="Ender Queen's Crown Settings")
            @Config.LangKey(value="xat.config.ender_tiara")
            public Crown ENDER_CROWN = new Crown();
            @Config.Name(value="Stone of the Sea Settings")
            @Config.LangKey(value="xat.config.sea_stone")
            public Sea SEA_STONE = new Sea();
            @Config.Name(value="Faelis Claw Settings")
            @Config.LangKey(value="xat.config.faelis_claw")
            public Claw FAELIS_CLAW = new Claw();

            public class Claw {
                @Config.Name(value="Render Trinket on Player")
                @Config.LangKey(value="xat.config.client.render.trinket")
                public boolean doRender = true;
            }

            public class Sea {
                @Config.Name(value="Render Trinket on Player")
                @Config.LangKey(value="xat.config.client.render.trinket")
                public boolean doRender = true;
            }

            public class Crown {
                @Config.Name(value="Render Trinket on Player")
                @Config.LangKey(value="xat.config.client.render.trinket")
                public boolean doRender = true;
            }

            public class Shield {
                @Config.Name(value="Render Trinket on Player")
                @Config.LangKey(value="xat.config.client.render.trinket")
                public boolean doRender = true;
                public double effectVolume = 0.2;
            }

            public class Fairy {
                @Config.Name(value="Render Trinket on Player")
                @Config.LangKey(value="xat.config.client.render.trinket")
                public boolean doRender = true;
            }

            public class Dragon {
                @Config.Comment(value={"How Often the Dragon's Eye effect triggers in Ticks. try to avoid lower values. Default 79, 20 MIN, 360 MAX"})
                @Config.Name(value="Refresh Rate")
                @Config.RangeInt(min=20, max=360)
                @Config.LangKey(value="xat.config.dragons_eye.client.orefinder.refresh.rate")
                public int C00_RR = 79;
                @Config.Comment(value={"Should the Dragon's Eye play a Sound when Ore is Nearby? Set to False to Disable. Default True"})
                @Config.Name(value="Dragon's growl")
                @Config.LangKey(value="xat.config.dragons_eye.client.growl.enabled")
                public boolean Dragon_Growl = true;
                @Config.Comment(value={"Should the Dragon's Eye a Sound when Sneaking. Options 'SNEAK', 'STAND', 'BOTH'  Default SNEAK"})
                @Config.Name(value="Dragon's growl Sneak")
                @Config.LangKey(value="xat.config.dragons_eye.client.growl.activation")
                public String Dragon_Growl_Sneak = "SNEAK";
                @Config.Comment(value={"The Volume of the Dragon's growl when detecting nearby Treasure. Default 100, 0 MIN, 300 MAX"})
                @Config.Name(value="Dragon's growl Volume")
                @Config.RangeInt(min=0, max=300)
                @Config.LangKey(value="xat.config.dragons_eye.client.growl.volume")
                public int Dragon_Growl_Volume = 100;
            }
        }

        public class ManaBar {
            private final String name = "hud";
            private final String PREFIX = "xat.config.magic.manahud";
            @Config.Comment(value={"Mana Bar shown"})
            @Config.Name(value="01. Show Mana")
            @Config.LangKey(value="xat.config.magic.manahud.shown")
            public boolean shown = true;
            @Config.Comment(value={"Should the Mana Bar show even when full"})
            @Config.Name(value="02. Show when Full")
            @Config.LangKey(value="xat.config.magic.manahud.shown.always")
            public boolean always_shown = false;
            @Config.Comment(value={"Should the Mana Bar display horizontal or vertical?"})
            @Config.Name(value="03. Mana Bar Horizontal")
            @Config.LangKey(value="xat.config.magic.manahud.horizontal")
            public boolean mana_horizontal = true;
            @Config.Comment(value={"Show next to Mana Bar Text?"})
            @Config.Name(value="04. Hide Text")
            @Config.LangKey(value="xat.config.magic.manahud.text.shown")
            public boolean hide_text = false;
            @Config.Name(value="05. Location X")
            @Config.LangKey(value="xat.config.magic.manahud.location.x")
            public double translatedX = 0.0;
            @Config.Name(value="06. Location Y")
            @Config.LangKey(value="xat.config.magic.manahud.location.y")
            public double translatedY = 0.0;
            @Config.Name(value="09. Width")
            public int width = 106;
            @Config.Name(value="10. Height")
            public int height = 16;
        }

        public class DebugConfig {
            public boolean debugArmorMaterials = false;
        }
    }
}

