/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.handlers;

public class TickHandler {
    private String name;
    private int length;
    private int tick;
    private boolean countdown;

    public TickHandler(String name, int length) {
        this.name = name;
        this.tick = 0;
        this.length = length;
        this.countdown = false;
    }

    public TickHandler(String name, int length, boolean countdown) {
        this.name = name;
        this.tick = countdown ? length : 0;
        this.length = length;
        this.countdown = countdown;
    }

    public boolean Tick() {
        if (!this.countdown) {
            if (this.tick < this.length) {
                ++this.tick;
                return false;
            }
            this.resetTick();
            return true;
        }
        if (this.tick > 0) {
            --this.tick;
            return false;
        }
        this.resetTick();
        return true;
    }

    public int getTick() {
        return this.tick;
    }

    public TickHandler setTick(int tick) {
        if (this.tick != tick) {
            this.tick = tick;
        }
        return this;
    }

    public TickHandler setLength(int length) {
        if (this.length != length) {
            this.length = length;
        }
        return this;
    }

    public TickHandler setCountdown(boolean countdown) {
        if (this.countdown != countdown) {
            this.countdown = countdown;
        }
        return this;
    }

    public void resetTick() {
        this.tick = this.countdown ? this.length : 0;
    }
}

