/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.IntIdentityHashBiMap;
import xzeroair.trinkets.util.registry.TrinketRegistrySimple;

public class TrinketRegistry<K, V>
extends TrinketRegistrySimple<K, V> {
    protected final IntIdentityHashBiMap<V> underlyingIntegerMap = new IntIdentityHashBiMap(256);
    protected final Map<V, K> inverseObjectRegistry;
    protected final Map<UUID, V> uuidObjectRegistry = new HashMap<UUID, V>();

    public TrinketRegistry() {
        this.inverseObjectRegistry = ((BiMap)this.registryObjects).inverse();
    }

    public void register(int id, K key, UUID uuid, V value) {
        this.underlyingIntegerMap.func_186814_a(value, id);
        this.uuidObjectRegistry.put(uuid, value);
        this.putObject(key, value);
    }

    @Override
    protected Map<K, V> createUnderlyingMap() {
        return HashBiMap.create();
    }

    @Override
    @Nullable
    public V getObject(@Nullable K name) {
        return super.getObject(name);
    }

    @Nullable
    public K getNameForObject(V value) {
        return this.inverseObjectRegistry.get(value);
    }

    @Override
    public boolean containsKey(K key) {
        return super.containsKey(key);
    }

    public int getIDForObject(@Nullable V value) {
        return this.underlyingIntegerMap.func_186815_a(value);
    }

    @Nullable
    public V getObjectById(int id) {
        return (V)this.underlyingIntegerMap.func_186813_a(id);
    }

    @Nullable
    public V getObjectByUUID(UUID uuid) {
        return this.uuidObjectRegistry.get(uuid);
    }

    @Override
    public Iterator<V> iterator() {
        return this.underlyingIntegerMap.iterator();
    }
}

