/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.init;

import com.girafi.waddles.entity.EntityAdeliePenguin;
import com.girafi.waddles.utils.BiomeDictionaryHelper;
import com.girafi.waddles.utils.ConfigurationHandler;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class PenguinRegistry {
    private static List<EntityEntry> entities = Lists.newArrayList();
    private static Iterable<Biome> biomes = Lists.newArrayList();
    private static int minCount;
    private static int maxCount;
    private static int weight;
    public static final EntityEntry ADELIE_PENGUIN;

    private static EntityEntry createEntity(Class<? extends Entity> entityClass, int eggPrimary, int eggSecondary, int weight, int min, int max, BiomeDictionary.Type[] typesInclude, BiomeDictionary.Type[] typesExclude) {
        ArrayList spawnable_biomes = Lists.newArrayList();
        String subCategoryNames = "spawn chances." + PenguinRegistry.classToRegistryName(entityClass).func_110623_a() + "." + "Spawnable Biomes";
        String[] include = ConfigurationHandler.config.getStringList("Include", subCategoryNames, BiomeDictionaryHelper.toStringArray(typesInclude), "BiomeDictionary types to include");
        String[] exclude = ConfigurationHandler.config.getStringList("Exclude", subCategoryNames, BiomeDictionaryHelper.toStringArray(typesExclude), "BiomeDictionary types to exclude");
        ConfigurationHandler.config.save();
        PenguinRegistry.validateBiomeTypes(include);
        PenguinRegistry.validateBiomeTypes(exclude);
        List<BiomeDictionary.Type> includeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray(include));
        List<BiomeDictionary.Type> excludeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray(exclude));
        if (!includeList.isEmpty()) {
            for (BiomeDictionary.Type type : includeList) {
                for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)type)) {
                    if (biome.func_76747_a(EnumCreatureType.CREATURE).isEmpty()) continue;
                    spawnable_biomes.add(biome);
                }
            }
            if (!excludeList.isEmpty()) {
                for (BiomeDictionary.Type type : excludeList) {
                    Set excludeBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
                    for (Biome biome : excludeBiomes) {
                        spawnable_biomes.remove(biome);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Do not leave the BiomeDictionary type inclusion list empty. If you wish to disable spawning of an entity, set the weight to 0 instead.");
        }
        return PenguinRegistry.createEntity(entityClass, eggPrimary, eggSecondary, weight, min, max, spawnable_biomes);
    }

    private static EntityEntry createEntity(Class<? extends Entity> entityClass, int eggPrimary, int eggSecondary, int weight, int min, int max, Biome ... biomes) {
        return PenguinRegistry.createEntity(entityClass, eggPrimary, eggSecondary, weight, min, max, Arrays.asList(biomes));
    }

    private static EntityEntry createEntity(Class<? extends Entity> entityClass, int eggPrimary, int eggSecondary, int weight, int min, int max, Iterable<Biome> biomes) {
        ResourceLocation location = PenguinRegistry.classToRegistryName(entityClass);
        EntityEntry entry = new EntityEntry(entityClass, location.toString());
        entry.setRegistryName(location);
        entry.setEgg(new EntityList.EntityEggInfo(location, eggPrimary, eggSecondary));
        PenguinRegistry.biomes = biomes;
        entities.add(entry);
        String subCategoryNames = "spawn chances." + location.func_110623_a();
        PenguinRegistry.weight = ConfigurationHandler.config.get(subCategoryNames, "Weight", weight).getInt();
        minCount = ConfigurationHandler.config.get(subCategoryNames, "Min", min).getInt();
        maxCount = ConfigurationHandler.config.get(subCategoryNames, "Max", max).getInt();
        ConfigurationHandler.config.save();
        return entry;
    }

    private static ResourceLocation classToRegistryName(Class<? extends Entity> entityClass) {
        return new ResourceLocation("waddles", CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", ""));
    }

    private static void validateBiomeTypes(String[] biomes) {
        for (String biome : biomes) {
            if (BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(biome))) continue;
            throw new IllegalArgumentException("Waddles could not find BiomeDictionary type '" + biome + "' to include, please consult the config file");
        }
    }

    @SubscribeEvent
    public static void registerPenguins(RegistryEvent.Register<EntityEntry> event) {
        int networkId = 0;
        for (EntityEntry entry : entities) {
            Preconditions.checkNotNull((Object)entry.getRegistryName(), (Object)"registryName");
            event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(entry.getEntityClass()).id(entry.getRegistryName(), ++networkId).name(entry.getName()).tracker(64, 1, true).egg(entry.getEgg().field_75611_b, entry.getEgg().field_75612_c).spawn(EnumCreatureType.CREATURE, weight, minCount, maxCount, biomes).build());
        }
    }

    static {
        ADELIE_PENGUIN = PenguinRegistry.createEntity(EntityAdeliePenguin.class, 0, 0xFFFFFF, 2, 1, 4, new BiomeDictionary.Type[]{BiomeDictionary.Type.SNOWY}, new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.NETHER});
    }
}

