/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data.options;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionsData;
import xaero.common.category.ui.entry.CategorySettingsListEntry;
import xaero.common.category.ui.entry.CategorySettingsListEntryExpandingOptions;
import xaero.common.category.ui.entry.CategorySettingsListEntryWrapper;
import xaero.common.category.ui.entry.CategorySettingsListMainEntry;
import xaero.common.category.ui.entry.CategorySettingsListMainEntryFactory;
import xaero.common.category.ui.entry.ConnectionLineType;
import xaero.common.category.ui.entry.widget.CategorySettingsButton;
import xaero.common.graphics.CursorBox;
import xaero.common.misc.ListFactory;

public class GuiCategoryUIEditorExpandingOptionsData<V>
extends GuiCategoryUIEditorOptionsData<V> {
    protected final List<GuiCategoryUIEditorOptionData<V>> options;

    protected GuiCategoryUIEditorExpandingOptionsData(@Nonnull String displayName, @Nonnull GuiCategoryUIEditorOptionData<V> currentValue, @Nonnull List<GuiCategoryUIEditorOptionData<V>> options, boolean movable, @Nonnull CategorySettingsListMainEntryFactory listEntryFactory, BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorOptionData<V>>, Supplier<CursorBox>> tooltipSupplier, GuiCategoryUIEditorOptionsData.IOptionsDataIsActiveSupplier isActiveSupplier) {
        super(displayName, movable, listEntryFactory, tooltipSupplier, isActiveSupplier);
        this.options = options;
        this.currentValue = currentValue;
    }

    public boolean onSelected(GuiCategoryUIEditorOptionData<V> option) {
        this.setCurrentValue(option);
        this.setExpanded(false);
        return true;
    }

    @Override
    public List<GuiCategoryUIEditorOptionData<V>> getSubExpandables() {
        return this.options;
    }

    @Override
    public String getDisplayName() {
        return "";
    }

    public static class FinalBuilder<V>
    extends Builder<V, FinalBuilder<V>> {
        protected FinalBuilder(ListFactory listFactory) {
            super(listFactory);
        }

        public static <V> FinalBuilder<V> getDefault(ListFactory listFactory) {
            return (FinalBuilder)new FinalBuilder<V>(listFactory).setDefault();
        }

        @Override
        protected GuiCategoryUIEditorOptionsData<V> buildInternally(GuiCategoryUIEditorOptionData<V> currentValueData, List<GuiCategoryUIEditorOptionData<V>> options) {
            return new GuiCategoryUIEditorExpandingOptionsData<V>(this.displayName, currentValueData, options, this.movable, this.listEntryFactory, this.tooltipSupplier, this.isActiveSupplier);
        }
    }

    public static abstract class Builder<V, B extends Builder<V, B>>
    extends GuiCategoryUIEditorOptionsData.Builder<V, B> {
        protected final List<GuiCategoryUIEditorOptionData.Builder<V>> optionBuilders;
        protected final ListFactory listFactory;

        protected Builder(ListFactory listFactory) {
            this.optionBuilders = listFactory.get();
            this.listFactory = listFactory;
        }

        @Override
        public B setDefault() {
            super.setDefault();
            this.optionBuilders.clear();
            this.listEntryFactory = new CategorySettingsListMainEntryFactory(){

                @Override
                public CategorySettingsListMainEntry<?> get(final GuiCategoryUIEditorExpandableData<?> data, final GuiCategoryUIEditorExpandableData<?> parent, final int index, ConnectionLineType lineType, final GuiCategorySettings.SettingRowList rowList, int screenWidth, boolean isFinalExpanded) {
                    return new CategorySettingsListEntryWrapper(new CategorySettingsListMainEntry.CenteredEntryFactory(){

                        @Override
                        public CategorySettingsListEntry get(int x, int y, int width, int height, CategorySettingsListMainEntry<?> root) {
                            return new CategorySettingsListEntryExpandingOptions(x, y, width, height, index, rowList, root, new CategorySettingsButton(parent, new Supplier<String>(){

                                @Override
                                public String get() {
                                    return "";
                                }
                            }, ((GuiCategoryUIEditorExpandingOptionsData)data).getIsActiveSupplier().get(parent, (GuiCategoryUIEditorExpandingOptionsData)data), 216, 20, new CategorySettingsButton.PressAction(){

                                @Override
                                public void onPress(CategorySettingsButton b) {
                                    data.getExpandAction(rowList).run();
                                }
                            }, rowList), ((GuiCategoryUIEditorExpandingOptionsData)data).getMessageSupplier(), data.getTooltipSupplier(parent));
                        }
                    }, screenWidth, index, rowList, lineType, data);
                }
            };
            return (B)((Builder)this.self);
        }

        public B addOptionBuilderFor(V option) {
            this.optionBuilders.add(GuiCategoryUIEditorOptionData.Builder.getDefault().setValue(option));
            return (B)((Builder)this.self);
        }

        public B addOptionBuilder(GuiCategoryUIEditorOptionData.Builder<V> optionBuilder) {
            this.optionBuilders.add(optionBuilder);
            return (B)((Builder)this.self);
        }

        @Override
        public GuiCategoryUIEditorExpandingOptionsData<V> build() {
            if (this.listFactory == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return (GuiCategoryUIEditorExpandingOptionsData)super.build();
        }

        @Override
        protected GuiCategoryUIEditorOptionsData<V> buildInternally() {
            List options = (List)this.optionBuilders.stream().map(new Function<GuiCategoryUIEditorOptionData.Builder<V>, Object>(){

                @Override
                public Object apply(GuiCategoryUIEditorOptionData.Builder<V> b) {
                    return b.build();
                }
            }).collect(new Supplier<List<GuiCategoryUIEditorOptionData<V>>>(){

                @Override
                public List<GuiCategoryUIEditorOptionData<V>> get() {
                    return Builder.this.listFactory.get();
                }
            }, new BiConsumer<List<GuiCategoryUIEditorOptionData<V>>, Object>(){

                @Override
                public void accept(List<GuiCategoryUIEditorOptionData<V>> l, Object e) {
                    l.add((GuiCategoryUIEditorOptionData)e);
                }
            }, new BiConsumer<List<GuiCategoryUIEditorOptionData<V>>, List<GuiCategoryUIEditorOptionData<V>>>(){

                @Override
                public void accept(List<GuiCategoryUIEditorOptionData<V>> l1, List<GuiCategoryUIEditorOptionData<V>> l2) {
                    l1.addAll(l2);
                }
            });
            GuiCategoryUIEditorOptionData currentValueData = null;
            for (GuiCategoryUIEditorOptionData optionData : options) {
                if (optionData.getValue() != this.currentValue) continue;
                currentValueData = optionData;
                break;
            }
            if (currentValueData == null) {
                throw new IllegalStateException("current value is not one of the options! " + this.currentValue);
            }
            return this.buildInternally(currentValueData, options);
        }

        protected abstract GuiCategoryUIEditorOptionsData<V> buildInternally(GuiCategoryUIEditorOptionData<V> var1, List<GuiCategoryUIEditorOptionData<V>> var2);
    }
}

