/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import java.nio.ByteBuffer;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.MinimapTexture;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.MinimapRadarList;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.BufferCompatibilityFix;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class MinimapSafeModeRenderer
extends MinimapRenderer {
    private static final ResourceLocation mapTextures = new ResourceLocation("xaeromaptexture");
    private byte[] bytes;
    private byte drawYState;
    private final int[] tempColor = new int[3];
    private MinimapTexture mapTexture = new MinimapTexture(mapTextures);

    public MinimapSafeModeRenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface) {
        super(modMain, mc, waypointsGuiRenderer, minimapInterface);
    }

    public void updateMapFrameSafeMode(XaeroMinimapSession minimapSession, MinimapProcessor minimap, EntityPlayer player, Entity renderEntity, int bufferSize, int mapW, float partial, int level, boolean lockedNorth, int shape, double ps, double pc, boolean cave, ModSettings settings) {
        if (level < 0) {
            return;
        }
        EntityPlayer p = player;
        long before = System.currentTimeMillis();
        if (minimap.isToResetImage()) {
            this.bytes = new byte[bufferSize * bufferSize * 3];
            minimap.setToResetImage(false);
        }
        boolean motionBlur = Minecraft.func_175610_ah() >= 35;
        int increaseY = motionBlur ? 2 : 1;
        int mapH = mapW;
        int halfW = mapW / 2;
        int halfH = mapH / 2;
        double halfWZoomed = (double)halfW / this.zoom;
        double halfHZoomed = (double)halfH / this.zoom;
        int currentState = this.drawYState;
        double playerX = minimap.getEntityRadar().getEntityX(renderEntity, partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(renderEntity, partial);
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        for (int currentX = 0; currentX < mapW; ++currentX) {
            int currentY;
            double currentXZoomed = ((double)currentX + 0.5) / this.zoom;
            double offx = currentXZoomed - halfWZoomed;
            double psx = ps * offx;
            double pcx = pc * offx;
            int n = currentY = motionBlur ? currentState : 0;
            while (currentY < mapH) {
                double offy = ((double)currentY + 0.5) / this.zoom - halfHZoomed;
                this.getLoadedBlockColor(waypointsManager, minimap, this.tempColor, OptimizedMath.myFloor(playerX + psx + pc * offy), OptimizedMath.myFloor(playerZ + ps * offy - pcx), level);
                this.getHelper().putColor(this.bytes, currentX, bufferSize - 1 - currentY, this.tempColor[0], this.tempColor[1], this.tempColor[2], bufferSize);
                currentY += increaseY;
            }
            currentState = (byte)(currentState != 1 ? 1 : 0);
        }
        MinimapRadar minimapRadar = minimap.getEntityRadar();
        Iterator<MinimapRadarList> entityLists = minimapRadar.getRadarListsIterator();
        while (entityLists.hasNext()) {
            MinimapRadarList entityList = entityLists.next();
            EntityRadarCategory entityCategory = entityList.getCategory();
            int heightLimit = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_LIMIT).intValue();
            boolean heightBasedFade = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_FADE);
            int colorIndex = entityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue();
            int startFadingAt = entityCategory.getSettingValue(EntityRadarCategorySettings.START_FADING_AT).intValue();
            this.renderEntityListSafeMode(minimap, p, renderEntity, entityList.getEntities().iterator(), pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial, cave, entityCategory, heightLimit, heightBasedFade, startFadingAt, colorIndex);
        }
        if (this.modMain.getSettings().mainEntityAs == 1) {
            EntityRadarCategory mainEntityCategory = minimapRadar.getEntityCategoryManager().getRuleResolver().resolve(minimapRadar.getEntityCategoryManager().getRootCategory(), renderEntity, p);
            if (mainEntityCategory == null) {
                mainEntityCategory = minimapRadar.getEntityCategoryManager().getRootCategory();
            }
            this.renderEntityDotSafeMode(minimap, p, renderEntity, renderEntity, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial, cave, mainEntityCategory, 100, false, 100, mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue());
        }
        this.drawYState = (byte)(this.drawYState != 1 ? 1 : 0);
        ByteBuffer buffer = this.mapTexture.buffer;
        BufferCompatibilityFix.clear(buffer);
        buffer.put(this.bytes);
        BufferCompatibilityFix.flip(buffer);
    }

    public void renderEntityListSafeMode(MinimapProcessor minimap, EntityPlayer p, Entity renderEntity, Iterator<Entity> iter, double pc, double ps, int mapW, int bufferSize, int halfW, int halfH, double playerX, double playerZ, float partial, boolean cave, EntityRadarCategory category, int heightLimit, boolean heightBasedFade, int startFadingAt, int colorIndex) {
        while (iter.hasNext()) {
            Entity e = iter.next();
            if (renderEntity != e && this.renderEntityDotSafeMode(minimap, p, renderEntity, e, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial, cave, category, heightLimit, heightBasedFade, startFadingAt, colorIndex)) continue;
        }
    }

    public boolean renderEntityDotSafeMode(MinimapProcessor minimap, EntityPlayer p, Entity renderEntity, Entity e, double pc, double ps, int mapW, int bufferSize, int halfW, int halfH, double playerX, double playerZ, float partial, boolean cave, EntityRadarCategory category, int heightLimit, boolean heightBasedFade, int startFadingAt, int colorIndex) {
        if (!minimap.getEntityRadar().shouldRenderEntity(e, renderEntity)) {
            return false;
        }
        double offx = minimap.getEntityRadar().getEntityX(e, partial) - playerX;
        double offz = minimap.getEntityRadar().getEntityZ(e, partial) - playerZ;
        float offh = (float)(renderEntity.field_70163_u - e.field_70163_u);
        double Z = pc * offx + ps * offz;
        double X = ps * offx - pc * offz;
        double drawXDouble = (double)halfW + X * this.zoom;
        double drawYDouble = (double)halfH + Z * this.zoom;
        float drawLeft = (float)drawXDouble - 2.5f;
        float drawTop = (float)drawYDouble - 2.5f;
        int drawX = mapW - Math.round((float)mapW - drawLeft) + 2;
        int drawY = Math.round(drawTop) + 2;
        int color = minimap.getEntityRadar().getEntityColour(p, e, offh, false, category, heightLimit, startFadingAt, heightBasedFade, colorIndex);
        for (int a = drawX - 2; a < drawX + 4; ++a) {
            if (a < 0 || a > mapW) continue;
            for (int b = drawY - 2; b < drawY + 4; ++b) {
                if (b < 0 || b > mapW || (a == drawX - 2 || a == drawX + 3) && (b == drawY - 2 || b == drawY + 3) || a == drawX + 2 && b == drawY - 2 || a == drawX + 3 && b == drawY - 1 || a == drawX - 2 && b == drawY + 2 || a == drawX - 1 && b == drawY + 3) continue;
                if (a == drawX + 3 || b == drawY + 3 || a == drawX + 2 && b == drawY + 2) {
                    this.getHelper().putColor(this.bytes, a, bufferSize - 1 - b, 0, 0, 0, bufferSize);
                    continue;
                }
                this.getHelper().putColor(this.bytes, a, bufferSize - 1 - b, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, bufferSize);
            }
        }
        return true;
    }

    @Override
    protected void renderChunks(XaeroMinimapSession minimapSession, MinimapProcessor minimap, int mapSize, int bufferSize, float sizeFix, float partial, int lightLevel, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, ModSettings settings) {
        this.updateMapFrameSafeMode(minimapSession, minimap, (EntityPlayer)this.mc.field_71439_g, this.mc.func_175606_aa(), bufferSize, mapSize, partial, lightLevel, lockedNorth, shape, ps, pc, cave, settings);
        GL11.glScalef((float)sizeFix, (float)sizeFix, (float)1.0f);
        try {
            this.getHelper().bindTextureBuffer(this.mapTexture.buffer, bufferSize, bufferSize, this.mapTexture.func_110552_b());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(this.modMain.getSettings().minimapOpacity / 100.0)));
        }
        catch (Throwable e) {
            this.minimapInterface.setCrashedWith(e);
        }
    }

    private void getLoadedBlockColor(WaypointsManager waypointsManager, MinimapProcessor minimap, int[] result, int par1, int par2, int level) {
        int tileX = par1 >> 4;
        int tileZ = par2 >> 4;
        int chunkX = (tileX >> 2) - minimap.getMinimapWriter().getLoadedMapChunkX();
        int chunkZ = (tileZ >> 2) - minimap.getMinimapWriter().getLoadedMapChunkZ();
        if (minimap.getMinimapWriter().getLoadedBlocks() == null || chunkX < 0 || chunkX >= minimap.getMinimapWriter().getLoadedBlocks().length || chunkZ < 0 || chunkZ >= minimap.getMinimapWriter().getLoadedBlocks().length) {
            result[2] = 1;
            result[1] = 1;
            result[0] = 1;
            return;
        }
        try {
            MinimapTile tile;
            MinimapChunk current = minimap.getMinimapWriter().getLoadedBlocks()[chunkX][chunkZ];
            if (current != null && (tile = current.getTile(tileX & 3, tileZ & 3)) != null) {
                int insideX = par1 & 0xF;
                int insideZ = par2 & 0xF;
                this.chunkOverlay(waypointsManager, result, tile.getRed(level, insideX, insideZ), tile.getGreen(level, insideX, insideZ), tile.getBlue(level, insideX, insideZ), tile);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        result[2] = 1;
        result[1] = 1;
        result[0] = 1;
    }

    private void chunkOverlay(WaypointsManager waypointsManager, int[] result, int red, int green, int blue, MinimapTile c) {
        if (this.modMain.getSettings().getSlimeChunks(waypointsManager) && c.isSlimeChunk()) {
            this.getHelper().slimeOverlay(result, red, green, blue);
        } else if (this.modMain.getSettings().chunkGrid > -1 && c.isChunkGrid()) {
            this.getHelper().gridOverlay(result, ModSettings.COLORS[this.modMain.getSettings().chunkGrid], red, green, blue);
        } else {
            result[0] = red;
            result[1] = green;
            result[2] = blue;
        }
    }
}

