/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIcon;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;

public class EntityIconManager {
    public static final EntityIcon FAILED = new EntityIcon(null, 0, 0);
    public static final EntityIcon DOT = new EntityIcon(null, 0, 0);
    private EntityIconPrerenderer prerenderer;
    private final IXaeroMinimap modMain;
    private Map<ResourceLocation, EntityIconDefinition> iconDefinitions;
    private Map<String, EntityIcon> cachedTextures;
    private boolean canPrerender;
    private Gson gson;
    private StringBuilder entityStringBuilder;
    private EntityIconModelConfig defaultModelConfig;

    public EntityIconManager(IXaeroMinimap modMain, EntityIconPrerenderer prerenderer) {
        this.modMain = modMain;
        this.prerenderer = prerenderer;
        this.iconDefinitions = new HashMap<ResourceLocation, EntityIconDefinition>();
        this.cachedTextures = new HashMap<String, EntityIcon>();
        this.gson = new Gson();
        this.resetResources();
        this.entityStringBuilder = new StringBuilder();
        this.defaultModelConfig = new EntityIconModelConfig();
    }

    public <T extends Entity> EntityIcon getEntityHeadTexture(T entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean debug, boolean debugEntityVariantIds) {
        String cacheKey;
        EntityIcon cachedValue;
        EntityLivingBase livingEntity;
        ItemStack headItemStack;
        ResourceLocation entityId = EntityList.func_191301_a(entity);
        EntityIconDefinition iconDefinition = this.iconDefinitions.get(entityId);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        Render entityRenderer = renderManager.func_78713_a(entity);
        StringBuilder entityStringBuilder = this.entityStringBuilder;
        entityStringBuilder.setLength(0);
        boolean variantIdAppended = false;
        if (iconDefinition != null) {
            Method variantIdBuilderMethod = iconDefinition.getVariantIdBuilderMethod();
            if (variantIdBuilderMethod != null) {
                try {
                    variantIdBuilderMethod.invoke(null, entityStringBuilder, entityRenderer, entity);
                    variantIdAppended = true;
                }
                catch (Exception e) {
                    MinimapLogs.LOGGER.error("Exception while using the variant builder ID method " + iconDefinition.getVariantIdBuilderMethodString() + " defined for " + entityId, (Throwable)e);
                    iconDefinition.setVariantIdBuilderMethod(null);
                }
            } else {
                Method variantOldIdMethod = iconDefinition.getOldVariantIdMethod();
                if (variantOldIdMethod != null) {
                    try {
                        String entityVariantString = (String)variantOldIdMethod.invoke(null, entityRenderer, entity);
                        entityStringBuilder.append(entityVariantString);
                        variantIdAppended = true;
                    }
                    catch (Exception e) {
                        MinimapLogs.LOGGER.error("Exception while using the variant ID method " + iconDefinition.getOldVariantIdMethodString() + " defined for " + entityId, (Throwable)e);
                        iconDefinition.setOldVariantIdMethod(null);
                    }
                }
            }
        }
        if (!variantIdAppended) {
            EntityIconDefinitions.buildVariantIdString(entityStringBuilder, entityRenderer, entity);
        }
        String entityVariantString = entityStringBuilder.toString();
        entityStringBuilder.append("%").append(entityId);
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer) && (headItemStack = (livingEntity = (EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.HEAD)) != null && headItemStack != ItemStack.field_190927_a) {
            entityStringBuilder.append("%").append(headItemStack.func_77973_b().getRegistryName());
        }
        if ((cachedValue = this.cachedTextures.get(cacheKey = entityStringBuilder.toString())) == null) {
            ResourceLocation iconType;
            if (debugEntityVariantIds) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(entityVariantString));
            }
            String variantMapKey = entityVariantString;
            if (iconDefinition != null) {
                iconType = iconDefinition.getVariantType(variantMapKey);
                if (iconType == null) {
                    variantMapKey = "default";
                    iconType = iconDefinition.getVariantType(variantMapKey);
                }
            } else {
                iconType = EntityIconDefinition.MODEL_TYPE;
            }
            if (iconType == EntityIconDefinition.MODEL_TYPE) {
                if (this.canPrerender) {
                    EntityIconModelConfig variantModelConfig;
                    EntityIconModelConfig modelConfig = this.defaultModelConfig;
                    EntityIconModelConfig entityIconModelConfig = variantModelConfig = iconDefinition == null ? null : iconDefinition.getModelConfig(variantMapKey);
                    if (variantModelConfig != null) {
                        modelConfig = variantModelConfig;
                    }
                    cachedValue = this.prerenderer.prerender(cacheKey, entityRenderer, entity, defaultFramebuffer, helper, scale, modelConfig, null, true, false, debug);
                    this.cachedTextures.put(cacheKey, cachedValue);
                    this.canPrerender = false;
                } else {
                    cachedValue = null;
                }
            } else if (iconType == EntityIconDefinition.DOT_TYPE) {
                cachedValue = DOT;
                this.cachedTextures.put(cacheKey, cachedValue);
            } else if (this.canPrerender) {
                ResourceLocation sprite = iconDefinition.getSprite(variantMapKey);
                boolean isOutlined = iconType == EntityIconDefinition.OUTLINED_SPRITE;
                boolean isFlipped = !isOutlined && iconType != EntityIconDefinition.NORMAL_SPRITE;
                cachedValue = this.prerenderer.prerender(cacheKey, entityRenderer, entity, defaultFramebuffer, helper, scale, null, sprite, isOutlined, isFlipped, debug);
                this.cachedTextures.put(cacheKey, cachedValue);
                this.canPrerender = false;
            } else {
                cachedValue = null;
            }
        }
        return cachedValue;
    }

    public void reset() {
        this.prerenderer.clearAtlases();
        this.cachedTextures.clear();
        MinimapLogs.LOGGER.info("Entity icon manager reset!");
    }

    public void resetResources() {
        MinimapLogs.LOGGER.info("Reloading entity icon resources...");
        Set entityIds = ForgeRegistries.ENTITIES.getKeys();
        Gson gson = this.gson;
        int attempts = 5;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.resetResourcesAttempt(gson, entityIds);
                break;
            }
            catch (IOException ioe) {
                if (i != attempts - 1) continue;
                throw new RuntimeException(ioe);
            }
        }
        MinimapLogs.LOGGER.info("Done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetResourcesAttempt(Gson gson, Set<ResourceLocation> entityIds) throws IOException {
        this.iconDefinitions.clear();
        for (ResourceLocation id : entityIds) {
            InputStream resourceInput = null;
            BufferedReader reader = null;
            String entityDefinitionJson = null;
            IResource resource = null;
            try {
                resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("xaerominimap", "entity/icon/definition/" + id.func_110624_b() + "/" + id.func_110623_a() + ".json"));
            }
            catch (FileNotFoundException fnfe) {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                if (resource == null) continue;
                resourceInput = resource.func_110527_b();
                reader = new BufferedReader(new InputStreamReader(resourceInput));
                final StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String line) {
                        stringBuilder.append(line);
                        stringBuilder.append('\n');
                    }
                });
                entityDefinitionJson = stringBuilder.toString();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                EntityIconDefinition entityIconDefinition = (EntityIconDefinition)gson.fromJson(entityDefinitionJson, EntityIconDefinition.class);
                entityIconDefinition.onConstruct(id);
                this.iconDefinitions.put(id, entityIconDefinition);
            }
            catch (JsonSyntaxException jse) {
                MinimapLogs.LOGGER.error("Json syntax exception when loading the entity icon definition for " + id + ".", (Throwable)jse);
            }
        }
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }

    public void onModelPartRenderDetection(ModelRenderer modelRenderer) {
        this.prerenderer.onModelPartRenderDetection(modelRenderer);
    }
}

