/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointDeleter;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.settings.ModSettings;

public class WaypointsGuiRenderer {
    private IXaeroMinimap modMain;
    private Minecraft mc;
    private List<Waypoint> sortingList;
    private WaypointFilterParams filterParams;
    private Predicate<Waypoint> filter;
    private final WaypointDeleter waypointReachDeleter;

    public WaypointsGuiRenderer(IXaeroMinimap modMain, WaypointDeleter waypointReachDeleter, Minecraft mc) {
        this.modMain = modMain;
        this.mc = mc;
        this.sortingList = new ArrayList<Waypoint>();
        this.filterParams = new WaypointFilterParams();
        this.filter = new Predicate<Waypoint>(){

            @Override
            public boolean test(Waypoint w) {
                WaypointFilterParams filterParams = WaypointsGuiRenderer.this.filterParams;
                boolean deathpoints = filterParams.deathpoints;
                if (w.isDisabled() || (w.getWaypointType() == 1 || w.getWaypointType() == 2) && !deathpoints) {
                    return false;
                }
                double offx = (double)w.getX(filterParams.dimDiv) + 0.5 - filterParams.cameraX;
                double offz = (double)w.getZ(filterParams.dimDiv) + 0.5 - filterParams.cameraZ;
                double distance = Math.sqrt(offx * offx + offz * offz);
                double waypointsDistance = filterParams.waypointsDistance;
                return w.isOneoffDestination() || w.getWaypointType() == 1 || w.isGlobal() || waypointsDistance == 0.0 || !(distance > waypointsDistance);
            }
        };
        this.waypointReachDeleter = waypointReachDeleter;
    }

    public void render(XaeroMinimapSession minimapSession, MinimapRendererHelper rendererHelper, double playerX, double playerY, double playerZ, int specW, int specH, double ps, double pc, float partial, double zoom, boolean circle, float minimapScale, boolean safeMode) {
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
        GlStateManager.func_179097_i();
        GlStateManager.func_179141_d();
        Waypoint.RENDER_SORTING_POS = ActiveRenderInfo.getCameraPosition().func_72441_c(playerX, playerY, playerZ);
        if (this.modMain.getSettings().compassOverWaypoints) {
            this.drawWaypoints(rendererHelper, waypointsManager, playerX, playerY, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle, minimapScale);
            if (this.modMain.getSettings().compassLocation == 2 || safeMode) {
                this.drawCompass(rendererHelper, specW, specH, ps, pc, zoom, circle, minimapScale, false);
            }
        } else {
            if (this.modMain.getSettings().compassLocation == 2 || safeMode) {
                this.drawCompass(rendererHelper, specW, specH, ps, pc, zoom, circle, minimapScale, false);
            }
            this.drawWaypoints(rendererHelper, waypointsManager, playerX, playerY, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle, minimapScale);
        }
    }

    private void drawWaypoints(MinimapRendererHelper rendererHelper, WaypointsManager waypointsManager, double playerX, double playerY, double playerZ, int specW, int specH, double ps, double pc, float partial, double dimDiv, double zoom, boolean circle, float minimapScale) {
        if (this.mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) || this.mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_BENEFICIAL) || this.mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL)) {
            return;
        }
        List<Waypoint> sortingList = this.sortingList;
        sortingList.clear();
        if (this.modMain.getSettings().getShowWaypoints() && waypointsManager.getWaypoints() != null) {
            if (this.modMain.getSettings().renderAllSets) {
                HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    sortingList.addAll(setEntry.getValue().getList());
                }
            } else {
                sortingList.addAll(waypointsManager.getWaypoints().getList());
            }
        }
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = WaypointsManager.customWaypoints;
        if (this.modMain.getSettings().getShowWaypoints() && !customWaypoints.isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                sortingList.addAll(modCustomWaypoints.values());
            }
        }
        boolean deleteReachedDeathpoints = this.modMain.getSettings().deleteReachedDeathpoints;
        if (!sortingList.isEmpty()) {
            this.waypointReachDeleter.begin();
            this.filterParams.setParams(playerX, 0.0, playerZ, 0.0, 0.0, 0.0, null, dimDiv, this.modMain.getSettings().getDeathpoints(), this.modMain.getSettings().getMaxWaypointsDistance(), this.modMain.getSettings().waypointsDistanceMin, 0.0);
            Iterator<Waypoint> iterator = sortingList.stream().filter(this.filter).sorted().iterator();
            this.renderWaypointsIterator(iterator, playerX, playerY, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle, minimapScale, deleteReachedDeathpoints);
            this.waypointReachDeleter.deleteCollected(waypointsManager.getCurrentWorld(), this.modMain.getSettings().renderAllSets);
        }
    }

    private void renderWaypointsIterator(Iterator<Waypoint> iter, double playerX, double playerY, double playerZ, int specW, int specH, double ps, double pc, double dimDiv, double zoom, boolean circle, float minimapScale, boolean deleteReachedDeathpoints) {
        while (iter.hasNext()) {
            Waypoint w = iter.next();
            int wX = w.getX(dimDiv);
            int wZ = w.getZ(dimDiv);
            double offx = (double)wX + 0.5 - playerX;
            double offz = (double)wZ + 0.5 - playerZ;
            if (deleteReachedDeathpoints && w.isOneoffDestination() && System.currentTimeMillis() - w.getCreatedAt() > 5000L) {
                double correctOffZ;
                double correctDistance;
                double correctOffX = playerX - (double)wX - 0.5;
                double correctOffY = playerY - (double)w.getY();
                if (!w.isYIncluded()) {
                    correctOffY = 0.0;
                }
                if ((correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + (correctOffZ = playerZ - (double)wZ - 0.5) * correctOffZ)) < 4.0) {
                    this.waypointReachDeleter.add(w);
                }
            }
            this.translatePosition(specW, specH, ps, pc, offx, offz, zoom, circle);
            GlStateManager.func_179152_a((float)minimapScale, (float)minimapScale, (float)1.0f);
            this.drawIconOnGUI(w, this.modMain.getSettings(), 0, 0);
            GlStateManager.func_179121_F();
        }
    }

    public void drawCompass(MinimapRendererHelper rendererHelper, int specW, int specH, double ps, double pc, double zoom, boolean circle, float minimapScale, boolean background) {
        if (this.modMain.getSettings().compassLocation == 0) {
            return;
        }
        String[] nesw = new String[]{I18n.func_135052_a((String)"gui.xaero_compass_north", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_east", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_south", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_west", (Object[])new Object[0])};
        int defaultColor = ModSettings.COLORS[this.modMain.getSettings().compassColor];
        for (int i = 0; i < 4; ++i) {
            int effectiveColor;
            double offx;
            double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
            double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
            this.translatePosition(specW, specH, ps, pc, offx, offy, zoom, circle);
            GlStateManager.func_179152_a((float)minimapScale, (float)minimapScale, (float)1.0f);
            GlStateManager.func_179097_i();
            int halfW = this.mc.field_71466_p.func_78256_a(nesw[i]) / 2 - 1;
            int n = effectiveColor = i == 0 ? ModSettings.COLORS[this.modMain.getSettings().getNorthCompassColor()] : defaultColor;
            if (background) {
                GlStateManager.func_179090_x();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                int addedFrame = halfW > 3 ? halfW - 3 : 0;
                rendererHelper.drawMyColoredRect(-4 - addedFrame, -4 - addedFrame, 5 + addedFrame, 5 + addedFrame, 0x90000000 | effectiveColor & 0xFFFFFF);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179098_w();
            }
            Minecraft.func_71410_x().field_71466_p.func_78276_b(nesw[i], -halfW + 1, -2, effectiveColor);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(nesw[i], -halfW, -3, -1);
            GlStateManager.func_179121_F();
        }
    }

    public void translatePosition(int specW, int specH, double ps, double pc, double offx, double offy, double zoom, boolean circle) {
        double X;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (!circle) {
            if (borderedX > (double)specW) {
                borderedX = specW;
                borderedY = Y * (double)specW / X;
            } else if (borderedX < (double)(-specW)) {
                borderedX = -specW;
                borderedY = -Y * (double)specW / X;
            }
            if (borderedY > (double)specH) {
                borderedY = specH;
                borderedX = X * (double)specH / Y;
            } else if (borderedY < (double)(-specH)) {
                borderedY = -specH;
                borderedX = -X * (double)specH / Y;
            }
        } else {
            double distSquared = borderedX * borderedX + borderedY * borderedY;
            double maxDistSquared = specW * specW;
            if (distSquared > maxDistSquared) {
                double scaleDown = Math.sqrt(maxDistSquared / distSquared);
                borderedX *= scaleDown;
                borderedY *= scaleDown;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(Math.round(borderedX) - 1L), (float)(Math.round(borderedY) - 1L), (float)0.0f);
    }

    public void drawIconOnGUI(Waypoint w, ModSettings settings, int drawX, int drawY) {
        int c = ModSettings.COLORS[w.getColor()];
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c & 0xFF;
        int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
        c = a << 24 | r << 16 | g << 8 | b;
        int j = w.getWaypointType() == 1 ? 4 : Minecraft.func_71410_x().field_71466_p.func_78256_a(w.getSymbol()) / 2;
        int addedFrame = j > 4 ? j - 4 : 0;
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4 - addedFrame;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5 + addedFrame;
        Gui.func_73734_a((int)rectX1, (int)rectY1, (int)rectX2, (int)rectY2, (int)c);
        if (w.getWaypointType() != 1) {
            GlStateManager.func_179097_i();
            Minecraft.func_71410_x().field_71466_p.func_175063_a(w.getSymbol(), (float)(drawX + 1 - j), (float)(drawY - 3), -1);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            GlStateManager.func_179131_c((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(rectX1 + 1, rectY1 + 1, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(rectX1, rectY1, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawSetChange(WaypointsManager waypointsManager, ScaledResolution res) {
        if (waypointsManager.getWaypoints() != null && waypointsManager.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - waypointsManager.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                int c = 0xFFFFFF | alpha << 24;
                GlStateManager.func_179097_i();
                Minecraft.func_71410_x().field_71456_v.func_73732_a(Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)waypointsManager.getWaypoints().getName(), (Object[])new Object[0]), res.func_78326_a() / 2, res.func_78328_b() / 2 + 50, c);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
            } else {
                waypointsManager.setChanged = 0L;
            }
        }
    }
}

