/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector4f;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiMisc;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointDeleter;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    public static final float DEFAULT_SCALE = 0.8f;
    public static final float MINECRAFT_SCALE = 0.02666667f;
    private IXaeroMinimap modMain;
    private Vector4f origin4f;
    private List<Waypoint> sortingList;
    private WaypointFilterParams filterParams;
    private Predicate<Waypoint> filter;
    private Waypoint previousClosest;
    private Waypoint workingClosest;
    private double workingClosestCos;
    private ClippingHelper clippingHelper;
    private final WaypointDeleter waypointReachDeleter;

    public WaypointsIngameRenderer(IXaeroMinimap modMain, WaypointDeleter waypointReachDeleter, Minecraft mc) {
        this.modMain = modMain;
        this.sortingList = new ArrayList<Waypoint>();
        this.filterParams = new WaypointFilterParams();
        this.filter = new Predicate<Waypoint>(){

            @Override
            public boolean test(Waypoint w) {
                double wpRenderZ;
                double offZ;
                double offY;
                double offX;
                double depth;
                WaypointFilterParams filterParams = WaypointsIngameRenderer.this.filterParams;
                boolean deathpoints = filterParams.deathpoints;
                if (w.isDisabled() || (w.getWaypointType() == 1 || w.getWaypointType() == 2) && !deathpoints) {
                    return false;
                }
                double wpRenderX = (double)w.getX(filterParams.dimDiv) + 0.5 - filterParams.actualEntityX;
                double wpRenderY = (double)w.getY() + 1.0 - filterParams.actualEntityY;
                if (!w.isYIncluded()) {
                    wpRenderY = (float)(filterParams.playerY - filterParams.actualEntityY) + 1.0f;
                }
                if ((depth = (offX = wpRenderX - filterParams.cameraX) * filterParams.lookVector.field_72450_a + (offY = wpRenderY - filterParams.cameraY) * filterParams.lookVector.field_72448_b + (offZ = (wpRenderZ = (double)w.getZ(filterParams.dimDiv) + 0.5 - filterParams.actualEntityZ) - filterParams.cameraZ) * filterParams.lookVector.field_72449_c) < 0.1) {
                    return false;
                }
                double distance2D = Math.sqrt(offX * offX + offZ * offZ);
                double waypointsDistance = filterParams.waypointsDistance;
                double waypointsDistanceMin = filterParams.waypointsDistanceMin;
                return w.isOneoffDestination() || !(w.getWaypointType() != 1 && !w.isGlobal() && waypointsDistance != 0.0 && distance2D > waypointsDistance) && (waypointsDistanceMin == 0.0 || !(distance2D < waypointsDistanceMin));
            }
        };
        this.origin4f = new Vector4f();
        this.waypointReachDeleter = waypointReachDeleter;
    }

    public void render(XaeroMinimapSession minimapSession, float partial, MinimapProcessor minimap) {
        if (this.modMain.getSettings().getShowIngameWaypoints()) {
            Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_BENEFICIAL) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL)) {
                return;
            }
            FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
            if (fontrenderer == null) {
                return;
            }
            if (this.clippingHelper == null) {
                this.clippingHelper = ClippingHelperImpl.func_78558_a();
            }
            float[] waypointsProjection = this.clippingHelper.field_178625_b;
            float[] worldModelView = this.clippingHelper.field_178626_c;
            WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
            String subworldName = null;
            if (waypointsManager.getCurrentWorld() != null && waypointsManager.getAutoWorld() != waypointsManager.getCurrentWorld()) {
                subworldName = "(" + waypointsManager.getCurrentWorld().getContainer().getSubName() + ")";
            }
            Entity entity = mc.func_175606_aa();
            double actualEntityX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partial;
            double actualEntityY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partial;
            double actualEntityZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partial;
            double smoothEntityY = minimap.getEntityRadar().getEntityY(entity, partial);
            Vec3d cameraPos = ActiveRenderInfo.getCameraPosition();
            Waypoint.RENDER_SORTING_POS = cameraPos.func_72441_c(actualEntityX, actualEntityY, actualEntityZ);
            double d3 = cameraPos.field_72450_a;
            double d4 = cameraPos.field_72448_b;
            double d5 = cameraPos.field_72449_c;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            double fov = mc.field_71474_y.field_74334_X;
            int screenWidth = mc.field_71443_c;
            int screenHeight = mc.field_71440_d;
            float yaw = (float)Math.toDegrees(Misc.getYawRadians());
            float pitch = (float)Math.toDegrees(Misc.getPitchRadians());
            float cameraAngleYaw = yaw;
            float cameraAnglePitch = pitch;
            Vec3d lookVector = Misc.getLookVec();
            double uiScale = new ScaledResolution(mc).func_78325_e();
            double clampDepth = this.modMain.getSettings().getWaypointsClampDepth(fov, screenHeight, uiScale);
            double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
            List<Waypoint> sortingList = this.sortingList;
            sortingList.clear();
            if (waypointsManager.getWaypoints() != null) {
                if (this.modMain.getSettings().renderAllSets) {
                    HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                    for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                        sortingList.addAll(setEntry.getValue().getList());
                    }
                } else {
                    sortingList.addAll(waypointsManager.getWaypoints().getList());
                }
            }
            if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
                for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                    sortingList.addAll(modCustomWaypoints.values());
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2980.0f);
            if (!sortingList.isEmpty()) {
                this.waypointReachDeleter.begin();
                this.filterParams.setParams(d3, d4, d5, actualEntityX, actualEntityY, actualEntityZ, lookVector, dimDiv, this.modMain.getSettings().getDeathpoints(), this.modMain.getSettings().getMaxWaypointsDistance(), this.modMain.getSettings().waypointsDistanceMin, smoothEntityY);
                Stream<Waypoint> waypointStream = sortingList.stream().filter(this.filter).sorted();
                double minDistance = this.modMain.getSettings().waypointsDistanceMin;
                this.renderWaypointsIterator(worldModelView, waypointStream.iterator(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth, fontrenderer, waypointsProjection, screenWidth, false, uiScale, minDistance, subworldName);
                this.waypointReachDeleter.deleteCollected(waypointsManager.getCurrentWorld(), this.modMain.getSettings().renderAllSets);
            }
            GlStateManager.func_179121_F();
            RenderHelper.func_74520_c();
            RenderHelper.func_74518_a();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179089_o();
        }
    }

    private void renderWaypointsIterator(float[] worldModelView, Iterator<Waypoint> iter, double d3, double d4, double d5, Entity entity, BufferBuilder bufferbuilder, Tessellator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, double smoothEntityY, double fov, int screenHeight, float cameraAngleYaw, float cameraAnglePitch, Vec3d lookVector, double clampDepth, FontRenderer fontrenderer, float[] waypointsProjection, int screenWidth, boolean detailedDisplayAllowed, double uiScale, double minDistance, String subworldName) {
        boolean onlyMainInfo;
        int count = 0;
        this.workingClosest = null;
        int displayMultipleWaypointInfo = this.modMain.getSettings().displayMultipleWaypointInfo;
        boolean deleteReachedDeathpoints = this.modMain.getSettings().deleteReachedDeathpoints;
        boolean bl = onlyMainInfo = displayMultipleWaypointInfo == 0 || displayMultipleWaypointInfo == 1 && !entity.func_70093_af();
        while (iter.hasNext()) {
            Waypoint w = iter.next();
            this.renderWaypointIngame(worldModelView, cameraAngleYaw, cameraAnglePitch, lookVector, w, this.modMain, clampDepth, d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, fontrenderer, waypointsProjection, screenWidth, screenHeight, false, onlyMainInfo, uiScale, minDistance, deleteReachedDeathpoints, subworldName);
            if (++count >= 19500) continue;
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.1f);
        }
        if (onlyMainInfo && this.previousClosest != null) {
            this.renderWaypointIngame(worldModelView, cameraAngleYaw, cameraAnglePitch, lookVector, this.previousClosest, this.modMain, clampDepth, d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, fontrenderer, waypointsProjection, screenWidth, screenHeight, true, onlyMainInfo, uiScale, minDistance, false, subworldName);
        }
        this.previousClosest = this.workingClosest;
        GlStateManager.func_179086_m((int)256);
    }

    private void renderWaypointIngame(float[] worldModelView, float cameraAngleYaw, float cameraAnglePitch, Vec3d lookVector, Waypoint w, IXaeroMinimap modMain, double depthClamp, double d3, double d4, double d5, Entity entity, BufferBuilder bufferBuilder, Tessellator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, double smoothEntityY, FontRenderer fontrenderer, float[] waypointsProjection, int screenWidth, int screenHeight, boolean isTheMain, boolean onlyMainInfo, double uiScale, double minDistance, boolean deleteReachedDeathpoints, String subworldName) {
        int wX = w.getX(dimDiv);
        int wZ = w.getZ(dimDiv);
        double wpRenderX = (double)wX + 0.5 - actualEntityX;
        double wpRenderY = (double)w.getY() + 1.0 - actualEntityY;
        if (!w.isYIncluded()) {
            wpRenderY = (float)(smoothEntityY - actualEntityY) + 1.0f;
        }
        double wpRenderZ = (double)wZ + 0.5 - actualEntityZ;
        double offX = wpRenderX - d3;
        double offY = wpRenderY - d4;
        double offZ = wpRenderZ - d5;
        double depth = offX * lookVector.field_72450_a + offY * lookVector.field_72448_b + offZ * lookVector.field_72449_c;
        double correctOffX = wpRenderX;
        double correctOffY = actualEntityY - (double)w.getY();
        if (!w.isYIncluded()) {
            correctOffY = 0.0;
        }
        double correctOffZ = wpRenderZ;
        double correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + correctOffZ * correctOffZ);
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        if (deleteReachedDeathpoints && w.isOneoffDestination() && System.currentTimeMillis() - w.getCreatedAt() > 5000L && correctDistance < 4.0) {
            this.waypointReachDeleter.add(w);
        }
        if (minDistance != 0.0 && distance2D < minDistance) {
            return;
        }
        double originalOffY = offY;
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        String distanceText = "";
        boolean couldShowDistance = false;
        boolean showDistance = false;
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            if (modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0 ? 0.001 : offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / (double)Z));
                if (offZ < 0.0) {
                    angle = offX < 0.0 ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = couldShowDistance = Math.abs(offset = MathHelper.func_76142_g((float)(angle - cameraAngleYaw))) < (float)modMain.getSettings().lookingAtAngle;
                if (modMain.getSettings().lookingAtAngleVertical != 180) {
                    float verticalAngle = (float)Math.toDegrees(Math.atan(-originalOffY / (distance2D == 0.0 ? 1.0E-5 : distance2D)));
                    couldShowDistance = couldShowDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (modMain.getSettings().distance == 2) {
                couldShowDistance = true;
            }
            if (couldShowDistance) {
                if (!isTheMain) {
                    double cos = depth / distance;
                    if (this.workingClosest == null || cos > this.workingClosestCos) {
                        this.workingClosest = w;
                        this.workingClosestCos = cos;
                    }
                    if (!onlyMainInfo) {
                        showDistance = true;
                    }
                } else {
                    showDistance = true;
                }
            }
            if (showDistance) {
                int autoConvertWaypointDistanceToKmThreshold = modMain.getSettings().autoConvertWaypointDistanceToKmThreshold;
                distanceText = autoConvertWaypointDistanceToKmThreshold != -1 && correctDistance >= (double)autoConvertWaypointDistanceToKmThreshold ? GuiMisc.getFormat(modMain.getSettings().waypointDistancePrecision).format(correctDistance / 1000.0) + "km" : GuiMisc.getFormat(modMain.getSettings().waypointDistancePrecision).format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        if (onlyMainInfo && this.previousClosest == w && !isTheMain) {
            return;
        }
        GlStateManager.func_179094_E();
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        if (distance > 250000.0) {
            double offScaler = 250000.0 / distance;
            offX *= offScaler;
            offY *= offScaler;
            offZ *= offScaler;
        }
        this.drawAsOverlay((float)(d3 + offX), (float)(d4 + offY), (float)(d5 + offZ), worldModelView, w, modMain.getSettings(), bufferBuilder, tessellator, fontrenderer, name, distanceText, textSize, showDistance, waypointsProjection, screenWidth, screenHeight, depthClamp, depth, isTheMain, uiScale, subworldName);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawAsOverlay(float offX, float offY, float offZ, float[] worldModelView, Waypoint w, ModSettings settings, BufferBuilder vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance, float[] waypointsProjection, int screenWidth, int screenHeight, double depthClamp, double depth, boolean isTheMain, double uiScale, String subworldName) {
        this.origin4f.set(offX, offY, offZ, 1.0f);
        Misc.transformVector4f(this.origin4f, worldModelView);
        Misc.transformVector4f(this.origin4f, waypointsProjection);
        int overlayPosX = (int)((1.0f + this.origin4f.getX() / this.origin4f.getW()) / 2.0f * (float)screenWidth);
        int overlayPosY = (int)((1.0f - this.origin4f.getY() / this.origin4f.getW()) / 2.0f * (float)screenHeight);
        GlStateManager.func_179109_b((float)overlayPosX, (float)overlayPosY, (float)0.0f);
        if (depth < depthClamp) {
            float scale = (float)(depthClamp / depth);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        }
        this.drawIconInWorld(w, settings, vertexBuffer, tessellator, fontrenderer, name, distance, textSize, showDistance, isTheMain, uiScale, subworldName);
    }

    public void drawIconInWorld(Waypoint w, ModSettings settings, BufferBuilder vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance, boolean isTheMain, double uiScale, String subworldName) {
        double iconScale = settings.getWaypointsIngameIconScale(uiScale);
        double distanceScale = settings.getWaypointsIngameDistanceScale(uiScale);
        double nameScale = settings.getWaypointsIngameNameScale(uiScale);
        int ingameOpacity = settings.waypointOpacityIngame;
        int addedFrame = 0;
        if (Minecraft.func_71410_x().func_152349_b()) {
            iconScale = (int)((iconScale + 1.0) / 2.0) * 2;
            distanceScale = (int)((distanceScale + 1.0) / 2.0) * 2;
            nameScale = (int)((nameScale + 1.0) / 2.0) * 2;
        }
        int c = ModSettings.COLORS[w.getColor()];
        float red = (float)(c >> 16 & 0xFF) / 255.0f;
        float green = (float)(c >> 8 & 0xFF) / 255.0f;
        float blue = (float)(c & 0xFF) / 255.0f;
        float alpha = 133.3f * ((float)ingameOpacity / 100.0f) / 255.0f;
        if (isTheMain) {
            alpha = Math.min(1.0f, alpha * 1.5f);
        }
        int halfIconPixel = (int)iconScale / 2;
        GlStateManager.func_179109_b((float)halfIconPixel, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)((float)iconScale), (float)((float)iconScale), (float)1.0f);
        if (w.getWaypointType() != 1) {
            GlStateManager.func_179152_a((float)textSize, (float)textSize, (float)textSize);
            int s = fontrenderer.func_78256_a(w.getSymbol()) / 2;
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
            addedFrame = this.renderColorBackground(vertexBuffer, tessellator, addedFrame, s);
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(w.getSymbol(), -s, -8, -1);
        } else {
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
            GlStateManager.func_179090_x();
            addedFrame = this.renderColorBackground(vertexBuffer, tessellator, addedFrame, 4);
            GlStateManager.func_179098_w();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            GlStateManager.func_179131_c((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            this.renderTexturedIcon(vertexBuffer, tessellator, addedFrame, 0, 78);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!showDistance) {
                name = w.getLocalizedName();
            }
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        boolean showingName = name.length() > 0;
        GlStateManager.func_179109_b((float)0.0f, (float)addedFrame, (float)0.0f);
        GlStateManager.func_179152_a((float)((float)(1.0 / iconScale)), (float)((float)(1.0 / iconScale)), (float)1.0f);
        GlStateManager.func_179109_b((float)(-halfIconPixel), (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
        float labelAlpha = 0.3529412f;
        if ((showDistance || showingName) && subworldName != null) {
            this.renderWaypointLabel(tessellator, vertexBuffer, fontrenderer, subworldName, nameScale, labelAlpha);
            GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
        }
        if (showingName) {
            this.renderWaypointLabel(tessellator, vertexBuffer, fontrenderer, name, nameScale, labelAlpha);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
        if (distance.length() > 0) {
            this.renderWaypointLabel(tessellator, vertexBuffer, fontrenderer, distance, distanceScale, labelAlpha);
        }
    }

    private void renderWaypointLabel(Tessellator tessellator, BufferBuilder vertexBuffer, FontRenderer fontrenderer, String label, double labelScale, float bgAlpha) {
        int nameW = fontrenderer.func_78256_a(label);
        int bgW = nameW + 3;
        int halfBgW = bgW / 2;
        int halfNamePixel = 0;
        if ((bgW & 1) != 0) {
            halfNamePixel = (int)labelScale - (int)labelScale / 2;
            GlStateManager.func_179109_b((float)(-halfNamePixel), (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)((float)labelScale), (float)((float)labelScale), (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)bgAlpha);
        this.renderColoredRect(tessellator, vertexBuffer, -halfBgW, 0, bgW, 9);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(label, -halfBgW + 2, 1, -1);
        GlStateManager.func_179109_b((float)0.0f, (float)9.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)((float)(1.0 / labelScale)), (float)((float)(1.0 / labelScale)), (float)1.0f);
        if ((bgW & 1) != 0) {
            GlStateManager.func_179109_b((float)halfNamePixel, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179147_l();
    }

    private void renderColoredRect(Tessellator tessellator, BufferBuilder vertexBuffer, int x1, int y1, int w, int h) {
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        int x2 = x1 + w;
        int y2 = y1 + h;
        vertexBuffer.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)x1, (double)y2, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)x2, (double)y1, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private int renderColorBackground(BufferBuilder vertexBuffer, Tessellator tessellator, int addedFrame, int s) {
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        if (s > 4) {
            addedFrame = s - 4;
        }
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_181675_d();
        tessellator.func_78381_a();
        return addedFrame;
    }

    private void renderTexturedIcon(BufferBuilder vertexBuffer, Tessellator tessellator, int addedFrame, int textureX, int textureY) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_187315_a((double)((float)textureX * f), (double)((float)textureY * f1)).func_181675_d();
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).func_187315_a((double)((float)textureX * f), (double)((float)(textureY + 9 + addedFrame * 2) * f1)).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, (double)addedFrame, 0.0).func_187315_a((double)((float)(textureX + 9 + addedFrame * 2) * f), (double)((float)(textureY + 9 + addedFrame * 2) * f1)).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_187315_a((double)((float)(textureX + 9 + addedFrame * 2) * f), (double)((float)textureY * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

