/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dynamical_compass.elements.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.dynamical_compass.elements.items.ModItems;
import de.geheimagentnr1.dynamical_compass.elements.items.dynamical_compass.DynamicalCompassItemStackHelper;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.Vec2Argument;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class GiveDCCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder giveDC = (LiteralArgumentBuilder)Commands.func_197057_a((String)"giveDC").requires(commandSource -> commandSource.func_197034_c(2));
        giveDC.then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"destination", (ArgumentType)Vec2Argument.func_197296_a()).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"locked", (ArgumentType)BoolArgumentType.bool()).executes(GiveDCCommand::giveDC)))));
        dispatcher.register(giveDC);
    }

    private static int giveDC(CommandContext<CommandSource> context) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        Collection playerEntities = EntityArgument.func_197090_e(context, (String)"targets");
        ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionArgument.func_212592_a(context, (String)"dimension"));
        Vec2f vecPos = Vec2Argument.func_197295_a(context, (String)"destination");
        BlockPos pos = new BlockPos((double)vecPos.field_189982_i, 0.0, (double)vecPos.field_189983_j);
        boolean locked = BoolArgumentType.getBool(context, (String)"locked");
        for (ServerPlayerEntity player : playerEntities) {
            ItemEntity entity;
            ItemStack stack = GiveDCCommand.createItemstack(world, pos, locked);
            boolean couldAdd = player.field_71071_by.func_70441_a(stack);
            if (couldAdd && stack.func_190926_b()) {
                stack.func_190920_e(1);
                entity = player.func_71019_a(stack, false);
                if (entity != null) {
                    entity.func_174870_v();
                }
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.field_71069_bz.func_75142_b();
                continue;
            }
            entity = player.func_71019_a(stack, false);
            if (entity == null) continue;
            entity.func_174868_q();
            entity.func_200217_b(player.func_110124_au());
        }
        ItemStack stack = GiveDCCommand.createItemstack(world, pos, locked);
        if (playerEntities.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.give.success.single", new Object[]{1, stack.func_151000_E(), ((ServerPlayerEntity)playerEntities.iterator().next()).func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.give.success.single", new Object[]{1, stack.func_151000_E(), playerEntities.size()}), true);
        }
        return playerEntities.size();
    }

    private static ItemStack createItemstack(ServerWorld world, BlockPos pos, boolean locked) {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.DYNAMICAL_COMPASS);
        DynamicalCompassItemStackHelper.setDimensionAndPos(stack, (World)world, pos);
        DynamicalCompassItemStackHelper.setLocked(stack, locked);
        return stack;
    }
}

