/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl.network.packet;

import java.util.UUID;
import lain.mods.cos.impl.InventoryManager;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import lain.mods.cos.impl.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncHiddenFlags
implements NetworkManager.NetworkPacket {
    UUID uuid;
    String modid;
    String identifier;
    boolean hidden;

    public PacketSyncHiddenFlags() {
    }

    public PacketSyncHiddenFlags(UUID uuid, InventoryCosArmor inventory, String modid, String identifier) {
        this.uuid = uuid;
        this.modid = modid;
        this.identifier = identifier;
        this.hidden = inventory.isHidden(modid, identifier);
    }

    @Override
    public void handlePacketClient(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            if (InventoryManager.checkIdentifier(this.modid, this.identifier)) {
                ModObjects.invMan.getCosArmorInventoryClient(this.uuid).setHidden(this.modid, this.identifier, this.hidden);
            }
        });
    }

    @Override
    public void handlePacketServer(NetworkEvent.Context context) {
    }

    @Override
    public void readFromBuffer(PacketBuffer buffer) {
        this.uuid = new UUID(buffer.readLong(), buffer.readLong());
        this.modid = buffer.func_150789_c(Short.MAX_VALUE);
        this.identifier = buffer.func_150789_c(Short.MAX_VALUE);
        this.hidden = buffer.readBoolean();
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeLong(this.uuid.getMostSignificantBits());
        buffer.writeLong(this.uuid.getLeastSignificantBits());
        buffer.func_211400_a(this.modid, Short.MAX_VALUE);
        buffer.func_211400_a(this.identifier, Short.MAX_VALUE);
        buffer.writeBoolean(this.hidden);
    }
}

