/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dressrosa;

import java.util.function.Supplier;
import net.mcreator.dressrosa.DressrosaMod;
import net.mcreator.dressrosa.DressrosaModElements;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class DressrosaModVariables {
    public DressrosaModVariables(DressrosaModElements elements) {
        elements.addNetworkMessage(WorldSavedDataSyncMessage.class, WorldSavedDataSyncMessage::buffer, WorldSavedDataSyncMessage::new, WorldSavedDataSyncMessage::handler);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            MapVariables mapdata = MapVariables.get((IWorld)event.getPlayer().field_70170_p);
            WorldVariables worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p);
            if (mapdata != null) {
                DressrosaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(0, mapdata));
            }
            if (worlddata != null) {
                DressrosaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WorldVariables worlddata;
        if (!event.getPlayer().field_70170_p.field_72995_K && (worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p)) != null) {
            DressrosaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
        }
    }

    public static class WorldSavedDataSyncMessage {
        public int type;
        public WorldSavedData data;

        public WorldSavedDataSyncMessage(PacketBuffer buffer) {
            this.type = buffer.readInt();
            this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            this.data.func_76184_a(buffer.func_150793_b());
        }

        public WorldSavedDataSyncMessage(int type, WorldSavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(WorldSavedDataSyncMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.type);
            buffer.func_150786_a(message.data.func_189551_b(new CompoundNBT()));
        }

        public static void handler(WorldSavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "dressrosa_mapvars";
        public boolean eventActive = false;
        public double healthRequirement = 0.0;
        public double arenaXCoord2 = 0.0;
        public double arenaXCoord1 = 0.0;
        public double arenaYCoord2 = 0.0;
        public double arenaZCoord2 = 0.0;
        public double arenaXCoord = 0.0;
        public double arenaYCoord = 0.0;
        public double arenaZCoord = 0.0;
        public double arenaYCoord1 = 0.0;
        public double arenaZCoord1 = 0.0;
        public double specXCoord = 0.0;
        public double specYCoord = 0.0;
        public double specZCoord = 0.0;
        public double logOffXCoord = 0.0;
        public double logOffYCoord = 0.0;
        public double logOffZCoord = 0.0;
        public boolean eventPlanned = false;
        public double wither_spawner_cooldown = 0.0;
        public double wither_spawner_cooldown_timer_sec = 300.0;
        static MapVariables clientSide = new MapVariables();

        public MapVariables() {
            super(DATA_NAME);
        }

        public MapVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.eventActive = nbt.func_74767_n("eventActive");
            this.healthRequirement = nbt.func_74769_h("healthRequirement");
            this.arenaXCoord2 = nbt.func_74769_h("arenaXCoord2");
            this.arenaXCoord1 = nbt.func_74769_h("arenaXCoord1");
            this.arenaYCoord2 = nbt.func_74769_h("arenaYCoord2");
            this.arenaZCoord2 = nbt.func_74769_h("arenaZCoord2");
            this.arenaXCoord = nbt.func_74769_h("arenaXCoord");
            this.arenaYCoord = nbt.func_74769_h("arenaYCoord");
            this.arenaZCoord = nbt.func_74769_h("arenaZCoord");
            this.arenaYCoord1 = nbt.func_74769_h("arenaYCoord1");
            this.arenaZCoord1 = nbt.func_74769_h("arenaZCoord1");
            this.specXCoord = nbt.func_74769_h("specXCoord");
            this.specYCoord = nbt.func_74769_h("specYCoord");
            this.specZCoord = nbt.func_74769_h("specZCoord");
            this.logOffXCoord = nbt.func_74769_h("logOffXCoord");
            this.logOffYCoord = nbt.func_74769_h("logOffYCoord");
            this.logOffZCoord = nbt.func_74769_h("logOffZCoord");
            this.eventPlanned = nbt.func_74767_n("eventPlanned");
            this.wither_spawner_cooldown = nbt.func_74769_h("wither_spawner_cooldown");
            this.wither_spawner_cooldown_timer_sec = nbt.func_74769_h("wither_spawner_cooldown_timer_sec");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            nbt.func_74757_a("eventActive", this.eventActive);
            nbt.func_74780_a("healthRequirement", this.healthRequirement);
            nbt.func_74780_a("arenaXCoord2", this.arenaXCoord2);
            nbt.func_74780_a("arenaXCoord1", this.arenaXCoord1);
            nbt.func_74780_a("arenaYCoord2", this.arenaYCoord2);
            nbt.func_74780_a("arenaZCoord2", this.arenaZCoord2);
            nbt.func_74780_a("arenaXCoord", this.arenaXCoord);
            nbt.func_74780_a("arenaYCoord", this.arenaYCoord);
            nbt.func_74780_a("arenaZCoord", this.arenaZCoord);
            nbt.func_74780_a("arenaYCoord1", this.arenaYCoord1);
            nbt.func_74780_a("arenaZCoord1", this.arenaZCoord1);
            nbt.func_74780_a("specXCoord", this.specXCoord);
            nbt.func_74780_a("specYCoord", this.specYCoord);
            nbt.func_74780_a("specZCoord", this.specZCoord);
            nbt.func_74780_a("logOffXCoord", this.logOffXCoord);
            nbt.func_74780_a("logOffYCoord", this.logOffYCoord);
            nbt.func_74780_a("logOffZCoord", this.logOffZCoord);
            nbt.func_74757_a("eventPlanned", this.eventPlanned);
            nbt.func_74780_a("wither_spawner_cooldown", this.wither_spawner_cooldown);
            nbt.func_74780_a("wither_spawner_cooldown_timer_sec", this.wither_spawner_cooldown_timer_sec);
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (!world.func_201672_e().field_72995_K) {
                DressrosaMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new WorldSavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(IWorld world) {
            if (world.func_201672_e() instanceof ServerWorld) {
                return (MapVariables)world.func_201672_e().func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215752_a(MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "dressrosa_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public WorldVariables() {
            super(DATA_NAME);
        }

        public WorldVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (!world.func_201672_e().field_72995_K) {
                DressrosaMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Dimension)world.func_201672_e().field_73011_w).func_186058_p()), (Object)new WorldSavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(IWorld world) {
            if (world.func_201672_e() instanceof ServerWorld) {
                return (WorldVariables)((ServerWorld)world.func_201672_e()).func_217481_x().func_215752_a(WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }
}

