/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.api.util;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.IWorldGenerationBaseReader;

public class GenerationUtils {
    public static <B extends BlockState> BlockState getWallPlaceState(B state, IWorld world, BlockPos pos) {
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177974_f();
        BlockPos blockpos3 = pos.func_177968_d();
        BlockPos blockpos4 = pos.func_177976_e();
        BlockState blockstate = world.func_180495_p(blockpos1);
        BlockState blockstate1 = world.func_180495_p(blockpos2);
        BlockState blockstate2 = world.func_180495_p(blockpos3);
        BlockState blockstate3 = world.func_180495_p(blockpos4);
        boolean flag = GenerationUtils.getWallFlag(blockstate, blockstate.func_224755_d((IBlockReader)world, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = GenerationUtils.getWallFlag(blockstate1, blockstate1.func_224755_d((IBlockReader)world, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = GenerationUtils.getWallFlag(blockstate2, blockstate2.func_224755_d((IBlockReader)world, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = GenerationUtils.getWallFlag(blockstate3, blockstate3.func_224755_d((IBlockReader)world, blockpos4, Direction.EAST), Direction.EAST);
        boolean flag4 = !(flag && !flag1 && flag2 && !flag3 || !flag && flag1 && !flag2 && flag3);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)WallBlock.field_176256_a, (Comparable)Boolean.valueOf(flag4 || !world.func_175623_d(pos.func_177984_a())))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(flag))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(flag1))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(flag2))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(flag3));
    }

    public static boolean getWallFlag(BlockState p_220113_1_, boolean p_220113_2_, Direction p_220113_3_) {
        Block block = p_220113_1_.func_177230_c();
        boolean flag = block.func_203417_a(BlockTags.field_219757_z) || block instanceof FenceGateBlock && FenceGateBlock.func_220253_a((BlockState)p_220113_1_, (Direction)p_220113_3_);
        return !Block.func_220073_a((Block)block) && p_220113_2_ || flag;
    }

    public static boolean isAir(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IBlockReader)) {
            return worldIn.func_217375_a(pos, BlockState::func_196958_f);
        }
        return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
    }

    public static <B extends BlockState> boolean isProperBlock(B blockState, Block[] validBlocks, boolean orSolid) {
        if (!Arrays.asList(validBlocks).contains(blockState.func_177230_c()) && orSolid) {
            return blockState.func_200132_m();
        }
        return Arrays.asList(validBlocks).contains(blockState.func_177230_c());
    }

    public static void fillAreaWithBlockCube(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!world.func_180495_p(new BlockPos(xx, yy, zz)).func_185904_a().func_76222_j()) continue;
                    world.func_180501_a(new BlockPos(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeEdged(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!world.func_180495_p(new BlockPos(xx, yy, zz)).func_185904_a().func_76222_j() || xx != x2 && zz != z2) continue;
                    world.func_180501_a(new BlockPos(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeUnsafe(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    world.func_180501_a(new BlockPos(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeUnsafeReverse(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx >= x2; --xx) {
                for (int zz = z1; zz >= z2; --zz) {
                    world.func_180501_a(new BlockPos(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static void fillWithRandomTwoBlocksCube(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, Random rand, BlockState block, BlockState block2, float chance) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!world.func_180495_p(new BlockPos(xx, yy, zz)).func_185904_a().func_76222_j()) continue;
                    if (rand.nextFloat() <= chance) {
                        world.func_180501_a(new BlockPos(xx, yy, zz), block2, 2);
                        continue;
                    }
                    world.func_180501_a(new BlockPos(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static boolean isAreaReplacable(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (world.func_180495_p(new BlockPos(xx, yy, zz)).func_185904_a().func_76222_j()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAreaAir(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (world.func_175623_d(new BlockPos(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAreaCompletelySolid(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!world.func_180495_p(new BlockPos(xx, yy, zz)).func_185904_a().func_76222_j()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static BlockPos getClosestPositionToPos(List<BlockPos> positions, BlockPos pos) {
        double distance = -1.0;
        BlockPos currentPos = null;
        for (BlockPos listOfPositions : positions) {
            double newDistance = new Vec3d((Vec3i)pos).func_72436_e(new Vec3d((Vec3i)listOfPositions));
            if (distance != -1.0 && !(newDistance < distance)) continue;
            distance = newDistance;
            currentPos = listOfPositions;
        }
        return currentPos;
    }
}

