/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teamabnormals.abnormals_core.client.ACRenderTypes;
import endergeticexpansion.client.model.corrock.CorrockCrownStandingModel;
import endergeticexpansion.client.model.corrock.CorrockCrownWallModel;
import endergeticexpansion.common.blocks.CorrockCrownStandingBlock;
import endergeticexpansion.common.tileentities.CorrockCrownTileEntity;
import endergeticexpansion.core.registry.EEBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class CorrockCrownTileEntityRenderer
extends TileEntityRenderer<CorrockCrownTileEntity> {
    public CorrockCrownStandingModel standingModel = new CorrockCrownStandingModel();
    public CorrockCrownWallModel wallModel = new CorrockCrownWallModel();
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("endergetic:textures/tile/corrock_crown_end.png"), new ResourceLocation("endergetic:textures/tile/corrock_crown_nether.png"), new ResourceLocation("endergetic:textures/tile/corrock_crown_overworld.png")};

    public CorrockCrownTileEntityRenderer(TileEntityRendererDispatcher renderDispatcher) {
        super(renderDispatcher);
    }

    public void render(CorrockCrownTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        float angle;
        BlockState state = te.func_195044_w();
        boolean isStanding = state.func_177230_c() instanceof CorrockCrownStandingBlock;
        matrixStack.func_227860_a_();
        if (isStanding) {
            matrixStack.func_227861_a_(0.5, 1.5, 0.5);
            angle = -((float)((Integer)state.func_177229_b((IProperty)StandingSignBlock.field_176413_a) * 360) / 16.0f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        } else {
            matrixStack.func_227861_a_(0.5, 1.5, 0.5);
            angle = -((Direction)state.func_177229_b((IProperty)WallSignBlock.field_176412_a)).func_176734_d().func_185119_l();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
            matrixStack.func_227861_a_(0.0, (double)-0.4f, (double)0.05f);
        }
        if (isStanding && ((Boolean)state.func_177229_b((IProperty)CorrockCrownStandingBlock.UPSIDE_DOWN)).booleanValue()) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            matrixStack.func_227861_a_(0.0, 2.0, 0.0);
        }
        matrixStack.func_227862_a_(1.0f, -1.0f, -1.0f);
        if (isStanding) {
            IVertexBuilder ivertexbuilder = buffer.getBuffer(ACRenderTypes.getEmissiveEntity((ResourceLocation)TEXTURES[this.getTexture(te)]));
            this.standingModel.renderAll(matrixStack, ivertexbuilder, 240, combinedOverlay);
        } else {
            IVertexBuilder ivertexbuilder = buffer.getBuffer(ACRenderTypes.getEmissiveEntity((ResourceLocation)TEXTURES[this.getTexture(te)]));
            this.wallModel.renderAll(matrixStack, ivertexbuilder, 240, combinedOverlay);
        }
        matrixStack.func_227865_b_();
    }

    public int getTexture(CorrockCrownTileEntity te) {
        Block block = te.func_195044_w().func_177230_c();
        if (block == EEBlocks.CORROCK_CROWN_END_STANDING.get() || block == EEBlocks.CORROCK_CROWN_END_WALL.get() || block == EEBlocks.PETRIFIED_CORROCK_CROWN_END_STANDING.get() || block == EEBlocks.PETRIFIED_CORROCK_CROWN_END_WALL.get()) {
            return 0;
        }
        if (block == EEBlocks.CORROCK_CROWN_NETHER_STANDING.get() || block == EEBlocks.CORROCK_CROWN_NETHER_WALL.get() || block == EEBlocks.PETRIFIED_CORROCK_CROWN_NETHER_STANDING.get() || block == EEBlocks.PETRIFIED_CORROCK_CROWN_NETHER_WALL.get()) {
            return 1;
        }
        return 2;
    }
}

