/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.world.features;

import com.mojang.datafixers.Dynamic;
import endergeticexpansion.api.util.GenerationUtils;
import endergeticexpansion.common.blocks.AcidianLanternBlock;
import endergeticexpansion.common.world.biomes.EndergeticBiome;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.EndGatewayConfig;
import net.minecraft.world.gen.feature.Feature;

public class EndergeticEndGatewayFeature
extends Feature<EndGatewayConfig> {
    private static final Supplier<BlockState> MYSTICAL_OBSIDIAN = () -> ((Block)EEBlocks.MYSTICAL_OBSIDIAN.get()).func_176223_P();
    private static final Supplier<BlockState> MYSTICAL_OBSIDIAN_WALL = () -> ((WallBlock)EEBlocks.MYSTICAL_OBSIDIAN_WALL.get()).func_176223_P();
    private static final Supplier<BlockState> ACIDIAN_LANTERN = () -> ((AcidianLanternBlock)EEBlocks.ACIDIAN_LANTERN.get()).func_176223_P();

    public EndergeticEndGatewayFeature(Function<Dynamic<?>, ? extends EndGatewayConfig> config) {
        super(config);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, EndGatewayConfig config) {
        if (worldIn.func_226691_t_(pos) instanceof EndergeticBiome && !GenerationUtils.isAreaReplacable(worldIn, pos.func_177958_n() - 1, pos.func_177956_o() - 4, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 4, pos.func_177952_p() + 1)) {
            return false;
        }
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -2, -1), (BlockPos)pos.func_177982_a(1, 2, 1))) {
            boolean flag3;
            boolean flag = blockpos.func_177958_n() == pos.func_177958_n();
            boolean flag1 = blockpos.func_177956_o() == pos.func_177956_o();
            boolean flag2 = blockpos.func_177952_p() == pos.func_177952_p();
            boolean bl = flag3 = Math.abs(blockpos.func_177956_o() - pos.func_177956_o()) == 2;
            if (flag && flag1 && flag2) {
                BlockPos blockpos1 = blockpos.func_185334_h();
                this.func_202278_a((IWorldWriter)worldIn, blockpos1, Blocks.field_185775_db.func_176223_P());
                config.func_214700_b().ifPresent(p_214624_3_ -> {
                    TileEntity tileentity = worldIn.func_175625_s(blockpos1);
                    if (tileentity instanceof EndGatewayTileEntity) {
                        EndGatewayTileEntity endgatewaytileentity = (EndGatewayTileEntity)tileentity;
                        endgatewaytileentity.func_195489_b(p_214624_3_, config.func_214701_c());
                        tileentity.func_70296_d();
                    }
                });
                continue;
            }
            if (flag1) {
                this.func_202278_a((IWorldWriter)worldIn, blockpos, Blocks.field_150350_a.func_176223_P());
                continue;
            }
            if (flag3 && flag && flag2) {
                this.func_202278_a((IWorldWriter)worldIn, blockpos, MYSTICAL_OBSIDIAN.get());
                continue;
            }
            if ((flag || flag2) && !flag3) {
                this.func_202278_a((IWorldWriter)worldIn, blockpos, MYSTICAL_OBSIDIAN.get());
                continue;
            }
            this.func_202278_a((IWorldWriter)worldIn, blockpos, Blocks.field_150350_a.func_176223_P());
        }
        this.placeWall(worldIn, pos.func_177979_c(3));
        this.placeWall(worldIn, pos.func_177981_b(3));
        this.placeWall(worldIn, pos.func_177978_c().func_177974_f().func_177984_a());
        this.placeWall(worldIn, pos.func_177978_c().func_177976_e().func_177984_a());
        this.placeWall(worldIn, pos.func_177968_d().func_177974_f().func_177984_a());
        this.placeWall(worldIn, pos.func_177968_d().func_177976_e().func_177984_a());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177981_b(4), (BlockState)ACIDIAN_LANTERN.get().func_206870_a((IProperty)AcidianLanternBlock.field_176387_N, (Comparable)Direction.UP));
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177979_c(4), (BlockState)ACIDIAN_LANTERN.get().func_206870_a((IProperty)AcidianLanternBlock.field_176387_N, (Comparable)Direction.DOWN));
        return true;
    }

    private void placeWall(IWorld world, BlockPos pos) {
        world.func_180501_a(pos, GenerationUtils.getWallPlaceState(MYSTICAL_OBSIDIAN_WALL.get(), world, pos), 2);
    }
}

