/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.world.features;

import com.mojang.datafixers.Dynamic;
import com.teamabnormals.abnormals_core.common.blocks.wood.AbnormalsLogBlock;
import endergeticexpansion.api.util.GenerationUtils;
import endergeticexpansion.common.blocks.poise.BolloomBudBlock;
import endergeticexpansion.common.blocks.poise.GlowingPoiseLogBlock;
import endergeticexpansion.common.blocks.poise.PoiseBushBlock;
import endergeticexpansion.common.blocks.poise.PoiseClusterBlock;
import endergeticexpansion.common.blocks.poise.PoiseTallBushBlock;
import endergeticexpansion.common.blocks.poise.PoismossBlock;
import endergeticexpansion.common.blocks.poise.PoismossEumusBlock;
import endergeticexpansion.core.registry.EEBlocks;
import endergeticexpansion.core.registry.other.EETags;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PoiseTreeFeature
extends Feature<NoFeatureConfig> {
    private final Supplier<BlockState> POISMOSS_EUMUS = () -> ((PoismossEumusBlock)EEBlocks.POISMOSS_EUMUS.get()).func_176223_P();
    private final Supplier<BlockState> POISE_LOG = () -> ((AbnormalsLogBlock)EEBlocks.POISE_LOG.get()).func_176223_P();
    private final Supplier<BlockState> GLOWING_POISE_LOG = () -> ((GlowingPoiseLogBlock)EEBlocks.POISE_LOG_GLOWING.get()).func_176223_P();

    public PoiseTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int treeHeight = rand.nextInt(19) + 13;
        int size = 0;
        float rng = rand.nextFloat();
        size = rng <= 0.45f ? 0 : (rng >= 0.85f ? 2 : 1);
        if (this.isValidGround(world, pos.func_177977_b()) && this.isAreaOpen(world, pos)) {
            boolean[] isSutableForSizes = new boolean[]{GenerationUtils.isAreaReplacable(world, pos.func_177964_d(3).func_177985_f(3).func_177981_b(treeHeight).func_177958_n(), pos.func_177964_d(3).func_177985_f(3).func_177981_b(treeHeight).func_177956_o(), pos.func_177964_d(3).func_177985_f(3).func_177981_b(treeHeight).func_177952_p(), pos.func_177970_e(3).func_177965_g(3).func_177981_b(treeHeight + 7).func_177958_n(), pos.func_177970_e(3).func_177965_g(3).func_177981_b(treeHeight + 7).func_177956_o(), pos.func_177970_e(3).func_177965_g(3).func_177981_b(treeHeight + 7).func_177952_p()), GenerationUtils.isAreaReplacable(world, pos.func_177964_d(4).func_177985_f(4).func_177981_b(treeHeight).func_177958_n(), pos.func_177964_d(4).func_177985_f(4).func_177981_b(treeHeight).func_177956_o(), pos.func_177964_d(4).func_177985_f(4).func_177981_b(treeHeight).func_177952_p(), pos.func_177970_e(4).func_177965_g(4).func_177981_b(treeHeight + 9).func_177958_n(), pos.func_177970_e(4).func_177965_g(4).func_177981_b(treeHeight + 9).func_177956_o(), pos.func_177970_e(4).func_177965_g(4).func_177981_b(treeHeight + 9).func_177952_p()), GenerationUtils.isAreaReplacable(world, pos.func_177964_d(6).func_177985_f(6).func_177981_b(treeHeight).func_177958_n(), pos.func_177964_d(6).func_177985_f(6).func_177981_b(treeHeight).func_177956_o(), pos.func_177964_d(6).func_177985_f(6).func_177981_b(treeHeight).func_177952_p(), pos.func_177970_e(6).func_177965_g(6).func_177981_b(treeHeight + 13).func_177958_n(), pos.func_177970_e(6).func_177965_g(6).func_177981_b(treeHeight + 13).func_177956_o(), pos.func_177970_e(6).func_177965_g(6).func_177981_b(treeHeight + 13).func_177952_p())};
            if (size == 0) {
                if (GenerationUtils.isAreaReplacable(world, pos.func_177978_c().func_177976_e().func_177958_n(), pos.func_177978_c().func_177976_e().func_177956_o(), pos.func_177978_c().func_177976_e().func_177952_p(), pos.func_177968_d().func_177974_f().func_177981_b(treeHeight).func_177958_n(), pos.func_177968_d().func_177974_f().func_177981_b(treeHeight).func_177956_o(), pos.func_177968_d().func_177974_f().func_177981_b(treeHeight).func_177952_p())) {
                    if (isSutableForSizes[0]) {
                        this.buildTreeBase(world, pos, rand);
                        this.buildStem(world, pos, rand, treeHeight);
                        this.buildTreeTop(world, pos, rand, treeHeight, size);
                        if (rand.nextFloat() <= 0.8f) {
                            this.tryToBuildBranch(world, pos, rand, treeHeight);
                        }
                        this.buildPoismossCircle(world, (IWorldGenerationReader)world, rand, pos);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            if (size == 1) {
                if (GenerationUtils.isAreaReplacable(world, pos.func_177978_c().func_177976_e().func_177958_n(), pos.func_177978_c().func_177976_e().func_177956_o(), pos.func_177978_c().func_177976_e().func_177952_p(), pos.func_177968_d().func_177974_f().func_177981_b(treeHeight).func_177958_n(), pos.func_177968_d().func_177974_f().func_177981_b(treeHeight).func_177956_o(), pos.func_177968_d().func_177974_f().func_177981_b(treeHeight).func_177952_p())) {
                    if (isSutableForSizes[1]) {
                        this.buildTreeBase(world, pos, rand);
                        this.buildStem(world, pos, rand, treeHeight);
                        this.buildTreeTop(world, pos, rand, treeHeight, size);
                        if (rand.nextFloat() <= 0.8f) {
                            this.tryToBuildBranch(world, pos, rand, treeHeight);
                        }
                        this.buildPoismossCircle(world, (IWorldGenerationReader)world, rand, pos);
                        return true;
                    }
                    if (isSutableForSizes[0]) {
                        this.buildTreeBase(world, pos, rand);
                        this.buildStem(world, pos, rand, treeHeight);
                        this.buildTreeTop(world, pos, rand, treeHeight, 0);
                        if (rand.nextFloat() <= 0.8f) {
                            this.tryToBuildBranch(world, pos, rand, treeHeight);
                        }
                        this.buildPoismossCircle(world, (IWorldGenerationReader)world, rand, pos);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            if (size == 2) {
                if (GenerationUtils.isAreaReplacable(world, pos.func_177978_c().func_177976_e().func_177958_n(), pos.func_177978_c().func_177976_e().func_177956_o(), pos.func_177978_c().func_177976_e().func_177952_p(), pos.func_177968_d().func_177974_f().func_177981_b(treeHeight).func_177958_n(), pos.func_177968_d().func_177974_f().func_177981_b(treeHeight).func_177956_o(), pos.func_177968_d().func_177974_f().func_177981_b(treeHeight).func_177952_p())) {
                    if (isSutableForSizes[2]) {
                        this.buildTreeBase(world, pos, rand);
                        this.buildStem(world, pos, rand, treeHeight);
                        this.buildTreeTop(world, pos, rand, treeHeight, size);
                        if (rand.nextFloat() <= 0.8f) {
                            this.tryToBuildBranch(world, pos, rand, treeHeight);
                        }
                        this.buildPoismossCircle(world, (IWorldGenerationReader)world, rand, pos);
                        return true;
                    }
                    if (isSutableForSizes[1]) {
                        this.buildTreeBase(world, pos, rand);
                        this.buildStem(world, pos, rand, treeHeight);
                        this.buildTreeTop(world, pos, rand, treeHeight, 1);
                        if (rand.nextFloat() <= 0.8f) {
                            this.tryToBuildBranch(world, pos, rand, treeHeight);
                        }
                        this.buildPoismossCircle(world, (IWorldGenerationReader)world, rand, pos);
                        return true;
                    }
                    if (isSutableForSizes[0]) {
                        this.buildTreeBase(world, pos, rand);
                        this.buildStem(world, pos, rand, treeHeight);
                        this.buildTreeTop(world, pos, rand, treeHeight, 0);
                        if (rand.nextFloat() <= 0.8f) {
                            this.tryToBuildBranch(world, pos, rand, treeHeight);
                        }
                        this.buildPoismossCircle(world, (IWorldGenerationReader)world, rand, pos);
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    private void buildTreeBase(IWorld world, BlockPos pos, Random rand) {
        int[] sideRandValues = new int[]{rand.nextInt(8) + 2, rand.nextInt(8) + 2, rand.nextInt(8) + 2, rand.nextInt(8) + 2};
        for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 2; ++x) {
            for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 2; ++z) {
                this.setPoiseLog(world, new BlockPos(x, pos.func_177956_o(), z), rand, true, false);
            }
        }
        for (int xN = 1; xN < sideRandValues[0] + 1; ++xN) {
            this.setPoiseLog(world, pos.func_177978_c().func_177981_b(xN), rand, true, false);
        }
        for (int xE = 1; xE < sideRandValues[1] + 1; ++xE) {
            this.setPoiseLog(world, pos.func_177974_f().func_177981_b(xE), rand, true, false);
        }
        for (int xS = 1; xS < sideRandValues[2] + 1; ++xS) {
            this.setPoiseLog(world, pos.func_177968_d().func_177981_b(xS), rand, true, false);
        }
        for (int xW = 1; xW < sideRandValues[3] + 1; ++xW) {
            this.setPoiseLog(world, pos.func_177976_e().func_177981_b(xW), rand, true, false);
        }
        BlockPos downPos = pos.func_177979_c(2);
        if (GenerationUtils.isAreaCompletelySolid(world, downPos.func_177958_n() - 1, downPos.func_177956_o(), downPos.func_177952_p() - 1, downPos.func_177958_n() + 1, downPos.func_177956_o(), downPos.func_177952_p() + 1)) {
            GenerationUtils.fillAreaWithBlockCube(world, downPos.func_177958_n() - 1, downPos.func_177956_o(), downPos.func_177952_p() - 1, downPos.func_177958_n() + 1, downPos.func_177956_o() + 1, downPos.func_177952_p() + 1, this.POISE_LOG.get());
        }
    }

    private void buildStem(IWorld world, BlockPos pos, Random rand, int height) {
        for (int y = 1; y < height; ++y) {
            boolean doBubbles = y > height - 2;
            this.setPoiseLog(world, pos.func_177981_b(y), rand, false, doBubbles);
        }
    }

    private void buildTreeTop(IWorld world, BlockPos pos, Random rand, int arrivedPos, int size) {
        if (size == 0) {
            int z;
            int x;
            for (x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; ++x) {
                for (z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, pos.func_177981_b(arrivedPos).func_177956_o(), z), rand, false, true);
                }
            }
            for (x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; ++x) {
                for (z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; ++z) {
                    this.func_202278_a((IWorldWriter)world, new BlockPos(x, pos.func_177981_b(arrivedPos + 1).func_177956_o(), z), this.POISMOSS_EUMUS.get());
                }
            }
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(2), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(2), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(2), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(2), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(3).func_177984_a(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(3).func_177984_a(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(3).func_177984_a(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(3).func_177984_a(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(2).func_177984_a().func_177974_f(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(2).func_177984_a().func_177976_e(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(2).func_177984_a().func_177978_c(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(2).func_177984_a().func_177968_d(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(2).func_177984_a().func_177974_f(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(2).func_177984_a().func_177976_e(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(2).func_177984_a().func_177978_c(), rand, false, true);
            this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(2).func_177984_a().func_177968_d(), rand, false, true);
            this.func_202278_a((IWorldWriter)world, pos.func_177981_b(arrivedPos).func_177964_d(2).func_177984_a(), this.POISMOSS_EUMUS.get());
            this.func_202278_a((IWorldWriter)world, pos.func_177981_b(arrivedPos).func_177965_g(2).func_177984_a(), this.POISMOSS_EUMUS.get());
            this.func_202278_a((IWorldWriter)world, pos.func_177981_b(arrivedPos).func_177970_e(2).func_177984_a(), this.POISMOSS_EUMUS.get());
            this.func_202278_a((IWorldWriter)world, pos.func_177981_b(arrivedPos).func_177985_f(2).func_177984_a(), this.POISMOSS_EUMUS.get());
            this.placeInnerDomeFeatures(world, rand, pos.func_177981_b(arrivedPos).func_177985_f(2).func_177984_a());
            int[] sideRandValues = new int[]{rand.nextInt(3) + 1, rand.nextInt(3) + 1, rand.nextInt(3) + 1, rand.nextInt(3) + 1};
            for (int yn = 1; yn <= sideRandValues[0]; ++yn) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(3).func_177984_a().func_177981_b(yn), rand, false, true);
                if (yn != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(3).func_177974_f().func_177984_a().func_177981_b(yn), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(3).func_177976_e().func_177984_a().func_177981_b(yn), rand, false, true);
            }
            for (int ye = 1; ye <= sideRandValues[1]; ++ye) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(3).func_177984_a().func_177981_b(ye), rand, false, true);
                if (ye != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(3).func_177968_d().func_177984_a().func_177981_b(ye), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(3).func_177978_c().func_177984_a().func_177981_b(ye), rand, false, true);
            }
            for (int ys = 1; ys <= sideRandValues[2]; ++ys) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(3).func_177984_a().func_177981_b(ys), rand, false, true);
                if (ys != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(3).func_177976_e().func_177984_a().func_177981_b(ys), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(3).func_177974_f().func_177984_a().func_177981_b(ys), rand, false, true);
            }
            for (int yw = 1; yw <= sideRandValues[3]; ++yw) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(3).func_177984_a().func_177981_b(yw), rand, false, true);
                if (yw != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(3).func_177978_c().func_177984_a().func_177981_b(yw), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(3).func_177968_d().func_177984_a().func_177981_b(yw), rand, false, true);
            }
            this.addTreeDomeTop(world, pos, rand, arrivedPos, 0);
        } else if (size == 1) {
            BlockPos cornerOrigin;
            int yn;
            int z;
            int x;
            BlockPos origin = pos.func_177981_b(arrivedPos);
            this.setPoiseLog(world, origin, rand, false, true);
            this.setPoiseLog(world, origin.func_177978_c(), rand, false, true);
            this.setPoiseLog(world, origin.func_177974_f(), rand, false, true);
            this.setPoiseLog(world, origin.func_177968_d(), rand, false, true);
            this.setPoiseLog(world, origin.func_177976_e(), rand, false, true);
            for (x = origin.func_177958_n() - 2; x <= origin.func_177958_n() + 2; ++x) {
                for (z = origin.func_177952_p() - 1; z <= origin.func_177952_p() + 1; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.func_177984_a().func_177956_o(), z), rand, false, true);
                }
            }
            for (x = origin.func_177958_n() - 1; x <= origin.func_177958_n() + 1; ++x) {
                for (z = origin.func_177952_p() - 2; z <= origin.func_177952_p() + 2; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.func_177984_a().func_177956_o(), z), rand, false, true);
                }
            }
            this.setPoiseLog(world, origin.func_177981_b(2).func_177964_d(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177964_d(3).func_177976_e(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177964_d(3).func_177974_f(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177965_g(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177965_g(3).func_177978_c(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177965_g(3).func_177968_d(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177970_e(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177970_e(3).func_177976_e(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177970_e(3).func_177974_f(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177985_f(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177985_f(3).func_177978_c(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177985_f(3).func_177968_d(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177964_d(2).func_177985_f(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177964_d(2).func_177965_g(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177970_e(2).func_177985_f(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(2).func_177970_e(2).func_177965_g(2), rand, false, true);
            for (x = origin.func_177958_n() - 2; x <= origin.func_177958_n() + 2; ++x) {
                for (z = origin.func_177952_p() - 1; z <= origin.func_177952_p() + 1; ++z) {
                    world.func_180501_a(new BlockPos(x, origin.func_177981_b(2).func_177956_o(), z), this.POISMOSS_EUMUS.get(), 2);
                }
            }
            for (x = origin.func_177958_n() - 1; x <= origin.func_177958_n() + 1; ++x) {
                for (z = origin.func_177952_p() - 2; z <= origin.func_177952_p() + 2; ++z) {
                    world.func_180501_a(new BlockPos(x, origin.func_177981_b(2).func_177956_o(), z), this.POISMOSS_EUMUS.get(), 2);
                }
            }
            this.placeInnerDomeFeatures(world, rand, origin.func_177981_b(2));
            int[] sideRandValues = new int[]{rand.nextInt(3) + 1, rand.nextInt(3) + 1, rand.nextInt(3) + 1, rand.nextInt(3) + 1};
            for (yn = 1; yn <= sideRandValues[0]; ++yn) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(4).func_177981_b(2).func_177981_b(yn), rand, false, true);
                if (yn != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(4).func_177974_f().func_177981_b(2).func_177981_b(yn), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(4).func_177976_e().func_177981_b(2).func_177981_b(yn), rand, false, true);
            }
            for (yn = 1; yn <= sideRandValues[1]; ++yn) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(4).func_177981_b(2).func_177981_b(yn), rand, false, true);
                if (yn != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(4).func_177978_c().func_177981_b(2).func_177981_b(yn), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(4).func_177968_d().func_177981_b(2).func_177981_b(yn), rand, false, true);
            }
            for (yn = 1; yn <= sideRandValues[2]; ++yn) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(4).func_177981_b(2).func_177981_b(yn), rand, false, true);
                if (yn != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(4).func_177974_f().func_177981_b(2).func_177981_b(yn), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(4).func_177976_e().func_177981_b(2).func_177981_b(yn), rand, false, true);
            }
            for (yn = 1; yn <= sideRandValues[3]; ++yn) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(4).func_177981_b(2).func_177981_b(yn), rand, false, true);
                if (yn != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(4).func_177978_c().func_177981_b(2).func_177981_b(yn), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(4).func_177968_d().func_177981_b(2).func_177981_b(yn), rand, false, true);
            }
            boolean[] doCornerFeature = new boolean[]{rand.nextInt(4) == 0, rand.nextInt(4) == 0, rand.nextInt(4) == 0, rand.nextInt(4) == 0};
            if (doCornerFeature[0]) {
                cornerOrigin = origin.func_177981_b(3).func_177964_d(3).func_177985_f(2);
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177976_e(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177976_e().func_177984_a(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177968_d().func_177976_e(), rand, false, true);
                } else {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177976_e().func_177984_a(), rand, false, true);
                    if (rand.nextBoolean()) {
                        this.setPoiseLog(world, cornerOrigin.func_177976_e().func_177981_b(2), rand, false, true);
                    }
                }
            }
            if (doCornerFeature[1]) {
                cornerOrigin = origin.func_177981_b(3).func_177965_g(3).func_177964_d(2);
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177978_c(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177978_c().func_177984_a(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177976_e().func_177978_c(), rand, false, true);
                } else {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177978_c().func_177984_a(), rand, false, true);
                    if (rand.nextBoolean()) {
                        this.setPoiseLog(world, cornerOrigin.func_177981_b(2).func_177978_c(), rand, false, true);
                    }
                }
            }
            if (doCornerFeature[2]) {
                cornerOrigin = origin.func_177981_b(3).func_177970_e(3).func_177965_g(2);
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177974_f(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177974_f().func_177984_a(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177978_c().func_177974_f(), rand, false, true);
                } else {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177974_f().func_177984_a(), rand, false, true);
                    if (rand.nextBoolean()) {
                        this.setPoiseLog(world, cornerOrigin.func_177981_b(2).func_177974_f(), rand, false, true);
                    }
                }
            }
            if (doCornerFeature[3]) {
                cornerOrigin = origin.func_177981_b(3).func_177985_f(3).func_177970_e(2);
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177968_d(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177968_d().func_177984_a(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177974_f().func_177968_d(), rand, false, true);
                } else {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.func_177984_a().func_177968_d(), rand, false, true);
                    if (rand.nextBoolean()) {
                        this.setPoiseLog(world, cornerOrigin.func_177981_b(2).func_177968_d(), rand, false, true);
                    }
                }
            }
            this.addTreeDomeTop(world, pos, rand, arrivedPos, 1);
        } else {
            int yn;
            int yn2;
            int z;
            int x;
            BlockPos origin = pos.func_177981_b(arrivedPos);
            this.setPoiseLog(world, origin, rand, false, true);
            if (rand.nextFloat() <= 0.75f) {
                this.setPoiseLog(world, origin.func_177978_c(), rand, false, true);
            }
            if (rand.nextFloat() <= 0.75f) {
                this.setPoiseLog(world, origin.func_177974_f(), rand, false, true);
            }
            if (rand.nextFloat() <= 0.75f) {
                this.setPoiseLog(world, origin.func_177968_d(), rand, false, true);
            }
            if (rand.nextFloat() <= 0.75f) {
                this.setPoiseLog(world, origin.func_177976_e(), rand, false, true);
            }
            GenerationUtils.fillWithRandomTwoBlocksCube(world, origin.func_177984_a().func_177978_c().func_177976_e().func_177958_n(), origin.func_177984_a().func_177978_c().func_177976_e().func_177956_o(), origin.func_177984_a().func_177978_c().func_177976_e().func_177952_p(), origin.func_177981_b(2).func_177974_f().func_177968_d().func_177958_n(), origin.func_177981_b(2).func_177974_f().func_177968_d().func_177956_o(), origin.func_177981_b(2).func_177974_f().func_177968_d().func_177952_p(), rand, this.POISE_LOG.get(), this.GLOWING_POISE_LOG.get(), 0.1f);
            for (x = origin.func_177958_n() - 1; x <= origin.func_177958_n() + 1; ++x) {
                for (z = origin.func_177952_p() - 3; z <= origin.func_177952_p() + 3; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.func_177981_b(3).func_177956_o(), z), rand, false, true);
                }
            }
            for (x = origin.func_177958_n() - 3; x <= origin.func_177958_n() + 3; ++x) {
                for (z = origin.func_177952_p() - 1; z <= origin.func_177952_p() + 1; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.func_177981_b(3).func_177956_o(), z), rand, false, true);
                }
            }
            this.setPoiseLog(world, origin.func_177981_b(3).func_177964_d(2).func_177965_g(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(3).func_177964_d(2).func_177985_f(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(3).func_177970_e(2).func_177965_g(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(3).func_177970_e(2).func_177985_f(2), rand, false, true);
            for (x = origin.func_177958_n() - 1; x <= origin.func_177958_n() + 1; ++x) {
                for (z = origin.func_177952_p() - 5; z <= origin.func_177952_p() + 5; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.func_177981_b(4).func_177956_o(), z), rand, false, true);
                }
            }
            for (x = origin.func_177958_n() - 5; x <= origin.func_177958_n() + 5; ++x) {
                for (z = origin.func_177952_p() - 1; z <= origin.func_177952_p() + 1; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.func_177981_b(4).func_177956_o(), z), rand, false, true);
                }
            }
            this.setPoiseLog(world, origin.func_177981_b(4).func_177964_d(3).func_177965_g(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177964_d(4).func_177965_g(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177964_d(3).func_177965_g(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177964_d(2).func_177965_g(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177964_d(2).func_177965_g(4), rand, false, true);
            world.func_180501_a(origin.func_177981_b(4).func_177964_d(2).func_177965_g(2), this.POISMOSS_EUMUS.get(), 2);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177965_g(3).func_177970_e(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177965_g(4).func_177970_e(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177965_g(3).func_177970_e(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177965_g(2).func_177970_e(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177965_g(2).func_177970_e(4), rand, false, true);
            world.func_180501_a(origin.func_177981_b(4).func_177965_g(2).func_177970_e(2), this.POISMOSS_EUMUS.get(), 2);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177970_e(3).func_177985_f(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177970_e(4).func_177985_f(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177970_e(3).func_177985_f(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177970_e(2).func_177985_f(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177970_e(2).func_177985_f(4), rand, false, true);
            world.func_180501_a(origin.func_177981_b(4).func_177970_e(2).func_177985_f(2), this.POISMOSS_EUMUS.get(), 2);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177985_f(3).func_177964_d(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177985_f(4).func_177964_d(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177985_f(3).func_177964_d(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177985_f(2).func_177964_d(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(4).func_177985_f(2).func_177964_d(4), rand, false, true);
            world.func_180501_a(origin.func_177981_b(4).func_177985_f(2).func_177964_d(2), this.POISMOSS_EUMUS.get(), 2);
            for (x = origin.func_177958_n() - 1; x <= origin.func_177958_n() + 1; ++x) {
                for (z = origin.func_177952_p() - 3; z <= origin.func_177952_p() + 3; ++z) {
                    world.func_180501_a(new BlockPos(x, origin.func_177981_b(4).func_177956_o(), z), this.POISMOSS_EUMUS.get(), 2);
                }
            }
            for (x = origin.func_177958_n() - 3; x <= origin.func_177958_n() + 3; ++x) {
                for (z = origin.func_177952_p() - 1; z <= origin.func_177952_p() + 1; ++z) {
                    world.func_180501_a(new BlockPos(x, origin.func_177981_b(4).func_177956_o(), z), this.POISMOSS_EUMUS.get(), 2);
                }
            }
            this.placeInnerDomeFeatures(world, rand, origin.func_177981_b(4));
            this.setPoiseLog(world, origin.func_177981_b(5).func_177964_d(5), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177964_d(5).func_177974_f(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177964_d(5).func_177965_g(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177964_d(5).func_177976_e(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177964_d(5).func_177985_f(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177965_g(5), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177965_g(5).func_177978_c(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177965_g(5).func_177964_d(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177965_g(5).func_177968_d(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177965_g(5).func_177970_e(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177970_e(5), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177970_e(5).func_177976_e(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177970_e(5).func_177985_f(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177970_e(5).func_177974_f(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177970_e(5).func_177965_g(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177985_f(5), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177985_f(5).func_177968_d(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177985_f(5).func_177970_e(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177985_f(5).func_177978_c(), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177985_f(5).func_177964_d(2), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177964_d(4).func_177985_f(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177964_d(3).func_177985_f(4), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177964_d(4).func_177965_g(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177964_d(3).func_177965_g(4), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177970_e(4).func_177985_f(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177970_e(3).func_177985_f(4), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177970_e(4).func_177965_g(3), rand, false, true);
            this.setPoiseLog(world, origin.func_177981_b(5).func_177970_e(3).func_177965_g(4), rand, false, true);
            int[] sideRandValues = new int[]{rand.nextInt(3) + 1, rand.nextInt(3) + 1, rand.nextInt(3) + 1, rand.nextInt(3) + 1};
            for (yn2 = 1; yn2 <= sideRandValues[0]; ++yn2) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(6).func_177981_b(5).func_177981_b(yn2), rand, false, true);
                if (yn2 != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(6).func_177976_e().func_177981_b(5).func_177981_b(yn2), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(6).func_177974_f().func_177981_b(5).func_177981_b(yn2), rand, false, true);
            }
            for (yn2 = 1; yn2 <= sideRandValues[1]; ++yn2) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(6).func_177981_b(5).func_177981_b(yn2), rand, false, true);
                if (yn2 != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(6).func_177978_c().func_177981_b(5).func_177981_b(yn2), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(6).func_177968_d().func_177981_b(5).func_177981_b(yn2), rand, false, true);
            }
            for (yn2 = 1; yn2 <= sideRandValues[2]; ++yn2) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(6).func_177981_b(5).func_177981_b(yn2), rand, false, true);
                if (yn2 != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(6).func_177976_e().func_177981_b(5).func_177981_b(yn2), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(6).func_177974_f().func_177981_b(5).func_177981_b(yn2), rand, false, true);
            }
            for (yn2 = 1; yn2 <= sideRandValues[3]; ++yn2) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(6).func_177981_b(5).func_177981_b(yn2), rand, false, true);
                if (yn2 != 1 || !(rand.nextFloat() <= 0.25f)) continue;
                if (rand.nextBoolean()) {
                    this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(6).func_177968_d().func_177981_b(5).func_177981_b(yn2), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(6).func_177978_c().func_177981_b(5).func_177981_b(yn2), rand, false, true);
            }
            int[] cornerRandValues = new int[]{(double)rand.nextFloat() <= 0.75 ? rand.nextInt(3) + 1 : 0, (double)rand.nextFloat() <= 0.75 ? rand.nextInt(3) + 1 : 0, (double)rand.nextFloat() <= 0.75 ? rand.nextInt(3) + 1 : 0, (double)rand.nextFloat() <= 0.75 ? rand.nextInt(3) + 1 : 0};
            for (yn = 1; yn <= cornerRandValues[0]; ++yn) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177964_d(4).func_177965_g(4).func_177981_b(5).func_177981_b(yn), rand, false, true);
            }
            for (yn = 1; yn <= cornerRandValues[1]; ++yn) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177965_g(4).func_177970_e(4).func_177981_b(5).func_177981_b(yn), rand, false, true);
            }
            for (yn = 1; yn <= cornerRandValues[2]; ++yn) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177970_e(4).func_177985_f(4).func_177981_b(5).func_177981_b(yn), rand, false, true);
            }
            for (yn = 1; yn <= cornerRandValues[3]; ++yn) {
                this.setPoiseLog(world, pos.func_177981_b(arrivedPos).func_177985_f(4).func_177964_d(4).func_177981_b(5).func_177981_b(yn), rand, false, true);
            }
            this.addTreeDomeTop(world, pos, rand, arrivedPos, 2);
        }
    }

    private void addTreeDomeTop(IWorld world, BlockPos pos, Random rand, int arrivedPos, int size) {
        BlockPos origin = pos.func_177981_b(arrivedPos);
        if (size == 0) {
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(3).func_177981_b(2).func_177976_e().func_177958_n(), origin.func_177964_d(3).func_177981_b(2).func_177976_e().func_177956_o(), origin.func_177964_d(3).func_177981_b(2).func_177974_f().func_177952_p(), origin.func_177964_d(3).func_177981_b(2).func_177974_f().func_177958_n(), origin.func_177964_d(3).func_177981_b(6).func_177974_f().func_177956_o(), origin.func_177964_d(3).func_177981_b(2).func_177974_f().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(3).func_177981_b(3).func_177985_f(2).func_177958_n(), origin.func_177964_d(3).func_177981_b(3).func_177985_f(2).func_177956_o(), origin.func_177964_d(3).func_177981_b(3).func_177985_f(2).func_177952_p(), origin.func_177964_d(3).func_177981_b(3).func_177985_f(2).func_177958_n(), origin.func_177964_d(3).func_177981_b(5).func_177985_f(2).func_177956_o(), origin.func_177964_d(3).func_177981_b(3).func_177985_f(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(3).func_177981_b(3).func_177965_g(2).func_177958_n(), origin.func_177964_d(3).func_177981_b(3).func_177965_g(2).func_177956_o(), origin.func_177964_d(3).func_177981_b(3).func_177965_g(2).func_177952_p(), origin.func_177964_d(3).func_177981_b(3).func_177965_g(2).func_177958_n(), origin.func_177964_d(3).func_177981_b(5).func_177965_g(2).func_177956_o(), origin.func_177964_d(3).func_177981_b(3).func_177965_g(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(3).func_177981_b(2).func_177978_c().func_177958_n(), origin.func_177965_g(3).func_177981_b(2).func_177978_c().func_177956_o(), origin.func_177965_g(3).func_177981_b(2).func_177978_c().func_177952_p(), origin.func_177965_g(3).func_177981_b(2).func_177968_d().func_177958_n(), origin.func_177965_g(3).func_177981_b(6).func_177968_d().func_177956_o(), origin.func_177965_g(3).func_177981_b(2).func_177968_d().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(3).func_177981_b(3).func_177964_d(2).func_177958_n(), origin.func_177965_g(3).func_177981_b(3).func_177964_d(2).func_177956_o(), origin.func_177965_g(3).func_177981_b(3).func_177964_d(2).func_177952_p(), origin.func_177965_g(3).func_177981_b(3).func_177964_d(2).func_177958_n(), origin.func_177965_g(3).func_177981_b(5).func_177964_d(2).func_177956_o(), origin.func_177965_g(3).func_177981_b(3).func_177964_d(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(3).func_177981_b(3).func_177970_e(2).func_177958_n(), origin.func_177965_g(3).func_177981_b(3).func_177970_e(2).func_177956_o(), origin.func_177965_g(3).func_177981_b(3).func_177970_e(2).func_177952_p(), origin.func_177965_g(3).func_177981_b(3).func_177970_e(2).func_177958_n(), origin.func_177965_g(3).func_177981_b(5).func_177970_e(2).func_177956_o(), origin.func_177965_g(3).func_177981_b(3).func_177970_e(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(3).func_177981_b(2).func_177976_e().func_177958_n(), origin.func_177970_e(3).func_177981_b(2).func_177976_e().func_177956_o(), origin.func_177970_e(3).func_177981_b(2).func_177976_e().func_177952_p(), origin.func_177970_e(3).func_177981_b(2).func_177974_f().func_177958_n(), origin.func_177970_e(3).func_177981_b(6).func_177974_f().func_177956_o(), origin.func_177970_e(3).func_177981_b(2).func_177974_f().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(3).func_177981_b(3).func_177985_f(2).func_177958_n(), origin.func_177970_e(3).func_177981_b(3).func_177985_f(2).func_177956_o(), origin.func_177970_e(3).func_177981_b(3).func_177985_f(2).func_177952_p(), origin.func_177970_e(3).func_177981_b(3).func_177985_f(2).func_177958_n(), origin.func_177970_e(3).func_177981_b(5).func_177985_f(2).func_177956_o(), origin.func_177970_e(3).func_177981_b(3).func_177985_f(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(3).func_177981_b(3).func_177965_g(2).func_177958_n(), origin.func_177970_e(3).func_177981_b(3).func_177965_g(2).func_177956_o(), origin.func_177970_e(3).func_177981_b(3).func_177965_g(2).func_177952_p(), origin.func_177970_e(3).func_177981_b(3).func_177965_g(2).func_177958_n(), origin.func_177970_e(3).func_177981_b(5).func_177965_g(2).func_177956_o(), origin.func_177970_e(3).func_177981_b(3).func_177965_g(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(3).func_177981_b(2).func_177978_c().func_177958_n(), origin.func_177985_f(3).func_177981_b(2).func_177978_c().func_177956_o(), origin.func_177985_f(3).func_177981_b(2).func_177978_c().func_177952_p(), origin.func_177985_f(3).func_177981_b(2).func_177968_d().func_177958_n(), origin.func_177985_f(3).func_177981_b(6).func_177968_d().func_177956_o(), origin.func_177985_f(3).func_177981_b(2).func_177968_d().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(3).func_177981_b(3).func_177964_d(2).func_177958_n(), origin.func_177985_f(3).func_177981_b(3).func_177964_d(2).func_177956_o(), origin.func_177985_f(3).func_177981_b(3).func_177964_d(2).func_177952_p(), origin.func_177985_f(3).func_177981_b(3).func_177964_d(2).func_177958_n(), origin.func_177985_f(3).func_177981_b(5).func_177964_d(2).func_177956_o(), origin.func_177985_f(3).func_177981_b(3).func_177964_d(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(3).func_177981_b(3).func_177970_e(2).func_177958_n(), origin.func_177985_f(3).func_177981_b(3).func_177970_e(2).func_177956_o(), origin.func_177985_f(3).func_177981_b(3).func_177970_e(2).func_177952_p(), origin.func_177985_f(3).func_177981_b(3).func_177970_e(2).func_177958_n(), origin.func_177985_f(3).func_177981_b(5).func_177970_e(2).func_177956_o(), origin.func_177985_f(3).func_177981_b(3).func_177970_e(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            this.setPoiseCluster(world, origin.func_177964_d(2).func_177981_b(2).func_177985_f(2));
            this.setPoiseCluster(world, origin.func_177964_d(2).func_177981_b(2).func_177965_g(2));
            this.setPoiseCluster(world, origin.func_177964_d(2).func_177981_b(6).func_177985_f(2));
            this.setPoiseCluster(world, origin.func_177964_d(2).func_177981_b(6).func_177965_g(2));
            this.setPoiseCluster(world, origin.func_177965_g(2).func_177981_b(2).func_177964_d(2));
            this.setPoiseCluster(world, origin.func_177965_g(2).func_177981_b(2).func_177970_e(2));
            this.setPoiseCluster(world, origin.func_177965_g(2).func_177981_b(6).func_177964_d(2));
            this.setPoiseCluster(world, origin.func_177965_g(2).func_177981_b(6).func_177970_e(2));
            this.setPoiseCluster(world, origin.func_177970_e(2).func_177981_b(2).func_177965_g(2));
            this.setPoiseCluster(world, origin.func_177970_e(2).func_177981_b(2).func_177985_f(2));
            this.setPoiseCluster(world, origin.func_177970_e(2).func_177981_b(6).func_177965_g(2));
            this.setPoiseCluster(world, origin.func_177970_e(2).func_177981_b(6).func_177985_f(2));
            this.setPoiseCluster(world, origin.func_177985_f(2).func_177981_b(2).func_177970_e(2));
            this.setPoiseCluster(world, origin.func_177985_f(2).func_177981_b(2).func_177964_d(2));
            this.setPoiseCluster(world, origin.func_177985_f(2).func_177981_b(6).func_177970_e(2));
            this.setPoiseCluster(world, origin.func_177985_f(2).func_177981_b(6).func_177964_d(2));
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177978_c().func_177985_f(2).func_177981_b(7).func_177958_n(), origin.func_177978_c().func_177985_f(2).func_177981_b(7).func_177956_o(), origin.func_177978_c().func_177985_f(2).func_177981_b(7).func_177952_p(), origin.func_177968_d().func_177965_g(2).func_177981_b(7).func_177958_n(), origin.func_177968_d().func_177965_g(2).func_177981_b(7).func_177956_o(), origin.func_177968_d().func_177965_g(2).func_177981_b(7).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            this.setPoiseCluster(world, origin.func_177964_d(2).func_177976_e().func_177981_b(7));
            this.setPoiseCluster(world, origin.func_177964_d(2).func_177981_b(7));
            this.setPoiseCluster(world, origin.func_177964_d(2).func_177974_f().func_177981_b(7));
            this.setPoiseCluster(world, origin.func_177970_e(2).func_177976_e().func_177981_b(7));
            this.setPoiseCluster(world, origin.func_177970_e(2).func_177981_b(7));
            this.setPoiseCluster(world, origin.func_177970_e(2).func_177974_f().func_177981_b(7));
        } else if (size == 1) {
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(4).func_177981_b(3).func_177976_e().func_177958_n(), origin.func_177964_d(4).func_177981_b(3).func_177976_e().func_177956_o(), origin.func_177964_d(4).func_177981_b(3).func_177974_f().func_177952_p(), origin.func_177964_d(4).func_177981_b(3).func_177974_f().func_177958_n(), origin.func_177964_d(4).func_177981_b(7).func_177974_f().func_177956_o(), origin.func_177964_d(4).func_177981_b(3).func_177974_f().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(4).func_177981_b(4).func_177985_f(2).func_177958_n(), origin.func_177964_d(4).func_177981_b(4).func_177985_f(2).func_177956_o(), origin.func_177964_d(4).func_177981_b(4).func_177985_f(2).func_177952_p(), origin.func_177964_d(4).func_177981_b(4).func_177985_f(2).func_177958_n(), origin.func_177964_d(4).func_177981_b(6).func_177985_f(2).func_177956_o(), origin.func_177964_d(4).func_177981_b(4).func_177985_f(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(4).func_177981_b(4).func_177965_g(2).func_177958_n(), origin.func_177964_d(4).func_177981_b(4).func_177965_g(2).func_177956_o(), origin.func_177964_d(4).func_177981_b(4).func_177965_g(2).func_177952_p(), origin.func_177964_d(4).func_177981_b(4).func_177965_g(2).func_177958_n(), origin.func_177964_d(4).func_177981_b(6).func_177965_g(2).func_177956_o(), origin.func_177964_d(4).func_177981_b(4).func_177965_g(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(4).func_177981_b(3).func_177978_c().func_177958_n(), origin.func_177965_g(4).func_177981_b(3).func_177978_c().func_177956_o(), origin.func_177965_g(4).func_177981_b(3).func_177978_c().func_177952_p(), origin.func_177965_g(4).func_177981_b(3).func_177968_d().func_177958_n(), origin.func_177965_g(4).func_177981_b(7).func_177968_d().func_177956_o(), origin.func_177965_g(4).func_177981_b(3).func_177968_d().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(4).func_177981_b(4).func_177964_d(2).func_177958_n(), origin.func_177965_g(4).func_177981_b(4).func_177964_d(2).func_177956_o(), origin.func_177965_g(4).func_177981_b(4).func_177964_d(2).func_177952_p(), origin.func_177965_g(4).func_177981_b(4).func_177964_d(2).func_177958_n(), origin.func_177965_g(4).func_177981_b(6).func_177964_d(2).func_177956_o(), origin.func_177965_g(4).func_177981_b(4).func_177964_d(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(4).func_177981_b(4).func_177970_e(2).func_177958_n(), origin.func_177965_g(4).func_177981_b(4).func_177970_e(2).func_177956_o(), origin.func_177965_g(4).func_177981_b(4).func_177970_e(2).func_177952_p(), origin.func_177965_g(4).func_177981_b(4).func_177970_e(2).func_177958_n(), origin.func_177965_g(4).func_177981_b(6).func_177970_e(2).func_177956_o(), origin.func_177965_g(4).func_177981_b(4).func_177970_e(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(4).func_177981_b(3).func_177976_e().func_177958_n(), origin.func_177970_e(4).func_177981_b(3).func_177976_e().func_177956_o(), origin.func_177970_e(4).func_177981_b(3).func_177976_e().func_177952_p(), origin.func_177970_e(4).func_177981_b(3).func_177974_f().func_177958_n(), origin.func_177970_e(4).func_177981_b(7).func_177974_f().func_177956_o(), origin.func_177970_e(4).func_177981_b(3).func_177974_f().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(4).func_177981_b(4).func_177985_f(2).func_177958_n(), origin.func_177970_e(4).func_177981_b(4).func_177985_f(2).func_177956_o(), origin.func_177970_e(4).func_177981_b(4).func_177985_f(2).func_177952_p(), origin.func_177970_e(4).func_177981_b(4).func_177985_f(2).func_177958_n(), origin.func_177970_e(4).func_177981_b(6).func_177985_f(2).func_177956_o(), origin.func_177970_e(4).func_177981_b(4).func_177985_f(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(4).func_177981_b(4).func_177965_g(2).func_177958_n(), origin.func_177970_e(4).func_177981_b(4).func_177965_g(2).func_177956_o(), origin.func_177970_e(4).func_177981_b(4).func_177965_g(2).func_177952_p(), origin.func_177970_e(4).func_177981_b(4).func_177965_g(2).func_177958_n(), origin.func_177970_e(4).func_177981_b(6).func_177965_g(2).func_177956_o(), origin.func_177970_e(4).func_177981_b(4).func_177965_g(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(4).func_177981_b(3).func_177978_c().func_177958_n(), origin.func_177985_f(4).func_177981_b(3).func_177978_c().func_177956_o(), origin.func_177985_f(4).func_177981_b(3).func_177978_c().func_177952_p(), origin.func_177985_f(4).func_177981_b(3).func_177968_d().func_177958_n(), origin.func_177985_f(4).func_177981_b(7).func_177968_d().func_177956_o(), origin.func_177985_f(4).func_177981_b(3).func_177968_d().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(4).func_177981_b(4).func_177964_d(2).func_177958_n(), origin.func_177985_f(4).func_177981_b(4).func_177964_d(2).func_177956_o(), origin.func_177985_f(4).func_177981_b(4).func_177964_d(2).func_177952_p(), origin.func_177985_f(4).func_177981_b(4).func_177964_d(2).func_177958_n(), origin.func_177985_f(4).func_177981_b(6).func_177964_d(2).func_177956_o(), origin.func_177985_f(4).func_177981_b(4).func_177964_d(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(4).func_177981_b(4).func_177970_e(2).func_177958_n(), origin.func_177985_f(4).func_177981_b(4).func_177970_e(2).func_177956_o(), origin.func_177985_f(4).func_177981_b(4).func_177970_e(2).func_177952_p(), origin.func_177985_f(4).func_177981_b(4).func_177970_e(2).func_177958_n(), origin.func_177985_f(4).func_177981_b(6).func_177970_e(2).func_177956_o(), origin.func_177985_f(4).func_177981_b(4).func_177970_e(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177964_d(3).func_177985_f(2));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177964_d(3).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177964_d(2).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(4).func_177964_d(3).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(5).func_177964_d(3).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(6).func_177964_d(3).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177964_d(3).func_177985_f(2));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177964_d(3).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177964_d(2).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177965_g(3).func_177964_d(2));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177965_g(3).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177965_g(2).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(4).func_177965_g(3).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(5).func_177965_g(3).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(6).func_177965_g(3).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177965_g(3).func_177964_d(2));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177965_g(3).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177965_g(2).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177970_e(3).func_177965_g(2));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177970_e(3).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177970_e(2).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(4).func_177970_e(3).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(5).func_177970_e(3).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(6).func_177970_e(3).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177970_e(3).func_177965_g(2));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177970_e(3).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177970_e(2).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177985_f(3).func_177970_e(2));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177985_f(3).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(3).func_177985_f(2).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(4).func_177985_f(3).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(5).func_177985_f(3).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(6).func_177985_f(3).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177985_f(3).func_177970_e(2));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177985_f(3).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177985_f(2).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177985_f(2).func_177970_e(2));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177970_e(2).func_177965_g(2));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177965_g(2).func_177964_d(2));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177964_d(2).func_177985_f(2));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177964_d(3).func_177976_e());
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177964_d(3).func_177974_f());
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177965_g(3).func_177978_c());
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177965_g(3).func_177968_d());
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177970_e(3).func_177974_f());
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177970_e(3).func_177976_e());
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177985_f(3).func_177968_d());
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177985_f(3).func_177978_c());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177978_c().func_177985_f(2).func_177981_b(9).func_177958_n(), origin.func_177978_c().func_177985_f(2).func_177981_b(9).func_177956_o(), origin.func_177978_c().func_177985_f(2).func_177981_b(9).func_177952_p(), origin.func_177968_d().func_177965_g(2).func_177981_b(9).func_177958_n(), origin.func_177968_d().func_177965_g(2).func_177981_b(9).func_177956_o(), origin.func_177968_d().func_177965_g(2).func_177981_b(9).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            this.setPoiseCluster(world, origin.func_177964_d(2).func_177976_e().func_177981_b(9));
            this.setPoiseCluster(world, origin.func_177964_d(2).func_177981_b(9));
            this.setPoiseCluster(world, origin.func_177964_d(2).func_177974_f().func_177981_b(9));
            this.setPoiseCluster(world, origin.func_177970_e(2).func_177976_e().func_177981_b(9));
            this.setPoiseCluster(world, origin.func_177970_e(2).func_177981_b(9));
            this.setPoiseCluster(world, origin.func_177970_e(2).func_177974_f().func_177981_b(9));
        } else {
            int z;
            int x;
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(6).func_177981_b(6).func_177976_e().func_177958_n(), origin.func_177964_d(6).func_177981_b(6).func_177976_e().func_177956_o(), origin.func_177964_d(6).func_177981_b(6).func_177976_e().func_177952_p(), origin.func_177964_d(6).func_177981_b(8).func_177974_f().func_177958_n(), origin.func_177964_d(6).func_177981_b(8).func_177976_e().func_177956_o(), origin.func_177964_d(6).func_177981_b(8).func_177976_e().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(5).func_177981_b(6).func_177985_f(3).func_177958_n(), origin.func_177964_d(5).func_177981_b(6).func_177985_f(3).func_177956_o(), origin.func_177964_d(5).func_177981_b(6).func_177985_f(3).func_177952_p(), origin.func_177964_d(5).func_177981_b(8).func_177985_f(2).func_177958_n(), origin.func_177964_d(5).func_177981_b(8).func_177985_f(2).func_177956_o(), origin.func_177964_d(5).func_177981_b(8).func_177985_f(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(5).func_177981_b(6).func_177965_g(2).func_177958_n(), origin.func_177964_d(5).func_177981_b(6).func_177965_g(2).func_177956_o(), origin.func_177964_d(5).func_177981_b(6).func_177965_g(2).func_177952_p(), origin.func_177964_d(5).func_177981_b(8).func_177965_g(3).func_177958_n(), origin.func_177964_d(5).func_177981_b(8).func_177965_g(3).func_177956_o(), origin.func_177964_d(5).func_177981_b(8).func_177965_g(3).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(5).func_177981_b(9).func_177985_f(2).func_177958_n(), origin.func_177964_d(5).func_177981_b(9).func_177985_f(2).func_177956_o(), origin.func_177964_d(5).func_177981_b(9).func_177985_f(2).func_177952_p(), origin.func_177964_d(5).func_177981_b(9).func_177965_g(2).func_177958_n(), origin.func_177964_d(5).func_177981_b(9).func_177965_g(2).func_177956_o(), origin.func_177964_d(5).func_177981_b(9).func_177965_g(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177964_d(5).func_177981_b(10).func_177976_e().func_177958_n(), origin.func_177964_d(5).func_177981_b(10).func_177976_e().func_177956_o(), origin.func_177964_d(5).func_177981_b(10).func_177976_e().func_177952_p(), origin.func_177964_d(5).func_177981_b(10).func_177974_f().func_177958_n(), origin.func_177964_d(5).func_177981_b(10).func_177974_f().func_177956_o(), origin.func_177964_d(5).func_177981_b(10).func_177974_f().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(6).func_177981_b(6).func_177978_c().func_177958_n(), origin.func_177965_g(6).func_177981_b(6).func_177978_c().func_177956_o(), origin.func_177965_g(6).func_177981_b(6).func_177978_c().func_177952_p(), origin.func_177965_g(6).func_177981_b(8).func_177968_d().func_177958_n(), origin.func_177965_g(6).func_177981_b(8).func_177968_d().func_177956_o(), origin.func_177965_g(6).func_177981_b(8).func_177968_d().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(5).func_177981_b(6).func_177964_d(3).func_177958_n(), origin.func_177965_g(5).func_177981_b(6).func_177964_d(3).func_177956_o(), origin.func_177965_g(5).func_177981_b(6).func_177964_d(3).func_177952_p(), origin.func_177965_g(5).func_177981_b(8).func_177964_d(2).func_177958_n(), origin.func_177965_g(5).func_177981_b(8).func_177964_d(2).func_177956_o(), origin.func_177965_g(5).func_177981_b(8).func_177964_d(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(5).func_177981_b(6).func_177970_e(2).func_177958_n(), origin.func_177965_g(5).func_177981_b(6).func_177970_e(2).func_177956_o(), origin.func_177965_g(5).func_177981_b(6).func_177970_e(2).func_177952_p(), origin.func_177965_g(5).func_177981_b(8).func_177970_e(3).func_177958_n(), origin.func_177965_g(5).func_177981_b(8).func_177970_e(3).func_177956_o(), origin.func_177965_g(5).func_177981_b(8).func_177970_e(3).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(5).func_177981_b(9).func_177970_e(2).func_177958_n(), origin.func_177965_g(5).func_177981_b(9).func_177964_d(2).func_177956_o(), origin.func_177965_g(5).func_177981_b(9).func_177964_d(2).func_177952_p(), origin.func_177965_g(5).func_177981_b(9).func_177970_e(2).func_177958_n(), origin.func_177965_g(5).func_177981_b(9).func_177970_e(2).func_177956_o(), origin.func_177965_g(5).func_177981_b(9).func_177970_e(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177965_g(5).func_177981_b(10).func_177978_c().func_177958_n(), origin.func_177965_g(5).func_177981_b(10).func_177978_c().func_177956_o(), origin.func_177965_g(5).func_177981_b(10).func_177978_c().func_177952_p(), origin.func_177965_g(5).func_177981_b(10).func_177968_d().func_177958_n(), origin.func_177965_g(5).func_177981_b(10).func_177968_d().func_177956_o(), origin.func_177965_g(5).func_177981_b(10).func_177968_d().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(6).func_177981_b(6).func_177976_e().func_177958_n(), origin.func_177970_e(6).func_177981_b(6).func_177976_e().func_177956_o(), origin.func_177970_e(6).func_177981_b(6).func_177976_e().func_177952_p(), origin.func_177970_e(6).func_177981_b(8).func_177974_f().func_177958_n(), origin.func_177970_e(6).func_177981_b(8).func_177974_f().func_177956_o(), origin.func_177970_e(6).func_177981_b(8).func_177974_f().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(5).func_177981_b(6).func_177985_f(3).func_177958_n(), origin.func_177970_e(5).func_177981_b(6).func_177985_f(3).func_177956_o(), origin.func_177970_e(5).func_177981_b(6).func_177985_f(3).func_177952_p(), origin.func_177970_e(5).func_177981_b(8).func_177985_f(2).func_177958_n(), origin.func_177970_e(5).func_177981_b(8).func_177964_d(2).func_177956_o(), origin.func_177970_e(5).func_177981_b(8).func_177985_f(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(5).func_177981_b(6).func_177965_g(2).func_177958_n(), origin.func_177970_e(5).func_177981_b(6).func_177965_g(2).func_177956_o(), origin.func_177970_e(5).func_177981_b(6).func_177965_g(2).func_177952_p(), origin.func_177970_e(5).func_177981_b(8).func_177965_g(3).func_177958_n(), origin.func_177970_e(5).func_177981_b(8).func_177965_g(3).func_177956_o(), origin.func_177970_e(5).func_177981_b(8).func_177965_g(3).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(5).func_177981_b(9).func_177985_f(2).func_177958_n(), origin.func_177970_e(5).func_177981_b(9).func_177985_f(2).func_177956_o(), origin.func_177970_e(5).func_177981_b(9).func_177985_f(2).func_177952_p(), origin.func_177970_e(5).func_177981_b(9).func_177965_g(2).func_177958_n(), origin.func_177970_e(5).func_177981_b(9).func_177965_g(2).func_177956_o(), origin.func_177970_e(5).func_177981_b(9).func_177965_g(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177970_e(5).func_177981_b(10).func_177976_e().func_177958_n(), origin.func_177970_e(5).func_177981_b(10).func_177976_e().func_177956_o(), origin.func_177970_e(5).func_177981_b(10).func_177976_e().func_177952_p(), origin.func_177970_e(5).func_177981_b(10).func_177974_f().func_177958_n(), origin.func_177970_e(5).func_177981_b(10).func_177974_f().func_177956_o(), origin.func_177970_e(5).func_177981_b(10).func_177974_f().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(6).func_177981_b(6).func_177978_c().func_177958_n(), origin.func_177985_f(6).func_177981_b(6).func_177978_c().func_177956_o(), origin.func_177985_f(6).func_177981_b(6).func_177978_c().func_177952_p(), origin.func_177985_f(6).func_177981_b(8).func_177968_d().func_177958_n(), origin.func_177985_f(6).func_177981_b(8).func_177968_d().func_177956_o(), origin.func_177985_f(6).func_177981_b(8).func_177968_d().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(5).func_177981_b(6).func_177964_d(3).func_177958_n(), origin.func_177985_f(5).func_177981_b(6).func_177964_d(3).func_177956_o(), origin.func_177985_f(5).func_177981_b(6).func_177964_d(3).func_177952_p(), origin.func_177985_f(5).func_177981_b(8).func_177964_d(2).func_177958_n(), origin.func_177985_f(5).func_177981_b(8).func_177964_d(2).func_177956_o(), origin.func_177985_f(5).func_177981_b(8).func_177964_d(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(5).func_177981_b(6).func_177970_e(2).func_177958_n(), origin.func_177985_f(5).func_177981_b(6).func_177970_e(2).func_177956_o(), origin.func_177985_f(5).func_177981_b(6).func_177970_e(2).func_177952_p(), origin.func_177985_f(5).func_177981_b(8).func_177970_e(3).func_177958_n(), origin.func_177985_f(5).func_177981_b(8).func_177970_e(3).func_177956_o(), origin.func_177985_f(5).func_177981_b(8).func_177970_e(3).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(5).func_177981_b(9).func_177964_d(2).func_177958_n(), origin.func_177985_f(5).func_177981_b(9).func_177964_d(2).func_177956_o(), origin.func_177985_f(5).func_177981_b(9).func_177964_d(2).func_177952_p(), origin.func_177985_f(5).func_177981_b(9).func_177970_e(2).func_177958_n(), origin.func_177985_f(5).func_177981_b(9).func_177970_e(2).func_177956_o(), origin.func_177985_f(5).func_177981_b(9).func_177970_e(2).func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            GenerationUtils.fillAreaWithBlockCube(world, origin.func_177985_f(5).func_177981_b(10).func_177978_c().func_177958_n(), origin.func_177985_f(5).func_177981_b(10).func_177978_c().func_177956_o(), origin.func_177985_f(5).func_177981_b(10).func_177978_c().func_177952_p(), origin.func_177985_f(5).func_177981_b(10).func_177968_d().func_177958_n(), origin.func_177985_f(5).func_177981_b(10).func_177968_d().func_177956_o(), origin.func_177985_f(5).func_177981_b(10).func_177968_d().func_177952_p(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
            this.setPoiseCluster(world, origin.func_177981_b(6).func_177964_d(4).func_177985_f(4));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177964_d(4).func_177985_f(4));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177964_d(4).func_177985_f(4));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177964_d(4).func_177985_f(4));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177964_d(4).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177964_d(4).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177964_d(4).func_177985_f(2));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177964_d(3).func_177985_f(4));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177964_d(3).func_177985_f(4));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177964_d(2).func_177985_f(4));
            this.setPoiseCluster(world, origin.func_177981_b(6).func_177965_g(4).func_177964_d(4));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177965_g(4).func_177964_d(4));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177965_g(4).func_177964_d(4));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177965_g(4).func_177964_d(4));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177965_g(4).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177965_g(4).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177965_g(4).func_177964_d(2));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177965_g(3).func_177964_d(4));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177965_g(3).func_177964_d(4));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177965_g(2).func_177964_d(4));
            this.setPoiseCluster(world, origin.func_177981_b(6).func_177970_e(4).func_177965_g(4));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177970_e(4).func_177965_g(4));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177970_e(4).func_177965_g(4));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177970_e(4).func_177965_g(4));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177970_e(4).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177970_e(4).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177970_e(4).func_177965_g(2));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177970_e(3).func_177965_g(4));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177970_e(3).func_177965_g(4));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177970_e(2).func_177965_g(4));
            this.setPoiseCluster(world, origin.func_177981_b(6).func_177985_f(4).func_177970_e(4));
            this.setPoiseCluster(world, origin.func_177981_b(7).func_177985_f(4).func_177970_e(4));
            this.setPoiseCluster(world, origin.func_177981_b(8).func_177985_f(4).func_177970_e(4));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177985_f(4).func_177970_e(4));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177985_f(4).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177985_f(4).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177985_f(4).func_177970_e(2));
            this.setPoiseCluster(world, origin.func_177981_b(9).func_177985_f(3).func_177970_e(4));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177985_f(3).func_177970_e(4));
            this.setPoiseCluster(world, origin.func_177981_b(10).func_177985_f(2).func_177970_e(4));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177964_d(3).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177964_d(2).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177964_d(2).func_177985_f(4));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177964_d(3).func_177985_f(2));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177964_d(4).func_177985_f(2));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177964_d(4).func_177976_e());
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177964_d(4));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177964_d(4).func_177974_f());
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177965_g(3).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177965_g(2).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177965_g(2).func_177964_d(4));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177965_g(3).func_177964_d(2));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177965_g(4).func_177964_d(2));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177965_g(4).func_177978_c());
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177965_g(4));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177965_g(4).func_177968_d());
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177970_e(3).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177970_e(2).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177970_e(2).func_177965_g(4));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177970_e(3).func_177965_g(2));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177970_e(4).func_177965_g(2));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177970_e(4).func_177974_f());
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177970_e(4));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177970_e(4).func_177976_e());
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177985_f(3).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177985_f(2).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177985_f(2).func_177970_e(4));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177985_f(3).func_177970_e(2));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177985_f(4).func_177970_e(2));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177985_f(4).func_177968_d());
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177985_f(4));
            this.setPoiseCluster(world, origin.func_177981_b(11).func_177985_f(4).func_177978_c());
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177964_d(3).func_177976_e());
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177964_d(3));
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177964_d(3).func_177974_f());
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177965_g(3).func_177978_c());
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177965_g(3));
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177965_g(3).func_177968_d());
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177970_e(3).func_177974_f());
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177970_e(3));
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177970_e(3).func_177976_e());
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177985_f(3).func_177978_c());
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177985_f(3));
            this.setPoiseCluster(world, origin.func_177981_b(12).func_177985_f(3).func_177968_d());
            for (x = origin.func_177958_n() - 1; x <= origin.func_177958_n() + 1; ++x) {
                for (z = origin.func_177952_p() - 1; z <= origin.func_177952_p() + 1; ++z) {
                    this.setPoiseCluster(world, new BlockPos(x, origin.func_177981_b(13).func_177956_o(), z));
                }
            }
            for (x = origin.func_177958_n() - 2; x <= origin.func_177958_n() + 2; ++x) {
                for (z = origin.func_177952_p() - 2; z <= origin.func_177952_p() + 2; ++z) {
                    if (x != origin.func_177958_n() + 2 && z != origin.func_177952_p() + 2 && x != origin.func_177958_n() - 2 && z != origin.func_177952_p() - 2) continue;
                    this.setPoiseCluster(world, new BlockPos(x, origin.func_177981_b(12).func_177956_o(), z));
                }
            }
        }
    }

    private void tryToBuildBranch(IWorld world, BlockPos pos, Random rand, int treeHeight) {
        int[] branchLengths = new int[]{rand.nextInt(3) + 1, rand.nextInt(3) + 1, 1, 1};
        int[] branchHeights = new int[]{1, 1, rand.nextInt(4) + 1, rand.nextInt(4) + 4};
        Direction randDir = Direction.func_82600_a((int)(rand.nextInt(4) + 2));
        int pickedHeight = rand.nextInt((int)Math.ceil(treeHeight / 3)) + 6;
        BlockPos pickedPosition = pos.func_177972_a(randDir).func_177981_b(pickedHeight);
        if (world.func_180495_p(pickedPosition).func_185904_a().func_76222_j() && treeHeight > 15 && this.isViableBranchArea(world, pickedPosition, randDir, 2 + branchLengths[0] + branchLengths[1], pickedPosition.func_177967_a(randDir, branchLengths[0] + branchLengths[1] + branchLengths[2] + branchLengths[3]).func_177981_b(3 + branchHeights[2]).func_177981_b(branchHeights[3]))) {
            int y;
            int dir;
            this.setPoiseLog(world, pickedPosition, rand, false, true);
            this.setPoiseLog(world, pickedPosition.func_177984_a(), rand, false, true);
            this.setPoiseLog(world, pickedPosition.func_177977_b(), rand, false, true);
            for (dir = 0; dir <= branchLengths[0]; ++dir) {
                this.setPoiseLogWithDirection(world, pickedPosition.func_177967_a(randDir, dir), rand, randDir);
                if (dir != branchLengths[0]) continue;
                this.setPoiseLog(world, pickedPosition.func_177967_a(randDir, dir).func_177984_a(), rand, false, true);
            }
            for (dir = 1; dir <= branchLengths[1]; ++dir) {
                this.setPoiseLogWithDirection(world, pickedPosition.func_177967_a(randDir, dir + branchLengths[0]).func_177984_a(), rand, randDir);
                if (dir != branchLengths[1]) continue;
                this.setPoiseLog(world, pickedPosition.func_177967_a(randDir, branchLengths[0] + branchLengths[1]).func_177981_b(2), rand, false, true);
            }
            for (dir = 1; dir <= branchLengths[2]; ++dir) {
                this.setPoiseLogWithDirection(world, pickedPosition.func_177967_a(randDir, dir + branchLengths[0] + branchLengths[1]).func_177981_b(2), rand, randDir);
                if (dir != branchLengths[2]) continue;
                for (y = 0; y < branchHeights[2]; ++y) {
                    this.setPoiseLog(world, pickedPosition.func_177967_a(randDir, branchLengths[0] + branchLengths[1] + branchLengths[2]).func_177981_b(3).func_177981_b(y), rand, false, false);
                }
            }
            for (dir = 1; dir <= branchLengths[3]; ++dir) {
                this.setPoiseLogWithDirection(world, pickedPosition.func_177967_a(randDir, dir + branchLengths[0] + branchLengths[1] + branchLengths[2]).func_177981_b(2 + branchHeights[2]), rand, randDir);
                if (dir != branchLengths[3]) continue;
                for (y = 0; y < branchHeights[3]; ++y) {
                    this.setPoiseLog(world, pickedPosition.func_177967_a(randDir, branchLengths[0] + branchLengths[1] + branchLengths[2] + branchLengths[3]).func_177981_b(3 + branchHeights[2]).func_177981_b(y), rand, false, false);
                }
            }
            this.buildTreeTop(world, pickedPosition.func_177967_a(randDir, branchLengths[0] + branchLengths[1] + branchLengths[2] + branchLengths[3]).func_177981_b(3 + branchHeights[2]).func_177981_b(branchHeights[3]), rand, 0, 0);
        }
    }

    private void buildSideBubble(IWorld world, BlockPos pos, Random rand) {
        int variant = rand.nextInt(100);
        if (variant >= 49) {
            Direction randDir = Direction.func_82600_a((int)(rand.nextInt(4) + 2));
            this.setPoiseCluster(world, pos.func_177972_a(randDir));
        } else if (variant <= 15) {
            world.func_180501_a(pos.func_177984_a(), this.GLOWING_POISE_LOG.get(), 2);
            this.setPoiseCluster(world, pos.func_177978_c());
            this.setPoiseCluster(world, pos.func_177974_f());
            this.setPoiseCluster(world, pos.func_177968_d());
            this.setPoiseCluster(world, pos.func_177976_e());
            this.setPoiseCluster(world, pos.func_177978_c().func_177984_a());
            this.setPoiseCluster(world, pos.func_177974_f().func_177984_a());
            this.setPoiseCluster(world, pos.func_177968_d().func_177984_a());
            this.setPoiseCluster(world, pos.func_177976_e().func_177984_a());
        } else if (variant >= 16) {
            Direction randDir = Direction.func_82600_a((int)(rand.nextInt(4) + 2));
            if (randDir == Direction.NORTH) {
                world.func_180501_a(pos.func_177984_a(), this.GLOWING_POISE_LOG.get(), 2);
                this.setPoiseCluster(world, pos.func_177978_c());
                this.setPoiseCluster(world, pos.func_177978_c().func_177974_f());
                this.setPoiseCluster(world, pos.func_177974_f());
                this.setPoiseCluster(world, pos.func_177978_c().func_177984_a());
                this.setPoiseCluster(world, pos.func_177978_c().func_177974_f().func_177984_a());
                this.setPoiseCluster(world, pos.func_177974_f().func_177984_a());
            } else if (randDir == Direction.EAST) {
                world.func_180501_a(pos.func_177984_a(), this.GLOWING_POISE_LOG.get(), 2);
                this.setPoiseCluster(world, pos.func_177974_f());
                this.setPoiseCluster(world, pos.func_177974_f().func_177968_d());
                this.setPoiseCluster(world, pos.func_177968_d());
                this.setPoiseCluster(world, pos.func_177974_f().func_177984_a());
                this.setPoiseCluster(world, pos.func_177974_f().func_177968_d().func_177984_a());
                this.setPoiseCluster(world, pos.func_177968_d().func_177984_a());
            } else if (randDir == Direction.SOUTH) {
                world.func_180501_a(pos.func_177984_a(), this.GLOWING_POISE_LOG.get(), 2);
                this.setPoiseCluster(world, pos.func_177968_d());
                this.setPoiseCluster(world, pos.func_177968_d().func_177976_e());
                this.setPoiseCluster(world, pos.func_177976_e());
                this.setPoiseCluster(world, pos.func_177968_d().func_177984_a());
                this.setPoiseCluster(world, pos.func_177968_d().func_177976_e().func_177984_a());
                this.setPoiseCluster(world, pos.func_177976_e().func_177984_a());
            } else if (randDir == Direction.WEST) {
                world.func_180501_a(pos.func_177984_a(), this.GLOWING_POISE_LOG.get(), 2);
                this.setPoiseCluster(world, pos.func_177976_e());
                this.setPoiseCluster(world, pos.func_177976_e().func_177978_c());
                this.setPoiseCluster(world, pos.func_177978_c());
                this.setPoiseCluster(world, pos.func_177976_e().func_177984_a());
                this.setPoiseCluster(world, pos.func_177976_e().func_177978_c().func_177984_a());
                this.setPoiseCluster(world, pos.func_177978_c().func_177984_a());
            }
        } else if (variant >= 30) {
            Direction randDir = Direction.func_82600_a((int)(rand.nextInt(4) + 2));
            if (randDir == Direction.NORTH) {
                world.func_180501_a(pos.func_177984_a(), this.GLOWING_POISE_LOG.get(), 2);
                this.setPoiseCluster(world, pos.func_177978_c());
                this.setPoiseCluster(world, pos.func_177978_c().func_177976_e());
                this.setPoiseCluster(world, pos.func_177964_d(2).func_177976_e());
                this.setPoiseCluster(world, pos.func_177978_c().func_177976_e().func_177984_a());
                this.setPoiseCluster(world, pos.func_177978_c().func_177976_e().func_177977_b());
                this.setPoiseCluster(world, pos.func_177978_c().func_177985_f(2));
                this.setPoiseCluster(world, pos.func_177976_e());
            } else if (randDir == Direction.EAST) {
                world.func_180501_a(pos.func_177984_a(), this.GLOWING_POISE_LOG.get(), 2);
                this.setPoiseCluster(world, pos.func_177974_f());
                this.setPoiseCluster(world, pos.func_177974_f().func_177978_c());
                this.setPoiseCluster(world, pos.func_177965_g(2).func_177978_c());
                this.setPoiseCluster(world, pos.func_177974_f().func_177978_c().func_177984_a());
                this.setPoiseCluster(world, pos.func_177974_f().func_177978_c().func_177977_b());
                this.setPoiseCluster(world, pos.func_177974_f().func_177964_d(2));
                this.setPoiseCluster(world, pos.func_177978_c());
            } else if (randDir == Direction.SOUTH) {
                world.func_180501_a(pos.func_177984_a(), this.GLOWING_POISE_LOG.get(), 2);
                this.setPoiseCluster(world, pos.func_177968_d());
                this.setPoiseCluster(world, pos.func_177968_d().func_177974_f());
                this.setPoiseCluster(world, pos.func_177970_e(2).func_177974_f());
                this.setPoiseCluster(world, pos.func_177968_d().func_177974_f().func_177984_a());
                this.setPoiseCluster(world, pos.func_177968_d().func_177974_f().func_177977_b());
                this.setPoiseCluster(world, pos.func_177968_d().func_177965_g(2));
                this.setPoiseCluster(world, pos.func_177974_f());
            } else if (randDir == Direction.WEST) {
                world.func_180501_a(pos.func_177984_a(), this.GLOWING_POISE_LOG.get(), 2);
                this.setPoiseCluster(world, pos.func_177976_e());
                this.setPoiseCluster(world, pos.func_177976_e().func_177968_d());
                this.setPoiseCluster(world, pos.func_177985_f(2).func_177968_d());
                this.setPoiseCluster(world, pos.func_177976_e().func_177968_d().func_177984_a());
                this.setPoiseCluster(world, pos.func_177976_e().func_177968_d().func_177977_b());
                this.setPoiseCluster(world, pos.func_177976_e().func_177970_e(2));
                this.setPoiseCluster(world, pos.func_177968_d());
            }
        }
    }

    public void buildPoismossCircle(IWorld world, IWorldGenerationReader reader, Random random, BlockPos pos) {
        this.placePoismossCircle(world, reader, pos.func_177976_e().func_177978_c());
        this.placePoismossCircle(world, reader, pos.func_177965_g(2).func_177978_c());
        this.placePoismossCircle(world, reader, pos.func_177976_e().func_177970_e(2));
        this.placePoismossCircle(world, reader, pos.func_177965_g(2).func_177970_e(2));
        for (int i = 0; i < 5; ++i) {
            int j = random.nextInt(64);
            int k = j % 8;
            int l = j / 8;
            if (k != 0 && k != 7 && l != 0 && l != 7) continue;
            this.placePoismossCircle(world, reader, pos.func_177982_a(-3 + k, 0, -3 + l));
        }
    }

    private void placePoismossCircle(IWorld world, IWorldGenerationReader reader, BlockPos center) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placePoismossAt(world, reader, center.func_177982_a(i, 0, j));
            }
        }
    }

    private void placePoismossAt(IWorld world, IWorldGenerationReader reader, BlockPos pos) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pos.func_177981_b(i);
            if (world.func_180495_p(blockpos).func_177230_c() == EEBlocks.EUMUS.get() || world.func_180495_p(blockpos).func_177230_c() == Blocks.field_150377_bs) {
                BlockState newGround = world.func_180495_p(blockpos).func_177230_c() == EEBlocks.EUMUS.get() ? this.POISMOSS_EUMUS.get() : ((PoismossBlock)EEBlocks.POISMOSS.get()).func_176223_P();
                this.func_202278_a((IWorldWriter)reader, blockpos, newGround);
                break;
            }
            if (!GenerationUtils.isAir((IWorldGenerationBaseReader)reader, blockpos) && i < 0) break;
        }
    }

    private void placeInnerDomeFeatures(IWorld world, Random rand, BlockPos pos) {
        BlockPos blockpos;
        int x;
        if ((double)rand.nextFloat() > 0.75) {
            return;
        }
        for (x = 0; x < 128; ++x) {
            blockpos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!world.func_175623_d(blockpos) || !((PoiseBushBlock)EEBlocks.POISE_BUSH.get()).func_176223_P().func_196955_c((IWorldReader)world, blockpos)) continue;
            world.func_180501_a(blockpos, ((PoiseBushBlock)EEBlocks.POISE_BUSH.get()).func_176223_P(), 2);
        }
        for (x = 0; x < 128; ++x) {
            blockpos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!(rand.nextFloat() <= 0.45f) || !world.func_175623_d(blockpos) || !world.func_175623_d(blockpos.func_177984_a()) || !((PoiseTallBushBlock)EEBlocks.POISE_BUSH_TALL.get()).func_176223_P().func_196955_c((IWorldReader)world, blockpos)) continue;
            ((PoiseTallBushBlock)EEBlocks.POISE_BUSH_TALL.get()).placeAt(world, blockpos, 2);
        }
        for (x = 0; x < 4; ++x) {
            BlockPos randPos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!world.func_175623_d(randPos) && world.func_180495_p(randPos).func_177230_c() != EEBlocks.POISE_BUSH.get() || !((BolloomBudBlock)EEBlocks.BOLLOOM_BUD.get()).func_176223_P().func_196955_c((IWorldReader)world, randPos)) continue;
            world.func_180501_a(randPos, ((BolloomBudBlock)EEBlocks.BOLLOOM_BUD.get()).func_176223_P(), 2);
        }
    }

    public boolean canFitBud(IWorld world, BlockPos pos) {
        for (int y = pos.func_177956_o(); y < pos.func_177956_o() + 5; ++y) {
            for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 1; ++x) {
                for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 1; ++z) {
                    BlockPos newPos = new BlockPos(x, y, z);
                    if (newPos == pos || world.func_175623_d(newPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void setPoiseLog(IWorld world, BlockPos pos, Random rand, boolean isTreeBase, boolean noBubbles) {
        BlockState logState;
        BlockState blockState = logState = rand.nextFloat() <= 0.11f ? this.GLOWING_POISE_LOG.get() : this.POISE_LOG.get();
        if (world.func_180495_p(pos).func_185904_a().func_76222_j() || world.func_180495_p(pos).func_177230_c() == EEBlocks.POISE_CLUSTER.get()) {
            world.func_180501_a(pos, logState, 2);
            if (!noBubbles && logState == this.GLOWING_POISE_LOG.get()) {
                if (!isTreeBase) {
                    boolean willCollide;
                    boolean bl = willCollide = world.func_180495_p(pos.func_177977_b()).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get() || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get() || world.func_180495_p(pos.func_177979_c(3)).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get() || world.func_180495_p(pos.func_177984_a()).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get() || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get() || world.func_180495_p(pos.func_177981_b(3)).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get();
                    if (rand.nextFloat() <= 0.7f && !willCollide && world.func_180495_p(pos.func_177978_c()).func_185904_a().func_76222_j() && world.func_180495_p(pos.func_177974_f()).func_185904_a().func_76222_j() && world.func_180495_p(pos.func_177968_d()).func_185904_a().func_76222_j() && world.func_180495_p(pos.func_177976_e()).func_185904_a().func_76222_j()) {
                        this.buildSideBubble(world, pos, rand);
                    }
                } else {
                    boolean willCollide;
                    boolean bl = willCollide = world.func_180495_p(pos.func_177977_b()).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get() || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get() || world.func_180495_p(pos.func_177979_c(3)).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get() || world.func_180495_p(pos.func_177984_a()).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get() || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get() || world.func_180495_p(pos.func_177981_b(3)).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get();
                    if (rand.nextFloat() <= 0.4f && !willCollide) {
                        this.buildSideBubble(world, pos, rand);
                    }
                }
            }
        }
    }

    private void setPoiseLogWithDirection(IWorld world, BlockPos pos, Random rand, Direction direction) {
        BlockState logState;
        BlockState blockState = logState = rand.nextFloat() <= 0.9f ? (BlockState)this.POISE_LOG.get().func_206870_a((IProperty)GlowingPoiseLogBlock.field_176298_M, (Comparable)direction.func_176740_k()) : (BlockState)this.GLOWING_POISE_LOG.get().func_206870_a((IProperty)GlowingPoiseLogBlock.field_176298_M, (Comparable)direction.func_176740_k());
        if (world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos, logState, 2);
        }
    }

    private void setPoiseCluster(IWorld world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos, ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P(), 2);
        }
    }

    private boolean isViableBranchArea(IWorld world, BlockPos pos, Direction direction, int directionLength, BlockPos topPosition) {
        int y = topPosition.func_177956_o() - pos.func_177956_o();
        return direction == Direction.NORTH ? GenerationUtils.isAreaReplacable(world, pos.func_177977_b().func_177976_e().func_177964_d(directionLength).func_177958_n(), pos.func_177977_b().func_177976_e().func_177964_d(directionLength).func_177956_o(), pos.func_177977_b().func_177976_e().func_177964_d(directionLength).func_177952_p(), pos.func_177981_b(y).func_177974_f().func_177958_n(), pos.func_177981_b(y).func_177974_f().func_177956_o(), pos.func_177981_b(y).func_177974_f().func_177952_p()) && GenerationUtils.isAreaReplacable(world, topPosition.func_177964_d(3).func_177985_f(3).func_177958_n(), topPosition.func_177964_d(3).func_177985_f(3).func_177956_o(), topPosition.func_177964_d(3).func_177985_f(3).func_177952_p(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177958_n(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177956_o(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177952_p()) : (direction == Direction.EAST ? GenerationUtils.isAreaReplacable(world, pos.func_177977_b().func_177978_c().func_177965_g(directionLength).func_177958_n(), pos.func_177977_b().func_177978_c().func_177965_g(directionLength).func_177956_o(), pos.func_177977_b().func_177978_c().func_177965_g(directionLength).func_177952_p(), pos.func_177981_b(y).func_177976_e().func_177958_n(), pos.func_177981_b(y).func_177976_e().func_177956_o(), pos.func_177981_b(y).func_177976_e().func_177952_p()) && GenerationUtils.isAreaReplacable(world, topPosition.func_177964_d(3).func_177985_f(3).func_177958_n(), topPosition.func_177964_d(3).func_177985_f(3).func_177956_o(), topPosition.func_177964_d(3).func_177985_f(3).func_177952_p(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177958_n(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177956_o(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177952_p()) : (direction == Direction.SOUTH ? GenerationUtils.isAreaReplacable(world, pos.func_177977_b().func_177976_e().func_177958_n(), pos.func_177977_b().func_177976_e().func_177956_o(), pos.func_177977_b().func_177976_e().func_177952_p(), pos.func_177981_b(y).func_177974_f().func_177970_e(directionLength).func_177958_n(), pos.func_177981_b(y).func_177974_f().func_177970_e(directionLength).func_177956_o(), pos.func_177981_b(y).func_177974_f().func_177970_e(directionLength).func_177952_p()) && GenerationUtils.isAreaReplacable(world, topPosition.func_177964_d(3).func_177985_f(3).func_177958_n(), topPosition.func_177964_d(3).func_177985_f(3).func_177956_o(), topPosition.func_177964_d(3).func_177985_f(3).func_177952_p(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177958_n(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177956_o(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177952_p()) : GenerationUtils.isAreaReplacable(world, pos.func_177977_b().func_177978_c().func_177958_n(), pos.func_177977_b().func_177978_c().func_177956_o(), pos.func_177977_b().func_177978_c().func_177952_p(), pos.func_177981_b(y).func_177968_d().func_177985_f(directionLength).func_177958_n(), pos.func_177981_b(y).func_177968_d().func_177985_f(directionLength).func_177956_o(), pos.func_177981_b(y).func_177968_d().func_177985_f(directionLength).func_177952_p()) && GenerationUtils.isAreaReplacable(world, topPosition.func_177964_d(3).func_177985_f(3).func_177958_n(), topPosition.func_177964_d(3).func_177985_f(3).func_177956_o(), topPosition.func_177964_d(3).func_177985_f(3).func_177952_p(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177958_n(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177956_o(), topPosition.func_177970_e(3).func_177965_g(3).func_177981_b(7).func_177952_p())));
    }

    public boolean isAreaOpen(IWorld world, BlockPos pos) {
        for (int y = pos.func_177956_o(); y < pos.func_177956_o() + 1; ++y) {
            for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 2; ++x) {
                for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 2; ++z) {
                    if (world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().func_76222_j()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isValidGround(IWorld world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_150377_bs.getBlock() || block.func_203417_a(EETags.Blocks.END_PLANTABLE) || block.func_203417_a(EETags.Blocks.POISE_PLANTABLE);
    }
}

