/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.world.features.corrock;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.abnormals_core.core.library.GenerationPiece;
import endergeticexpansion.api.util.GenerationUtils;
import endergeticexpansion.common.blocks.CorrockCrownWallBlock;
import endergeticexpansion.common.world.features.corrock.AbstractCorrockFeature;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class CorrockTowerFeature
extends AbstractCorrockFeature {
    public CorrockTowerFeature(Function<Dynamic<?>, ? extends ProbabilityConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, ProbabilityConfig config) {
        Block belowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (world.func_175623_d(pos) && belowBlock == EEBlocks.CORROCK_END_BLOCK.get()) {
            GenerationPiece base;
            float chance = rand.nextFloat();
            if (chance > 0.5f) {
                GenerationPiece base2 = new GenerationPiece((w, p) -> w.func_175623_d(p.pos));
                this.fillUp(base2, pos, 3);
                if (!base2.canPlace(world)) {
                    return false;
                }
                BlockPos downPos = pos.func_177979_c(2);
                if (GenerationUtils.isAreaCompletelySolid(world, downPos.func_177958_n() - 1, downPos.func_177956_o(), downPos.func_177952_p() - 1, downPos.func_177958_n() + 1, downPos.func_177956_o(), downPos.func_177952_p() + 1)) {
                    for (int x = downPos.func_177958_n() - 1; x <= downPos.func_177958_n() + 1; ++x) {
                        for (int y = downPos.func_177956_o(); y <= downPos.func_177956_o() + 1; ++y) {
                            for (int z = downPos.func_177952_p() - 1; z <= downPos.func_177952_p() + 1; ++z) {
                                BlockPos currentPos = new BlockPos(x, y, z);
                                if (!world.func_175623_d(currentPos)) continue;
                                base2.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), currentPos);
                            }
                        }
                    }
                } else {
                    return false;
                }
                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                    BlockPos offset = pos.func_177972_a(horizontal);
                    BlockPos doubleOffset = pos.func_177967_a(horizontal, 2);
                    this.fillUp(base2, offset, 3);
                    if (rand.nextFloat() < 0.5f) {
                        base2.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), offset.func_177972_a(horizontal.func_176746_e()));
                    }
                    if (rand.nextFloat() < 0.5f) {
                        base2.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), offset.func_177972_a(horizontal.func_176735_f()));
                    }
                    if (rand.nextFloat() < 0.5f) {
                        base2.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), offset.func_177981_b(2).func_177972_a(horizontal.func_176746_e()));
                    }
                    if (rand.nextFloat() < 0.5f) {
                        base2.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), offset.func_177981_b(2).func_177972_a(horizontal.func_176735_f()));
                    }
                    if (rand.nextFloat() < 0.5f) {
                        base2.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), doubleOffset);
                    }
                    if (!(rand.nextFloat() < 0.5f)) continue;
                    base2.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), doubleOffset.func_177981_b(2));
                }
                boolean xOrz = rand.nextBoolean();
                int x = xOrz ? rand.nextInt(2) : 0;
                int z = !xOrz ? rand.nextInt(2) : 0;
                Pair<GenerationPiece, List<AbstractCorrockFeature.ChorusPlantPart>> topPiece = this.getMediumTop(world, pos.func_177982_a(x, 0, z).func_177981_b(4), rand);
                if (base2.canPlace(world) && ((GenerationPiece)topPiece.getFirst()).canPlace(world)) {
                    base2.place(world);
                    ((GenerationPiece)topPiece.getFirst()).place(world);
                    ((List)topPiece.getSecond()).forEach(growth -> growth.placeGrowth(world, rand));
                    return true;
                }
            } else if (chance < 0.5f && (base = this.getSmallBase(world, pos, rand)) != null) {
                GenerationPiece topPiece = new GenerationPiece((w, p) -> w.func_175623_d(p.pos));
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        BlockPos placingPos = pos.func_177982_a(x, 1, z);
                        topPiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), placingPos);
                        if (!(rand.nextFloat() < 0.25f)) continue;
                        topPiece.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), placingPos.func_177984_a());
                    }
                }
                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                    BlockPos sidePos = pos.func_177981_b(2).func_177967_a(horizontal, 2);
                    BlockPos rightPos = sidePos.func_177972_a(horizontal.func_176746_e());
                    BlockPos leftPos = sidePos.func_177972_a(horizontal.func_176735_f());
                    topPiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), sidePos);
                    if (rand.nextFloat() < 0.3f) {
                        topPiece.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), sidePos.func_177984_a());
                    }
                    topPiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), rightPos);
                    if (rand.nextFloat() < 0.3f) {
                        topPiece.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), rightPos.func_177984_a());
                    }
                    topPiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), leftPos);
                    if (!(rand.nextFloat() < 0.3f)) continue;
                    topPiece.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), leftPos.func_177984_a());
                }
                if (topPiece.canPlace(world)) {
                    base.place(world);
                    topPiece.place(world);
                    world.func_180501_a(pos, (BlockState)this.CORROCK_BLOCK.get(), 2);
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private GenerationPiece getSmallBase(IWorld world, BlockPos pos, Random rand) {
        int successfulSides = 0;
        GenerationPiece piece = new GenerationPiece((w, p) -> w.func_175623_d(p.pos) && Block.func_220056_d((BlockState)w.func_180495_p(p.pos.func_177977_b()), (IBlockReader)w, (BlockPos)p.pos.func_177977_b(), (Direction)Direction.UP));
        for (Direction horizontal : Direction.Plane.HORIZONTAL) {
            BlockPos offset;
            int length = 0;
            for (int i = 1; i < 3 && world.func_175623_d(offset = pos.func_177967_a(horizontal, i)) && Block.func_220056_d((BlockState)world.func_180495_p(offset.func_177977_b()), (IBlockReader)world, (BlockPos)offset.func_177977_b(), (Direction)Direction.UP); ++i) {
                ++length;
            }
            if (length <= 0) continue;
            for (int i2 = 1; i2 < length + 1; ++i2) {
                piece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), pos.func_177967_a(horizontal, i2));
            }
            ++successfulSides;
        }
        return successfulSides >= 2 ? piece : null;
    }

    private Pair<GenerationPiece, List<AbstractCorrockFeature.ChorusPlantPart>> getMediumTop(IWorld world, BlockPos pos, Random rand) {
        GenerationPiece top = new GenerationPiece((w, p) -> w.func_175623_d(p.pos));
        ArrayList growths = Lists.newArrayList();
        ArrayList corners = Lists.newArrayList();
        int variant = rand.nextInt(4);
        BlockPos startNPos = pos.func_177967_a(Direction.NORTH, 4).func_177982_a(-2, 0, 0);
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startNPos.func_177982_a(i, 0, 0);
            top.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), placePos);
            if (!(rand.nextFloat() < 0.5f)) continue;
            if (rand.nextBoolean()) {
                top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.NORTH), placePos.func_177972_a(Direction.NORTH));
                continue;
            }
            top.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), placePos.func_177984_a());
        }
        BlockPos startEPos = pos.func_177967_a(Direction.EAST, 3).func_177982_a(0, 0, 1);
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startEPos.func_177982_a(0, 0, -i);
            top.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), placePos);
            if (!(rand.nextFloat() < 0.5f)) continue;
            if (rand.nextBoolean()) {
                top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.EAST), placePos.func_177972_a(Direction.EAST));
                continue;
            }
            top.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), placePos.func_177984_a());
        }
        BlockPos startSPos = pos.func_177967_a(Direction.SOUTH, 3).func_177982_a(1, 0, 0);
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startSPos.func_177982_a(-i, 0, 0);
            top.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), placePos);
            if (!(rand.nextFloat() < 0.5f)) continue;
            if (rand.nextBoolean()) {
                top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.SOUTH), placePos.func_177972_a(Direction.SOUTH));
                continue;
            }
            top.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), placePos.func_177984_a());
        }
        BlockPos startWPos = pos.func_177967_a(Direction.WEST, 4).func_177982_a(0, 0, 1);
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startWPos.func_177982_a(0, 0, -i);
            top.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), placePos);
            if (!(rand.nextFloat() < 0.5f)) continue;
            if (rand.nextBoolean()) {
                top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.WEST), placePos.func_177972_a(Direction.WEST));
                continue;
            }
            top.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), placePos.func_177984_a());
        }
        BlockPos cornerNW = pos.func_177982_a(-3, 0, -3);
        if (variant != 0) {
            corners.add(cornerNW.func_177972_a(Direction.SOUTH));
            corners.add(cornerNW.func_177972_a(Direction.EAST));
        }
        if (rand.nextFloat() < 0.45f) {
            if (rand.nextBoolean()) {
                top.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), cornerNW.func_177984_a());
            } else {
                if (rand.nextFloat() < 0.5f) {
                    top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.NORTH), cornerNW.func_177972_a(Direction.NORTH));
                }
                if (rand.nextFloat() < 0.5f) {
                    top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.WEST), cornerNW.func_177972_a(Direction.WEST));
                }
            }
        }
        corners.add(cornerNW);
        BlockPos cornerNE = pos.func_177982_a(2, 0, -3);
        if (variant != 1) {
            corners.add(cornerNE.func_177972_a(Direction.SOUTH));
            corners.add(cornerNE.func_177972_a(Direction.WEST));
        }
        if (rand.nextFloat() < 0.45f) {
            if (rand.nextBoolean()) {
                top.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), cornerNE.func_177984_a());
            } else {
                if (rand.nextFloat() < 0.5f) {
                    top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.NORTH), cornerNE.func_177972_a(Direction.NORTH));
                }
                if (rand.nextFloat() < 0.5f) {
                    top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.EAST), cornerNE.func_177972_a(Direction.EAST));
                }
            }
        }
        corners.add(cornerNE);
        BlockPos cornerSE = pos.func_177982_a(2, 0, 2);
        if (variant != 2) {
            corners.add(cornerSE.func_177972_a(Direction.NORTH));
            corners.add(cornerSE.func_177972_a(Direction.WEST));
        }
        if (rand.nextFloat() < 0.45f) {
            if (rand.nextBoolean()) {
                top.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), cornerSE.func_177984_a());
            } else {
                if (rand.nextFloat() < 0.5f) {
                    top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.SOUTH), cornerSE.func_177972_a(Direction.SOUTH));
                }
                if (rand.nextFloat() < 0.5f) {
                    top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.EAST), cornerSE.func_177972_a(Direction.EAST));
                }
            }
        }
        corners.add(cornerSE);
        BlockPos cornerSW = pos.func_177982_a(-3, 0, 2);
        if (variant != 3) {
            corners.add(cornerSW.func_177972_a(Direction.NORTH));
            corners.add(cornerSW.func_177972_a(Direction.EAST));
        }
        if (rand.nextFloat() < 0.45f) {
            if (rand.nextBoolean()) {
                top.addBlockPiece(this.CORROCK_CROWN(false).get().func_185907_a(Rotation.func_222466_a((Random)rand)), cornerSW.func_177984_a());
            } else {
                if (rand.nextFloat() < 0.5f) {
                    top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.SOUTH), cornerSW.func_177972_a(Direction.SOUTH));
                }
                if (rand.nextFloat() < 0.5f) {
                    top.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((IProperty)CorrockCrownWallBlock.FACING, (Comparable)Direction.WEST), cornerSW.func_177972_a(Direction.WEST));
                }
            }
        }
        corners.add(cornerSW);
        for (int x = cornerNW.func_177958_n(); x <= cornerSE.func_177958_n(); ++x) {
            for (int z = cornerNW.func_177952_p(); z <= cornerSE.func_177952_p(); ++z) {
                BlockPos placingPos = new BlockPos(x, pos.func_177956_o(), z);
                if (corners.contains(placingPos)) continue;
                if (!this.isCloseToAnotherGrowth(growths, placingPos.func_177977_b()) && rand.nextFloat() < 0.1f && world.func_175623_d(placingPos) && world.func_175623_d(placingPos.func_177984_a())) {
                    growths.add(new AbstractCorrockFeature.ChorusPlantPart(top, placingPos.func_177977_b(), null));
                    for (Direction direction : Direction.values()) {
                        if (direction == Direction.UP) continue;
                        top.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), placingPos.func_177977_b().func_177972_a(direction));
                    }
                    continue;
                }
                top.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), placingPos.func_177977_b());
            }
        }
        for (BlockPos positions : corners) {
            top.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), positions);
        }
        return Pair.of((Object)top, (Object)growths);
    }

    private void fillUp(GenerationPiece piece, BlockPos pos, int height) {
        for (int i = 0; i < height; ++i) {
            piece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), pos.func_177981_b(i));
        }
    }

    private boolean isCloseToAnotherGrowth(List<AbstractCorrockFeature.ChorusPlantPart> growths, BlockPos pos) {
        for (AbstractCorrockFeature.ChorusPlantPart part : growths) {
            if (!(MathHelper.func_76133_a((double)part.pos.func_177951_i((Vec3i)pos)) < 2.0f)) continue;
            return true;
        }
        return false;
    }
}

