/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.torocraft.torohealth.bars.HealthBarRenderer;

public class BarDisplay {
    private static final ResourceLocation ICON_TEXTURES = new ResourceLocation("textures/gui/icons.png");
    private final Minecraft mc;
    private final AbstractGui gui;

    public BarDisplay(Minecraft mc, AbstractGui gui) {
        this.mc = mc;
        this.gui = gui;
    }

    private String getEntityName(LivingEntity entity) {
        return entity.func_145748_c_().getString();
    }

    public void drawStringWithShadow(FontRenderer textRenderer, String text, int x, int y, int color) {
        this.gui.drawString(textRenderer, text, x, y, color);
    }

    public int drawWithShadow(String text, float x, float y, int color) {
        return this.mc.field_71466_p.func_211126_b(text, x, y, color);
    }

    public void draw(LivingEntity entity) {
        int xOffset = 0;
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        HealthBarRenderer.render(entity, 63.0, 14.0, 130.0f, false);
        String name = this.getEntityName(entity);
        String health = (int)Math.ceil(entity.func_110143_aJ()) + "/" + (int)entity.func_110138_aP();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawStringWithShadow(this.mc.field_71466_p, name, xOffset, 2, 0xFFFFFF);
        this.drawWithShadow(name, xOffset, 2.0f, 0xFFFFFF);
        this.renderHeartIcon(xOffset += this.mc.field_71466_p.func_78256_a(name) + 5, 1);
        this.drawWithShadow(health, xOffset += 10, 2.0f, 0xE0E0E0);
        xOffset += this.mc.field_71466_p.func_78256_a(health) + 5;
        int armor = entity.func_70658_aO();
        if (armor > 0) {
            this.renderArmorIcon(xOffset, 1);
            this.drawWithShadow(armor + "", xOffset += 10, 2.0f, 0xE0E0E0);
        }
    }

    private void renderArmorIcon(int x, int y) {
        this.mc.func_110434_K().func_110577_a(ICON_TEXTURES);
        this.gui.blit(x, y, 34, 9, 9, 9);
    }

    private void renderHeartIcon(int x, int y) {
        this.mc.func_110434_K().func_110577_a(ICON_TEXTURES);
        this.gui.blit(x, y, 52, 0, 9, 9);
    }
}

