/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.torocraft.torohealth.ToroHealth;
import net.torocraft.torohealth.config.Config;
import net.torocraft.torohealth.display.BarDisplay;
import net.torocraft.torohealth.display.EntityDisplay;

public class Hud
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("torohealth:textures/gui/default_skin_basic.png");
    private EntityDisplay entityDisplay = new EntityDisplay();
    private LivingEntity entity;
    private BarDisplay barDisplay;
    private int age;

    public Hud() {
        super((ITextComponent)new StringTextComponent("ToroHealth HUD"));
        this.minecraft = Minecraft.func_71410_x();
        this.barDisplay = new BarDisplay(Minecraft.func_71410_x(), (AbstractGui)this);
    }

    public void draw() {
        float x = this.determineX();
        float y = this.determineY();
        this.draw(x, y, ToroHealth.CONFIG.hud.scale);
    }

    private float determineX() {
        float x = ToroHealth.CONFIG.hud.x;
        Config.AnchorPoint anchor = ToroHealth.CONFIG.hud.anchorPoint;
        float wScreen = this.minecraft.func_228018_at_().func_198107_o();
        switch (anchor) {
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                return wScreen / 2.0f + x;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                return wScreen + x;
            }
        }
        return x;
    }

    private float determineY() {
        float y = ToroHealth.CONFIG.hud.y;
        Config.AnchorPoint anchor = ToroHealth.CONFIG.hud.anchorPoint;
        float hScreen = this.minecraft.func_228018_at_().func_198087_p();
        switch (anchor) {
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                return y + hScreen;
            }
        }
        return y;
    }

    public void tick() {
        ++this.age;
    }

    public void setEntity(LivingEntity entity) {
        if (entity != null) {
            this.age = 0;
        }
        if (entity == null && this.age > ToroHealth.CONFIG.hud.hideDelay) {
            this.setEntityWork(null);
        }
        if (entity != null && entity != this.entity) {
            this.setEntityWork(entity);
        }
    }

    private void setEntityWork(LivingEntity entity) {
        this.entity = entity;
        this.entityDisplay.setEntity(entity);
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    private void draw(float x, float y, float scale) {
        if (this.entity == null) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        RenderSystem.translatef((float)(x - 10.0f), (float)(y - 10.0f), (float)0.0f);
        if (ToroHealth.CONFIG.hud.showSkin) {
            this.drawSkin();
        }
        RenderSystem.translatef((float)10.0f, (float)10.0f, (float)0.0f);
        if (ToroHealth.CONFIG.hud.showEntity) {
            this.entityDisplay.draw();
        }
        RenderSystem.translatef((float)44.0f, (float)0.0f, (float)0.0f);
        if (ToroHealth.CONFIG.hud.showBar) {
            this.barDisplay.draw(this.entity);
        }
        RenderSystem.popMatrix();
    }

    public void drawTexture(int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        Hud.blit((int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
    }

    private void drawSkin() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int w = 160;
        int h = 60;
        this.drawTexture(0, 0, 0.0f, 0.0f, w, h, w, h);
    }
}

