/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.common.capability.chunkloading;

import com.google.common.collect.Lists;
import com.teamabnormals.abnormals_core.common.capability.chunkloading.IChunkLoader;
import com.teamabnormals.abnormals_core.core.library.TaskTickTimer;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;

public class ChunkLoader
implements IChunkLoader {
    @Nullable
    private final ServerWorld world;
    public final List<Long> loadedPositions = Lists.newArrayList();
    private final List<TaskTickTimer<IChunk>> scheduledChunkProcesses = Lists.newArrayList();

    public ChunkLoader(@Nullable ServerWorld world) {
        this.world = world;
    }

    @Override
    public void addPos(BlockPos pos) {
        if (!this.containsPos(pos)) {
            this.forceChunk(pos, true);
            this.loadedPositions.add(pos.func_218275_a());
        }
    }

    @Override
    public void removePos(BlockPos pos) {
        if (this.loadedPositions.remove(pos.func_218275_a())) {
            this.forceChunk(pos, false);
        }
    }

    @Override
    public boolean containsPos(BlockPos pos) {
        return this.loadedPositions.contains(pos.func_218275_a());
    }

    @Override
    public void tick() {
        for (TaskTickTimer<IChunk> process2 : this.scheduledChunkProcesses) {
            process2.update();
        }
        this.scheduledChunkProcesses.removeIf(process -> process.isComplete());
    }

    private void forceChunk(BlockPos pos, boolean load) {
        if (this.world != null) {
            this.world.func_217458_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, load);
        }
    }

    public void scheduleChunkProcess(IChunk chunk, Consumer<IChunk> chunkProcess, int ticks) {
        this.scheduledChunkProcesses.add(new TaskTickTimer<IChunk>(chunk, chunkProcess, ticks));
    }
}

