/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.library.api.conditions;

import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModList;

public class QuarkFlagRecipeCondition
implements ICondition {
    private final ResourceLocation location;
    private final String flag;

    public QuarkFlagRecipeCondition(ResourceLocation location, String flag) {
        this.location = location;
        this.flag = flag;
    }

    public ResourceLocation getID() {
        return this.location;
    }

    public boolean test() {
        if (ModList.get().isLoaded("quark")) {
            JsonObject dummyObject = new JsonObject();
            dummyObject.addProperty("type", "quark:flag");
            dummyObject.addProperty("flag", this.flag);
            return CraftingHelper.getCondition((JsonObject)dummyObject).test();
        }
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<QuarkFlagRecipeCondition> {
        private final ResourceLocation location = new ResourceLocation("abnormals_core", "quark_flag");

        public void write(JsonObject json, QuarkFlagRecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public QuarkFlagRecipeCondition read(JsonObject json) {
            return new QuarkFlagRecipeCondition(this.location, json.getAsJsonPrimitive("flag").getAsString());
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

