/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.library.endimator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teamabnormals.abnormals_core.client.ClientInfo;
import com.teamabnormals.abnormals_core.core.AbnormalsCore;
import com.teamabnormals.abnormals_core.core.library.SimpleTransform;
import com.teamabnormals.abnormals_core.core.library.endimator.Endimation;
import com.teamabnormals.abnormals_core.core.library.endimator.EndimatorModelRenderer;
import com.teamabnormals.abnormals_core.core.library.endimator.entity.IEndimatedEntity;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EndimatorEntityModel<E extends Entity>
extends EntityModel<E> {
    private Map<EndimatorModelRenderer, SimpleTransform> animationBoxValues = Maps.newHashMap();
    private Map<EndimatorModelRenderer, SimpleTransform> prevAnimationBoxValues = Maps.newHashMap();
    public List<EndimatorModelRenderer> savedBoxes = Lists.newArrayList();
    protected E entity;
    private int tickDuration;
    private int prevTickDuration;

    public void animateModel(E endimatedEntity) {
        this.prevTickDuration = 0;
        this.tickDuration = 0;
        this.animationBoxValues.clear();
        this.prevAnimationBoxValues.clear();
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.animateModel(this.entity);
    }

    public void func_225597_a_(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.entity = entity;
        this.revertBoxesToDefaultValues();
    }

    public void addBoxToSavedBoxes(EndimatorModelRenderer box) {
        this.savedBoxes.add(box);
    }

    public void setDefaultBoxValues() {
        this.savedBoxes.forEach(rendererModel -> {
            if (rendererModel instanceof EndimatorModelRenderer) {
                rendererModel.setDefaultBoxValues();
            }
        });
    }

    public void revertBoxesToDefaultValues() {
        this.savedBoxes.forEach(rendererModel -> {
            if (rendererModel instanceof EndimatorModelRenderer) {
                rendererModel.revertToDefaultBoxValues();
            }
        });
    }

    public void setEndimationToPlay(Endimation endimationToPlay) {
        this.updateBoxValueMap();
        this.prevTickDuration = 0;
        this.tickDuration = 0;
        if (((IEndimatedEntity)this.entity).getPlayingEndimation() != endimationToPlay) {
            AbnormalsCore.LOGGER.warn("Endimation to be played doesn't match the Endimation playing on the entity!");
        }
    }

    public boolean tryToPlayEndimation(Endimation endimationToPlay) {
        if (((IEndimatedEntity)this.entity).isEndimationPlaying(endimationToPlay)) {
            this.setEndimationToPlay(endimationToPlay);
            return true;
        }
        return false;
    }

    private void updateBoxValueMap() {
        this.prevAnimationBoxValues.clear();
        this.prevAnimationBoxValues.putAll(this.animationBoxValues);
        this.animationBoxValues.clear();
    }

    public SimpleTransform getBoxValues(EndimatorModelRenderer model) {
        return this.animationBoxValues.computeIfAbsent(model, transform -> SimpleTransform.copy(SimpleTransform.ZERO));
    }

    private boolean shouldApplyTransformToModelRenderers() {
        int animationTick = ((IEndimatedEntity)this.entity).getAnimationTick();
        return animationTick < this.tickDuration && animationTick >= this.prevTickDuration;
    }

    public void startKeyframe(int tickDuration) {
        this.prevTickDuration = this.tickDuration;
        this.tickDuration += tickDuration;
    }

    public void setStaticKeyframe(int tickDuration) {
        this.startKeyframe(tickDuration);
        if (this.shouldApplyTransformToModelRenderers()) {
            this.prevAnimationBoxValues.forEach(SimpleTransform.applyAdditiveTransformToEndimatorModelRenderer());
        }
    }

    public void endKeyframe() {
        if (this.shouldApplyTransformToModelRenderers()) {
            float intermediateTick = ((float)(((IEndimatedEntity)this.entity).getAnimationTick() - this.prevTickDuration) + ClientInfo.getPartialTicks()) / (float)(this.tickDuration - this.prevTickDuration);
            float increment = MathHelper.func_76126_a((float)((float)((double)intermediateTick * Math.PI / 2.0)));
            this.prevAnimationBoxValues.forEach(SimpleTransform.applyAdditiveTransformToEndimatorModelRendererWithMultiplier(1.0f - increment));
            this.animationBoxValues.forEach(SimpleTransform.applyAdditiveTransformToEndimatorModelRendererWithMultiplier(increment));
        }
        this.updateBoxValueMap();
    }

    public void resetKeyframe(int tickDuration) {
        this.startKeyframe(tickDuration);
        this.endKeyframe();
    }

    public void rotate(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).setRotation(x, y, z);
    }

    public void rotateAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).addRotation(x, y, z);
    }

    public void move(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).setPosition(x, y, z);
    }

    public void moveAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).addPosition(x, y, z);
    }

    public void offset(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).setOffset(x, y, z);
    }

    public void offsetAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).addOffset(x, y, z);
    }

    public void scale(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).setScale(x, y, z);
    }

    public void scaleAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).addScale(x, y, z);
    }
}

