/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import net.minecraftforge.installer.ProgressFrame;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.Actions;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Install;
import net.minecraftforge.installer.json.OptionalLibrary;

public class InstallerPanel
extends JPanel {
    private File targetDir;
    private ButtonGroup choiceButtonGroup;
    private JTextField selectedDirText;
    private JLabel infoLabel;
    private JButton sponsorButton;
    private JDialog dialog;
    private JPanel sponsorPanel;
    private JPanel fileEntryPanel;
    private List<OptionalListEntry> optionals = new ArrayList<OptionalListEntry>();
    private Install profile;
    private Map<String, Function<ProgressCallback, Action>> actions = new HashMap<String, Function<ProgressCallback, Action>>();

    public static byte[] hexToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private BufferedImage getImage(String path, String default_) {
        try {
            InputStream in = SimpleInstaller.class.getResourceAsStream(path);
            if (in == null && default_ != null) {
                in = new ByteArrayInputStream(InstallerPanel.hexToByteArray(default_));
            }
            return ImageIO.read(in);
        }
        catch (IOException e) {
            if (default_ == null) {
                throw new RuntimeException(e);
            }
            return new BufferedImage(32, 32, 2);
        }
    }

    public InstallerPanel(File targetDir, Install profile) {
        this.profile = profile;
        if (this.profile.getSpec() != 0) {
            JOptionPane.showMessageDialog(null, "Invalid launcher profile spec: " + profile.getSpec() + " Only 0 is supported, Whoever package this installer messed up.", "Error", 0);
            System.exit(1);
        }
        this.setLayout(new BoxLayout(this, 1));
        BufferedImage image = this.getImage(profile.getLogo(), null);
        JPanel logoSplash = new JPanel();
        logoSplash.setLayout(new BoxLayout(logoSplash, 1));
        ImageIcon icon = new ImageIcon(image);
        JLabel logoLabel = new JLabel(icon);
        logoLabel.setAlignmentX(0.5f);
        logoLabel.setAlignmentY(0.5f);
        logoLabel.setSize(image.getWidth(), image.getHeight());
        logoSplash.add(logoLabel);
        JLabel tag = new JLabel(profile.getWelcome());
        tag.setAlignmentX(0.5f);
        tag.setAlignmentY(0.5f);
        logoSplash.add(tag);
        tag = new JLabel(profile.getVersion());
        tag.setAlignmentX(0.5f);
        tag.setAlignmentY(0.5f);
        logoSplash.add(tag);
        logoSplash.setAlignmentX(0.5f);
        logoSplash.setAlignmentY(0.0f);
        this.add(logoSplash);
        this.sponsorPanel = new JPanel();
        this.sponsorPanel.setLayout(new BoxLayout(this.sponsorPanel, 0));
        this.sponsorPanel.setAlignmentX(0.5f);
        this.sponsorPanel.setAlignmentY(0.5f);
        this.sponsorButton = new JButton();
        this.sponsorButton.setAlignmentX(0.5f);
        this.sponsorButton.setAlignmentY(0.5f);
        this.sponsorButton.setBorderPainted(false);
        this.sponsorButton.setOpaque(false);
        this.sponsorButton.addActionListener(e -> this.openURL(this.sponsorButton.getToolTipText()));
        this.sponsorPanel.add(this.sponsorButton);
        this.add(this.sponsorPanel);
        this.choiceButtonGroup = new ButtonGroup();
        JPanel choicePanel = new JPanel();
        choicePanel.setLayout(new BoxLayout(choicePanel, 1));
        boolean first = true;
        SelectButtonAction sba = new SelectButtonAction();
        for (Actions action : Actions.values()) {
            if (action == Actions.CLIENT && profile.hideClient() || action == Actions.SERVER && profile.hideServer() || action == Actions.EXTRACT && profile.hideExtract()) continue;
            this.actions.put(action.name(), prog -> action.getAction(profile, (ProgressCallback)prog));
            JRadioButton radioButton = new JRadioButton();
            radioButton.setAction(sba);
            radioButton.setText(action.getButtonLabel());
            radioButton.setActionCommand(action.name());
            radioButton.setToolTipText(action.getTooltip());
            radioButton.setSelected(first);
            radioButton.setAlignmentX(0.0f);
            radioButton.setAlignmentY(0.5f);
            this.choiceButtonGroup.add(radioButton);
            choicePanel.add(radioButton);
            first = false;
        }
        choicePanel.setAlignmentX(1.0f);
        choicePanel.setAlignmentY(0.5f);
        this.add(choicePanel);
        JPanel entryPanel = new JPanel();
        entryPanel.setLayout(new BoxLayout(entryPanel, 0));
        this.targetDir = targetDir;
        this.selectedDirText = new JTextField();
        this.selectedDirText.setEditable(false);
        this.selectedDirText.setToolTipText("Path to minecraft");
        this.selectedDirText.setColumns(30);
        entryPanel.add(this.selectedDirText);
        JButton dirSelect = new JButton();
        dirSelect.setAction(new FileSelectAction());
        dirSelect.setText("...");
        dirSelect.setToolTipText("Select an alternative minecraft directory");
        entryPanel.add(dirSelect);
        entryPanel.setAlignmentX(0.0f);
        entryPanel.setAlignmentY(0.0f);
        this.infoLabel = new JLabel();
        this.infoLabel.setHorizontalTextPosition(2);
        this.infoLabel.setVerticalTextPosition(1);
        this.infoLabel.setAlignmentX(0.0f);
        this.infoLabel.setAlignmentY(0.0f);
        this.infoLabel.setForeground(Color.RED);
        this.infoLabel.setVisible(false);
        this.fileEntryPanel = new JPanel();
        this.fileEntryPanel.setLayout(new BoxLayout(this.fileEntryPanel, 1));
        this.fileEntryPanel.add(this.infoLabel);
        this.fileEntryPanel.add(Box.createVerticalGlue());
        this.fileEntryPanel.add(entryPanel);
        this.fileEntryPanel.setAlignmentX(0.5f);
        this.fileEntryPanel.setAlignmentY(0.0f);
        this.add(this.fileEntryPanel);
        this.updateFilePath();
    }

    private void updateFilePath() {
        try {
            this.targetDir = this.targetDir.getCanonicalFile();
            this.selectedDirText.setText(this.targetDir.getPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Action action = this.actions.get(this.choiceButtonGroup.getSelection().getActionCommand()).apply(null);
        boolean valid = action.isPathValid(this.targetDir);
        if (this.profile.getMirror() != null) {
            this.sponsorButton.setText(action.getSponsorMessage());
            this.sponsorButton.setToolTipText(this.profile.getMirror().getHomepage());
            if (this.profile.getMirror().getImageAddress() != null) {
                this.sponsorButton.setIcon(this.profile.getMirror().getImage());
            } else {
                this.sponsorButton.setIcon(null);
            }
            this.sponsorPanel.setVisible(true);
        } else {
            this.sponsorPanel.setVisible(false);
        }
        if (valid) {
            this.selectedDirText.setForeground(null);
            this.infoLabel.setVisible(false);
            this.fileEntryPanel.setBorder(null);
        } else {
            this.selectedDirText.setForeground(Color.RED);
            this.fileEntryPanel.setBorder(new LineBorder(Color.RED));
            this.infoLabel.setText("<html>" + action.getFileError(this.targetDir) + "</html>");
            this.infoLabel.setVisible(true);
        }
        if (this.dialog != null) {
            this.dialog.invalidate();
            this.dialog.pack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ProgressCallback monitor) {
        JOptionPane optionPane = new JOptionPane(this, -1, 2);
        this.dialog = optionPane.createDialog("Mod system installer");
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setVisible(true);
        int result = (Integer)(optionPane.getValue() != null ? optionPane.getValue() : Integer.valueOf(-1));
        if (result == 0) {
            ProgressFrame prog = new ProgressFrame(monitor, "Installing " + this.profile.getVersion(), Thread.currentThread()::interrupt);
            SimpleInstaller.hookStdOut(prog);
            Predicate<String> optPred = input -> {
                Optional<OptionalListEntry> ent = this.optionals.stream().filter(e -> e.lib.getArtifact().equals(input)).findFirst();
                return !ent.isPresent() || ent.get().isEnabled();
            };
            Action action = this.actions.get(this.choiceButtonGroup.getSelection().getActionCommand()).apply(prog);
            try {
                prog.setVisible(true);
                prog.toFront();
                if (action.run(this.targetDir, optPred)) {
                    prog.start("Finished!");
                    prog.progress(1.0);
                    JOptionPane.showMessageDialog(null, action.getSuccessMessage(), "Complete", 1);
                }
            }
            catch (ActionCanceledException e) {
                JOptionPane.showMessageDialog(null, "Installation Canceled", "Forge Installer", 2);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "There was an exception running task: " + e.toString(), "Error", 0);
                e.printStackTrace();
            }
            finally {
                prog.dispose();
                SimpleInstaller.hookStdOut(monitor);
            }
        }
        this.dialog.dispose();
    }

    private void openURL(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstallerPanel.this.dialog.toFront();
                    InstallerPanel.this.dialog.requestFocus();
                }
            });
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "An error occurred launching the browser", "Error launching browser", 0);
        }
    }

    private static class OptionalListEntry {
        OptionalLibrary lib;
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private class SelectButtonAction
    extends AbstractAction {
        private SelectButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstallerPanel.this.updateFilePath();
        }
    }

    private class FileSelectAction
    extends AbstractAction {
        private FileSelectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser dirChooser = new JFileChooser();
            dirChooser.setFileSelectionMode(1);
            dirChooser.setFileHidingEnabled(false);
            dirChooser.ensureFileIsVisible(InstallerPanel.this.targetDir);
            dirChooser.setSelectedFile(InstallerPanel.this.targetDir);
            int response = dirChooser.showOpenDialog(InstallerPanel.this);
            switch (response) {
                case 0: {
                    InstallerPanel.this.targetDir = dirChooser.getSelectedFile();
                    InstallerPanel.this.updateFilePath();
                    break;
                }
            }
        }
    }
}

