/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.islands.config;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlWriter;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class WeightConfig {
    private static final Path CONFIG_PATH = Paths.get("config", "islands-weights.toml");
    public static final WeightConfig INSTANCE = new WeightConfig();
    private static CommentedFileConfig config;
    private HashMap<ResourceLocation, Integer> islandBiomesWeight;
    private HashMap<ResourceLocation, Integer> oceanBiomesWeight;

    public void setup() {
        config = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG_PATH).sync().autoreload().writingMode(WritingMode.REPLACE).build();
        this.islandBiomesWeight = new HashMap();
        this.oceanBiomesWeight = new HashMap();
        this.updateBiomes();
    }

    public void updateBiomes() {
        config.load();
        config.setComment("islands", "List of biomes and their weights, by default everything is set to 5 with a range of 0 - 10 as integers.\nThe list will also display modded biomes however it will not remove them once said mod is removed! The line(s) for the mod's biomes will not have any effect however\n\nTIP: Use CTRL+F (Find) to easily find the biome you're looking for");
        Predicate<Biome> isNotOceanPredicate = biome -> biome.func_201856_r() != Biome.Category.OCEAN;
        ArrayList islandsList = (ArrayList)new ArrayList(ForgeRegistries.BIOMES.getValues()).stream().filter(isNotOceanPredicate).collect(Collectors.toList());
        for (Biome biome2 : islandsList) {
            String path = "islands." + biome2.getRegistryName().toString();
            int val = 5;
            if (config.get(path) == null) {
                config.set(path, (Object)5);
            } else {
                val = config.getInt(path);
                if (val < 0 || val > 10) {
                    val = MathHelper.func_76125_a((int)val, (int)0, (int)10);
                    config.set(path, (Object)val);
                }
            }
            this.islandBiomesWeight.put(biome2.getRegistryName(), val);
        }
        config.setComment("oceans", "List of biomes and their weights, by default everything is set to 5 with a range of 1 - 10 as integers.\nThe list will also display modded biomes however it will not remove them once said mod is removed! The line(s) for the mod's biomes will not have any effect however\nTIP: Use CTRL+F (Find) to easily find the biome you're looking for");
        Predicate<Biome> isOceanPredicate = biome -> biome.func_201856_r() == Biome.Category.OCEAN;
        ArrayList oceansList = (ArrayList)new ArrayList(ForgeRegistries.BIOMES.getValues()).stream().filter(isOceanPredicate).collect(Collectors.toList());
        for (Biome biome3 : oceansList) {
            String path = "oceans." + biome3.getRegistryName().toString();
            int val = 5;
            if (config.get(path) == null) {
                config.set(path, (Object)5);
            } else {
                val = config.getInt(path);
                if (val < 0 || val > 10) {
                    val = MathHelper.func_76125_a((int)val, (int)0, (int)10);
                    config.set(path, (Object)val);
                }
            }
            this.oceanBiomesWeight.put(biome3.getRegistryName(), val);
        }
        config.close();
        File configFile = new File(CONFIG_PATH.toString());
        TomlWriter writer = new TomlWriter();
        writer.write((UnmodifiableConfig)config, configFile, WritingMode.REPLACE);
    }

    public int getIslandBiomeWeight(ResourceLocation key) {
        if (this.islandBiomesWeight.containsKey(key)) {
            return this.islandBiomesWeight.get(key);
        }
        return 5;
    }

    public int getOceanBiomeWeight(ResourceLocation key) {
        if (this.oceanBiomesWeight.containsKey(key)) {
            return this.oceanBiomesWeight.get(key);
        }
        return 5;
    }
}

